/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class CDVerifyDlg
extends ModulePanel {
    private static final int PR_ORIGINFILE = 0;
    private static final int PR_COPYINFILE = 1;
    private static final int PR_MAXGAP = 0;
    private static final int PR_BITTOGGLE = 0;
    private static final int PR_QUICKABORT = 1;
    private static final String PRN_ORIGINFILE = "OrigInFile";
    private static final String PRN_COPYINFILE = "CopyInFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_MAXGAP = "MaxGap";
    private static final String PRN_BITTOGGLE = "BitToggle";
    private static final String PRN_QUICKABORT = "QuickAbort";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"OrigInFile", "CopyInFile", "OutputFile"};
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"MaxGap"};
    private static final boolean[] prBool = new boolean[]{true, false};
    private static final String[] prBoolName = new String[]{"BitToggle", "QuickAbort"};
    private static final int GG_ORIGINFILE = 1024;
    private static final int GG_COPYINFILE = 1025;
    private static final int GG_MAXGAP = 512;
    private static final int GG_BITTOGGLE = 0;
    private static final int GG_QUICKABORT = 1;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_TOOSHORT = "Input file too short!";
    private static final String ERR_SYNCFAILED = "Failed to synchronize inputs!";
    private static final String ERR_DIFFERENTCHAN = "Input files have different number of channels!";

    public CDVerifyDlg() {
        super("CD Verification");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            CDVerifyDlg.static_pr.text = prText;
            CDVerifyDlg.static_pr.textName = prTextName;
            CDVerifyDlg.static_pr.bool = prBool;
            CDVerifyDlg.static_pr.boolName = prBoolName;
            CDVerifyDlg.static_pr.para = prPara;
            CDVerifyDlg.static_pr.para[0] = new Param(20.0, 2);
            CDVerifyDlg.static_pr.paraName = prParaName;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select original input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Original input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select re-imported (burned) input file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Re-imported (copy) input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.addLabel(new GroupLabel("Verfication Settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Max. Start Gap", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 512, null);
        JCheckBox jCheckBox = new JCheckBox("Ignore LSB toggle");
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 2;
        this.gui.addLabel(new JLabel());
        JCheckBox jCheckBox2 = new JCheckBox("Quick Abort");
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox2, 1, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() {
        AudioFile audioFile = null;
        AudioFile audioFile2 = null;
        Object var12_3 = null;
        try {
            int n;
            int n2;
            int n3;
            audioFile = AudioFile.openAsRead((File)new File(this.pr.text[0]));
            audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
            AudioFileDescr audioFileDescr = audioFile.getDescr();
            AudioFileDescr audioFileDescr2 = audioFile2.getDescr();
            if (audioFileDescr.channels != audioFileDescr2.channels) {
                throw new IOException(ERR_DIFFERENTCHAN);
            }
            int n4 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[0].value) + 0.5);
            if ((long)n4 > audioFileDescr.length - 8192L) {
                throw new IOException(ERR_TOOSHORT);
            }
            float[][] fArray = new float[audioFileDescr.channels][8192];
            float[][] fArray2 = new float[audioFileDescr.channels][8192 + n4];
            long l = 0L;
            long l2 = 0L;
            audioFile.seekFrame(l);
            int n5 = 0;
            int n6 = 0;
            float f = this.pr.bool[0] ? 6.103517E-5f : 0.0f;
            long l3 = 0L;
            long l4 = audioFileDescr2.length;
            do {
                if ((n5 = (int)Math.min(8192L, Math.min(audioFileDescr2.length - (l2 += (long)n5) - (long)n4, audioFileDescr.length - (l += (long)n5)))) <= 0) {
                    throw new IOException(ERR_SYNCFAILED);
                }
                audioFile.readFrames(fArray, 0, n5);
                audioFile2.seekFrame(l2);
                audioFile2.readFrames(fArray2, 0, n5 + n4);
                n3 = 0;
                block8: for (n2 = 0; n2 < n4; ++n2) {
                    for (n = 0; n < fArray.length; ++n) {
                        int n7 = 0;
                        int n8 = n2;
                        while (n7 < n5) {
                            if (Math.abs(fArray[n][n7] - fArray2[n][n8]) > f) continue block8;
                            ++n7;
                            ++n8;
                        }
                    }
                    ++n3;
                    n6 = n2;
                }
                if (n3 == 0 && l2 > (long)n4) {
                    throw new IOException(ERR_SYNCFAILED);
                }
                this.setProgression((float)(l3 += (long)n5) / (float)l4);
            } while (n3 != 1 && this.threadRunning);
            if (this.threadRunning) {
                long l5;
                System.err.println("synced with " + n6 + " frames offset!");
                long l6 = 0L;
                float f2 = 0.0f;
                long l7 = 0L;
                l4 = l3 + l5;
                audioFile.seekFrame(l);
                audioFile2.seekFrame(l2);
                block11: for (l5 = Math.min(audioFileDescr2.length - (l2 += (long)n6), audioFileDescr.length - l); this.threadRunning && l5 > 0L; l5 -= (long)n5) {
                    n5 = (int)Math.min(8192L, l5);
                    audioFile.readFrames(fArray, 0, n5);
                    audioFile2.readFrames(fArray2, 0, n5);
                    for (n2 = 0; n2 < fArray.length; ++n2) {
                        for (n = 0; n < n5; ++n) {
                            float f3 = Math.abs(fArray[n2][n] - fArray2[n2][n]);
                            if (!(f3 > f)) continue;
                            ++l6;
                            if (f3 > f2) {
                                f2 = f3;
                                l7 = audioFile2.getFramePosition() - (long)n5 + (long)n;
                            }
                            if (this.pr.bool[1]) break block11;
                        }
                    }
                    this.setProgression((float)(l3 += (long)n5) / (float)l4);
                }
                if (this.threadRunning) {
                    if (l6 > 0L) {
                        this.setError(new Exception(l6 + " samples were not verified (max amp " + Math.log(f2) / 2.302585092994046 * 20.0 + " dBFS at frame offset " + l7 + ")!"));
                    } else {
                        System.err.println("Successfully verified");
                        this.setProgression(1.0f);
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
        finally {
            if (audioFile != null) {
                audioFile.cleanUp();
            }
            if (audioFile2 != null) {
                audioFile2.cleanUp();
            }
            if (var12_3 != null) {
                var12_3.cleanUp();
            }
        }
    }
}

