/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class CombFilterDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_GAIN = 0;
    private static final int PR_FREQ = 1;
    private static final int PR_QUALITY = 2;
    private static final int PR_DRYMIX = 3;
    private static final int PR_WETMIX = 4;
    private static final int PR_DRYINVERT = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FREQ = "Freq";
    private static final String PRN_QUALITY = "Quality";
    private static final String PRN_DRYMIX = "DryMix";
    private static final String PRN_WETMIX = "WetMix";
    private static final String PRN_DRYINVERT = "DryInvert";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "Freq", "Quality", "DryMix", "WetMix"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"DryInvert"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_FREQ = 513;
    private static final int GG_QUALITY = 514;
    private static final int GG_DRYMIX = 515;
    private static final int GG_WETMIX = 516;
    private static final int GG_DRYINVERT = 0;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_FREQ = "Illegal frequency!";

    public CombFilterDlg() {
        super("Comb Filter");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            CombFilterDlg.static_pr.text = prText;
            CombFilterDlg.static_pr.textName = prTextName;
            CombFilterDlg.static_pr.intg = prIntg;
            CombFilterDlg.static_pr.intgName = prIntgName;
            CombFilterDlg.static_pr.bool = prBool;
            CombFilterDlg.static_pr.boolName = prBoolName;
            CombFilterDlg.static_pr.para = prPara;
            CombFilterDlg.static_pr.para[1] = new Param(50.0, 3);
            CombFilterDlg.static_pr.para[2] = new Param(20.0, 17);
            CombFilterDlg.static_pr.para[3] = new Param(0.0, 17);
            CombFilterDlg.static_pr.para[4] = new Param(100.0, 17);
            CombFilterDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(CombFilterDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(CombFilterDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Comb$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.gui.addLabel(new GroupLabel("Filter Settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Base freq.", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        gridBagConstraints.weightx = 0.1;
        ParamField paramField2 = new ParamField(Constants.spaces[5]);
        this.gui.addLabel(new JLabel(PRN_QUALITY, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 514, null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        ParamField paramField3 = new ParamField(Constants.spaces[5]);
        this.gui.addLabel(new JLabel("Dry mix", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 515, null);
        JCheckBox jCheckBox = new JCheckBox("Invert");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, null);
        ParamField paramField4 = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Wet mix", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField4, 516, null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new JLabel(""));
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        block29: {
            float[] fArray;
            float[] fArray2;
            float[] fArray3;
            float[][] fArray4;
            float[][] fArray5;
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            floatFileArray = null;
            fileArray = null;
            Param param = new Param(1.0, 1);
            float f = 0.0f;
            try {
                float f2;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile2.getDescr();
                int n2 = audioFileDescr.channels;
                int n3 = (int)audioFileDescr.length;
                if (n3 * n2 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block29;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                float f3 = (float)Param.transform((Param)this.pr.para[4], (int)1, (Param)param, null).value;
                float f4 = (float)Param.transform((Param)this.pr.para[3], (int)1, (Param)param, null).value;
                float f5 = (float)Param.transform((Param)this.pr.para[2], (int)1, (Param)param, null).value;
                int n4 = (int)(audioFileDescr.rate / this.pr.para[1].value + 0.5);
                if (n4 == 0 || this.pr.para[1].value == 0.0) {
                    throw new IOException(ERR_FREQ);
                }
                if (this.pr.bool[0]) {
                    f4 = -f4;
                }
                long l = 0L;
                long l2 = (long)n3 * 2L;
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n2];
                    floatFileArray = new FloatFile[n2];
                    for (n = 0; n < n2; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n2; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n3;
                } else {
                    f2 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                    f3 *= f2;
                    f4 *= f2;
                }
                if (!this.threadRunning) break block29;
                float f6 = 1.0f * f3 + 1.0f * f4;
                float f7 = 1.0f * f3;
                float f8 = -1.0f + f5;
                fArray5 = new float[n2][n4 + 8192];
                fArray4 = new float[n2][n4 + 8192];
                fArray3 = new float[8192];
                Util.clear(fArray5);
                Util.clear(fArray4);
                int n5 = 0;
                int n6 = 0;
                while (this.threadRunning && n6 < n3) {
                    int n7 = Math.min(8192, n3 - n5);
                    audioFile2.readFrames(fArray5, n4, n7);
                    n5 += n7;
                    this.setProgression((float)(l += (long)n7) / (float)l2);
                    if (this.threadRunning) {
                        for (n = 0; n < n2; ++n) {
                            fArray2 = fArray5[n];
                            fArray = fArray4[n];
                            int n8 = 0;
                            int n9 = n4;
                            while (n8 < n7) {
                                float f9;
                                fArray[n9] = f9 = f6 * fArray2[n9] + f7 * fArray2[n8] + f8 * fArray[n8];
                                if (Math.abs(f9) > f) {
                                    f = Math.abs(f9);
                                }
                                ++n8;
                                ++n9;
                            }
                        }
                        if (floatFileArray != null) {
                            for (n = 0; n < n2; ++n) {
                                floatFileArray[n].writeFloats(fArray4[n], n4, n7);
                            }
                        } else {
                            audioFile.writeFrames(fArray4, n4, n7);
                        }
                        n6 += n7;
                        this.setProgression((float)(l += (long)n7) / (float)l2);
                        for (n = 0; n < n2; ++n) {
                            fArray2 = fArray5[n];
                            fArray = fArray4[n];
                            Util.rotate(fArray2, fArray2.length, fArray3, -n7);
                            Util.rotate(fArray, fArray.length, fArray3, -n7);
                        }
                        continue;
                    }
                    break block29;
                }
                if (this.threadRunning) {
                    if (this.pr.intg[2] == 0) {
                        f2 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f), (int)1), null).value;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray4, f2, 1.0f);
                        f *= f2;
                        for (n = 0; n < n2; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        audioFileDescr2 = null;
                        audioFile2.close();
                        audioFile2 = null;
                        audioFileDescr = null;
                        fArray5 = null;
                        fArray4 = null;
                        fArray3 = null;
                        fArray2 = null;
                        fArray = null;
                        this.handleClipping(f);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                fArray5 = null;
                fArray4 = null;
                fArray3 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                    floatFileArray[n] = null;
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
                fileArray[n] = null;
            }
        }
    }
}

