/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.gui.SoundChunk;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConcatDlg
extends ModulePanel {
    private static final int PR_INPUTFILE1 = 0;
    private static final int PR_INPUTFILE2 = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_FADESHAPE = 3;
    private static final int PR_FADETYPE = 4;
    private static final int PR_GAIN = 0;
    private static final int PR_OFFSET = 1;
    private static final int PR_LENGTH = 2;
    private static final int PR_OVERLAP = 3;
    private static final int PR_FADE = 4;
    private static final String PRN_INPUTFILE1 = "InputFile1";
    private static final String PRN_INPUTFILE2 = "InputFile2";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FADESHAPE = "FadeShape";
    private static final String PRN_FADETYPE = "FadeType";
    private static final String PRN_OFFSET = "Offset";
    private static final String PRN_LENGTH = "Length";
    private static final String PRN_OVERLAP = "Overlap";
    private static final String PRN_FADE = "Fade";
    protected static final String[] SHAPE_NAMES = new String[]{"Normal", "Fast in", "Slow in", "Easy in Easy out"};
    private static final int SHAPE_NORMAL = 0;
    private static final String[] TYPE_NAMES = new String[]{"Equal Energy", "Equal Power"};
    private static final int TYPE_ENERGY = 0;
    private static final int TYPE_POWER = 1;
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile1", "InputFile2", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0, 1};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "FadeShape", "FadeType"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "Offset", "Length", "Overlap", "Fade"};
    private static final int GG_INPUTFILE1 = 1024;
    private static final int GG_INPUTFILE2 = 1025;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_FADESHAPE = 259;
    private static final int GG_FADETYPE = 260;
    private static final int GG_GAIN = 512;
    private static final int GG_OFFSET = 513;
    private static final int GG_LENGTH = 514;
    private static final int GG_OVERLAP = 515;
    private static final int GG_FADE = 516;
    private static final int GG_CURRENTINFO = 2048;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_NOFILES = "No files detected";
    private static final String FILENAMEPTRN = "{1}{0}{2}";
    private Object[] fileNameArgs = new Object[5];
    private boolean usePad;
    private boolean reverse;

    public ConcatDlg() {
        super("Concat");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ConcatDlg.static_pr.text = prText;
            ConcatDlg.static_pr.textName = prTextName;
            ConcatDlg.static_pr.intg = prIntg;
            ConcatDlg.static_pr.intgName = prIntgName;
            ConcatDlg.static_pr.para = prPara;
            ConcatDlg.static_pr.para[1] = new Param(0.0, 2);
            ConcatDlg.static_pr.para[2] = new Param(100.0, 18);
            ConcatDlg.static_pr.para[3] = new Param(0.0, 18);
            ConcatDlg.static_pr.para[4] = new Param(0.0, 18);
            ConcatDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(ConcatDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(ConcatDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = ConcatDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: 
                    case 1025: {
                        ((ConcatDlg)ConcatDlg.this).pr.text[n - 1024] = ((PathField)pathEvent.getSource()).getPath().getPath();
                        if (n == 1024) {
                            ConcatDlg.this.setInput(((ConcatDlg)ConcatDlg.this).pr.text[n - 1024]);
                        }
                        ConcatDlg.this.analyseFileNames();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select first input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("First input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, pathListener);
        PathField pathField2 = new PathField(16, "Select first input file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Last input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, pathListener);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setBackground(null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Current input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addTextField(jTextField, 2048, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField3.deriveFrom(pathFieldArray, "$D0$F0CC$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, pathListener);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.gui.addLabel(new GroupLabel("Scissor Settings", 1, 0));
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9], Constants.spaces[11]};
        ParamSpace[] paramSpaceArray2 = new ParamSpace[6];
        paramSpaceArray2[0] = Constants.spaces[8];
        ParamSpace paramSpace = new ParamSpace(Constants.spaces[12]);
        paramSpaceArray2[1] = paramSpace = new ParamSpace(paramSpace.min, 0.0, paramSpace.inc, paramSpace.unit);
        paramSpaceArray2[2] = Constants.spaces[9];
        paramSpace = new ParamSpace(Constants.spaces[13]);
        paramSpaceArray2[3] = paramSpace = new ParamSpace(paramSpace.min, 0.0, paramSpace.inc, paramSpace.unit);
        paramSpace = new ParamSpace(Constants.spaces[14]);
        paramSpaceArray2[4] = paramSpace = new ParamSpace(paramSpace.min, 0.0, paramSpace.inc, paramSpace.unit);
        paramSpaceArray2[5] = Constants.spaces[11];
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        ParamField paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Chunk Offset", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        ParamField paramField2 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Chunk Length", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 514, null);
        ParamField paramField3 = new ParamField(paramSpaceArray2);
        paramField3.setReference(paramField2);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Chunk Overlap", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 515, null);
        ParamField paramField4 = new ParamField(paramSpaceArray);
        paramField4.setReference(paramField3);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Overlap Cross-fade", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 516, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEnabled(false);
        for (n = 0; n < SHAPE_NAMES.length; ++n) {
            jComboBox.addItem(SHAPE_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Cross-fade Shape", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 259, null);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < TYPE_NAMES.length; ++n) {
            jComboBox2.addItem(TYPE_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Cross-fade Type", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 260, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        int n2;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        SoundChunk[] soundChunkArray;
        block55: {
            float[] fArray;
            float[][] fArray2;
            soundChunkArray = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            floatFileArray = null;
            fileArray = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            float f2 = 0.0f;
            Vector<SoundChunk> vector = new Vector<SoundChunk>();
            try {
                int n3;
                int n4 = this.analyseFileNames();
                if (n4 <= 0) {
                    throw new EOFException(ERR_NOFILES);
                }
                soundChunkArray = new SoundChunk[n4];
                long l = 0L;
                long l2 = n4 * 25;
                int n5 = 1;
                int n6 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    soundChunkArray[n2] = new SoundChunk();
                    soundChunkArray[n2].name = this.synthesizeFileName(this.reverse ? n4 - n2 - 1 : n2);
                    this.gui.stringToJTextField("Opening '" + soundChunkArray[n2].name + "'...", 2048);
                    soundChunkArray[n2].f = AudioFile.openAsRead((File)new File(soundChunkArray[n2].name));
                    soundChunkArray[n2].stream = soundChunkArray[n2].f.getDescr();
                    if (soundChunkArray[n2].stream.channels <= 0) {
                        throw new EOFException("File is empty");
                    }
                    n5 = Math.max(n5, soundChunkArray[n2].stream.channels);
                    Param param2 = new Param(AudioFileDescr.samplesToMillis((AudioFileDescr)soundChunkArray[n2].stream, (long)soundChunkArray[n2].stream.length), 2);
                    soundChunkArray[n2].off = (int)Math.max(0L, Math.min(soundChunkArray[n2].stream.length, (long)((int)(AudioFileDescr.millisToSamples((AudioFileDescr)soundChunkArray[n2].stream, (double)Param.transform((Param)this.pr.para[1], (int)2, (Param)param2, null).value) + 0.5))));
                    soundChunkArray[n2].len = (int)Math.max(0L, Math.min(soundChunkArray[n2].stream.length - (long)soundChunkArray[n2].off, (long)((int)(AudioFileDescr.millisToSamples((AudioFileDescr)soundChunkArray[n2].stream, (double)Param.transform((Param)this.pr.para[2], (int)2, (Param)param2, null).value) + 0.5))));
                    param2 = new Param(AudioFileDescr.samplesToMillis((AudioFileDescr)soundChunkArray[n2].stream, (long)soundChunkArray[n2].len), 2);
                    soundChunkArray[n2].over = Math.max(0, Math.min(soundChunkArray[n2].len, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)soundChunkArray[n2].stream, (double)Param.transform((Param)this.pr.para[3], (int)2, (Param)param2, null).value) + 0.5)));
                    param2 = new Param(AudioFileDescr.samplesToMillis((AudioFileDescr)soundChunkArray[n2].stream, (long)soundChunkArray[n2].over), 2);
                    n3 = Math.max(0, Math.min(soundChunkArray[n2].over, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)soundChunkArray[n2].stream, (double)Param.transform((Param)this.pr.para[4], (int)2, (Param)param2, null).value) + 0.5)));
                    if (n2 > 0) {
                        soundChunkArray[n2 - 1].fadeOut = soundChunkArray[n2].fadeIn = Math.min(n3, soundChunkArray[n2 - 1].fadeOut);
                        soundChunkArray[n2].punchIn = soundChunkArray[n2 - 1].punchIn + soundChunkArray[n2 - 1].len - soundChunkArray[n2 - 1].over;
                    } else {
                        soundChunkArray[n2].fadeIn = 0;
                        soundChunkArray[n2].punchIn = 0;
                    }
                    soundChunkArray[n2].fadeOut = Math.min(n3, soundChunkArray[n2].len - soundChunkArray[n2].fadeIn);
                    n6 = Math.max(n6, soundChunkArray[n2].punchIn + soundChunkArray[n2].len);
                    this.setProgression((float)(++l) / (float)l2);
                    if (this.threadRunning) {
                        continue;
                    }
                    break block55;
                }
                soundChunkArray[n4 - 1].fadeOut = 0;
                PathField pathField = (PathField)this.gui.getItemObj(1026);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(soundChunkArray[0].stream);
                pathField.fillStream(audioFileDescr);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (this.threadRunning) {
                    float[][] fArray3 = new float[n5][8192];
                    fArray2 = new float[n5][8192];
                    l2 = (long)n6 * (long)(this.pr.intg[2] == 0 ? 3 : 2);
                    double d = this.getProgression();
                    l = (long)((double)l2 * d / (1.0 - d));
                    l2 += l;
                    if (this.pr.intg[2] == 0) {
                        fileArray = new File[n5];
                        floatFileArray = new FloatFile[n5];
                        for (n = 0; n < n5; ++n) {
                            fileArray[n] = null;
                            floatFileArray[n] = null;
                        }
                        for (n = 0; n < n5; ++n) {
                            fileArray[n] = IOUtil.createTempFile();
                            floatFileArray[n] = new FloatFile(fileArray[n], 1);
                        }
                    } else {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                    }
                    if (this.threadRunning) {
                        int n7;
                        int n8 = 0;
                        for (int i = 0; this.threadRunning && i < n6; i += n7) {
                            float f3;
                            n7 = Math.min(8192, n6 - i);
                            Util.clear(fArray2);
                            while (n8 < n4 && soundChunkArray[n8].punchIn < i + n7) {
                                vector.addElement(soundChunkArray[n8]);
                                this.gui.stringToJTextField("Concatening '" + soundChunkArray[n8].name + "'...", 2048);
                                soundChunkArray[n8].f.seekFrame((long)soundChunkArray[n8].off);
                                ++n8;
                            }
                            for (n2 = 0; n2 < vector.size(); ++n2) {
                                int n9;
                                float f4;
                                float f5;
                                int n10;
                                SoundChunk soundChunk = (SoundChunk)vector.elementAt(n2);
                                int n11 = soundChunk.punchIn - i;
                                n3 = Math.max(0, n11);
                                int n12 = Math.min(n7, n11 + soundChunk.len);
                                soundChunk.f.readFrames(fArray3, n3, n12 - n3);
                                int n13 = n11 + soundChunk.fadeIn;
                                if (n13 > n3) {
                                    n10 = n13;
                                    n13 = Math.min(n13, n7);
                                    f5 = 1.0f - (float)(n10 - n13) / (float)soundChunk.fadeIn;
                                    f4 = (float)(n3 - n11) / (float)soundChunk.fadeIn;
                                    f3 = (f5 - f4) / (float)(n13 - n3 - 1);
                                    switch (this.pr.intg[4]) {
                                        case 0: {
                                            for (n9 = n3; n9 < n13; ++n9) {
                                                for (n = 0; n < soundChunk.stream.channels; ++n) {
                                                    float[] fArray4 = fArray3[n];
                                                    int n14 = n9;
                                                    fArray4[n14] = fArray4[n14] * f4;
                                                }
                                                f4 += f3;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            f4 = 1.0f - f4;
                                            for (n9 = n3; n9 < n13; ++n9) {
                                                for (n = 0; n < soundChunk.stream.channels; ++n) {
                                                    float[] fArray5 = fArray3[n];
                                                    int n15 = n9;
                                                    fArray5[n15] = fArray5[n15] * (1.0f - f4 * f4);
                                                }
                                                f4 -= f3;
                                            }
                                            break;
                                        }
                                    }
                                }
                                if ((n13 = n11 + soundChunk.len - soundChunk.fadeOut) < n12) {
                                    n10 = n13;
                                    n13 = Math.max(n13, 0);
                                    f4 = 1.0f - (float)(n13 - n10) / (float)soundChunk.fadeOut;
                                    f5 = 1.0f + (float)(n10 - n12) / (float)soundChunk.fadeOut;
                                    f3 = (f5 - f4) / (float)(n12 - n13 - 1);
                                    switch (this.pr.intg[4]) {
                                        case 0: {
                                            for (n9 = n13; n9 < n12; ++n9) {
                                                for (n = 0; n < soundChunk.stream.channels; ++n) {
                                                    float[] fArray6 = fArray3[n];
                                                    int n16 = n9;
                                                    fArray6[n16] = fArray6[n16] * f4;
                                                }
                                                f4 += f3;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            f4 = 1.0f - f4;
                                            for (n9 = n13; n9 < n12; ++n9) {
                                                for (n = 0; n < soundChunk.stream.channels; ++n) {
                                                    float[] fArray7 = fArray3[n];
                                                    int n17 = n9;
                                                    fArray7[n17] = fArray7[n17] * (1.0f - f4 * f4);
                                                }
                                                f4 -= f3;
                                            }
                                            break;
                                        }
                                    }
                                }
                                if (n12 < n7) {
                                    vector.removeElement(soundChunk);
                                    soundChunk.f.close();
                                    soundChunk.f = null;
                                    --n2;
                                }
                                for (n = 0; n < n5; ++n) {
                                    Util.add(fArray3[n % soundChunk.stream.channels], n3, fArray2[n], n3, n12 - n3);
                                }
                            }
                            this.setProgression((float)(l += (long)n7) / (float)l2);
                            if (floatFileArray != null) {
                                for (n = 0; n < n5; ++n) {
                                    fArray = fArray2[n];
                                    for (n2 = 0; n2 < n7; ++n2) {
                                        f3 = Math.abs(fArray[n2]);
                                        if (!(f3 > f2)) continue;
                                        f2 = f3;
                                    }
                                    floatFileArray[n].writeFloats(fArray, 0, n7);
                                }
                            } else {
                                for (n = 0; n < n5; ++n) {
                                    fArray = fArray2[n];
                                    for (n2 = 0; n2 < n7; ++n2) {
                                        f3 = Math.abs(fArray[n2]);
                                        int n18 = n2;
                                        fArray[n18] = fArray[n18] * f;
                                        if (!(f3 > f2)) continue;
                                        f2 = f3;
                                    }
                                }
                                audioFile.writeFrames(fArray2, 0, n7);
                            }
                            this.setProgression((float)(l += (long)n7) / (float)l2);
                        }
                        if (this.threadRunning) {
                            if (this.pr.intg[2] == 0) {
                                f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                                this.normalizeAudioFile(floatFileArray, audioFile, fArray2, f, 1.0f);
                                for (n = 0; n < n5; ++n) {
                                    floatFileArray[n].cleanUp();
                                    floatFileArray[n] = null;
                                    fileArray[n].delete();
                                    fileArray[n] = null;
                                }
                            }
                            if (this.threadRunning) {
                                audioFile.close();
                                audioFile = null;
                                this.handleClipping(f2 *= f);
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (soundChunkArray != null) {
            for (n2 = 0; n2 < soundChunkArray.length; ++n2) {
                if (soundChunkArray[n2] == null || soundChunkArray[n2].f == null) continue;
                soundChunkArray[n2].f.cleanUp();
            }
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }

    protected void setInput(String string) {
        AudioFile audioFile = null;
        AudioFileDescr audioFileDescr = null;
        try {
            audioFile = AudioFile.openAsRead((File)new File(string));
            audioFileDescr = audioFile.getDescr();
            audioFile.close();
            Param param = new Param(AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)audioFileDescr.length), 2);
            ParamField paramField = (ParamField)this.gui.getItemObj(513);
            if (paramField != null) {
                paramField.setReference(param);
            }
            if ((paramField = (ParamField)this.gui.getItemObj(514)) != null) {
                paramField.setReference(param);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int analyseFileNames() {
        int n;
        int n2;
        String string = this.pr.text[0];
        String string2 = this.pr.text[1];
        int n3 = string.length();
        int n4 = string2.length();
        for (n2 = 0; n2 < Math.min(n3, n4) && string.charAt(n2) == string2.charAt(n2); ++n2) {
        }
        while (n2 > 0 && Character.isDigit(string.charAt(n2 - 1)) && Character.isDigit(string2.charAt(n2 - 1))) {
            --n2;
        }
        for (n = 0; n < Math.min(n3, n4) && string.charAt(n3 - n - 1) == string2.charAt(n4 - n - 1); ++n) {
        }
        while (n > 0 && Character.isDigit(string.charAt(n3 - n)) && Character.isDigit(string2.charAt(n4 - n))) {
            --n;
        }
        try {
            int n5 = Integer.parseInt(string.substring(n2, n3 - n));
            int n6 = Integer.parseInt(string2.substring(n2, n4 - n));
            int n7 = Math.min(n5, n6);
            int n8 = Math.max(n5, n6);
            this.reverse = n5 > n6;
            int n9 = n8 - n7 + 1;
            this.gui.stringToJTextField(n9 + " files detected.", 2048);
            this.fileNameArgs[1] = string.substring(0, n2);
            this.fileNameArgs[2] = string.substring(n3 - n);
            this.fileNameArgs[3] = new Integer(n7);
            n5 = Math.min(n3, n4) - n - n2;
            char[] cArray = new char[n5 + Math.max(n3, n4) - Math.min(n3, n4)];
            for (n6 = 0; n6 < cArray.length; ++n6) {
                cArray[n6] = 48;
            }
            this.fileNameArgs[4] = new String(cArray);
            this.usePad = n3 == n4;
            return n9;
        }
        catch (Exception exception) {
            int n10 = -1;
            int n11 = -1;
            this.gui.stringToJTextField("Filename analysis failed!", 2048);
            return 0;
        }
    }

    protected String synthesizeFileName(int n) {
        String string = String.valueOf(n + (Integer)this.fileNameArgs[3]);
        this.fileNameArgs[0] = this.usePad ? ((String)this.fileNameArgs[4]).substring(string.length()) + string : string;
        return MessageFormat.format(FILENAMEPTRN, this.fileNameArgs);
    }
}

