/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.EnvIcon;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Modulator;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.Marker;
import de.sciss.io.Region;
import de.sciss.io.Span;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ConvolutionDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_IMPULSEFILE = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_MODE = 3;
    private static final int PR_MORPHPOLICY = 4;
    private static final int PR_LENGTH = 5;
    private static final int PR_GAIN = 0;
    private static final int PR_FADELENGTH = 1;
    private static final int PR_IRNUMBER = 2;
    private static final int PR_WINSTEP = 3;
    private static final int PR_WINOVERLAP = 4;
    private static final int PR_NORMIMPPOWER = 0;
    private static final int PR_TRUNCOVER = 1;
    private static final int PR_MORPH = 2;
    private static final int PR_MINPHASE = 3;
    private static final int PR_IRMODENV = 0;
    private static final int MODE_CONV = 0;
    private static final int MODE_DECONV = 1;
    private static final int MODE_CONVINV = 2;
    private static final int MORPH_RECT = 0;
    private static final int MORPH_POLAR = 1;
    private static final int LENGTH_FULL = 0;
    private static final int LENGTH_INPUT = 1;
    private static final int LENGTH_SKIPSUPPORT = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_IMPULSEFILE = "ImpulseFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputRes";
    private static final String PRN_MODE = "Mode";
    private static final String PRN_MORPHPOLICY = "Policy";
    private static final String PRN_LENGTH = "Length";
    private static final String PRN_FADELENGTH = "FadeLen";
    private static final String PRN_IRNUMBER = "IRNumber";
    private static final String PRN_WINSTEP = "WinStep";
    private static final String PRN_WINOVERLAP = "WinOverlap";
    private static final String PRN_NORMIMPPOWER = "NormImp";
    private static final String PRN_TRUNCOVER = "TruncOver";
    private static final String PRN_MORPH = "Morph";
    private static final String PRN_IRMODENV = "IRModEnv";
    private static final String PRN_MINPHASE = "MinPhase";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "ImpulseFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputRes", "GainType", "Mode", "Policy", "Length"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "FadeLen", "IRNumber", "WinStep", "WinOverlap"};
    private static final boolean[] prBool = new boolean[]{false, false, false, false};
    private static final String[] prBoolName = new String[]{"NormImp", "TruncOver", "Morph", "MinPhase"};
    private static final Envelope[] prEnvl = new Envelope[]{null};
    private static final String[] prEnvlName = new String[]{"IRModEnv"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_IMPULSEFILE = 1025;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_MODE = 259;
    private static final int GG_MORPHPOLICY = 260;
    private static final int GG_LENGTH = 261;
    private static final int GG_GAIN = 512;
    private static final int GG_FADELENGTH = 513;
    private static final int GG_IRNUMBER = 514;
    private static final int GG_WINSTEP = 515;
    private static final int GG_WINOVERLAP = 516;
    private static final int GG_NORMIMPPOWER = 0;
    private static final int GG_TRUNCOVER = 1;
    private static final int GG_MORPH = 2;
    private static final int GG_MINPHASE = 3;
    private static final int GG_IRMODENV = 1792;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String MARK_SUPPORT = "Support";

    public ConvolutionDlg() {
        super("Convolution");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ConvolutionDlg.static_pr.text = prText;
            ConvolutionDlg.static_pr.textName = prTextName;
            ConvolutionDlg.static_pr.intg = prIntg;
            ConvolutionDlg.static_pr.intgName = prIntgName;
            ConvolutionDlg.static_pr.para = prPara;
            ConvolutionDlg.static_pr.para[1] = new Param(10.0, 2);
            ConvolutionDlg.static_pr.para[2] = new Param(1.0, 0);
            ConvolutionDlg.static_pr.para[3] = new Param(20.0, 2);
            ConvolutionDlg.static_pr.para[4] = new Param(0.0, 2);
            ConvolutionDlg.static_pr.paraName = prParaName;
            ConvolutionDlg.static_pr.bool = prBool;
            ConvolutionDlg.static_pr.boolName = prBoolName;
            ConvolutionDlg.static_pr.envl = prEnvl;
            ConvolutionDlg.static_pr.envl[0] = Envelope.createBasicEnvelope(1);
            ConvolutionDlg.static_pr.envlName = prEnvlName;
            this.fillDefaultAudioDescr(ConvolutionDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(ConvolutionDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = ConvolutionDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 1: 
                    case 2: {
                        ((ConvolutionDlg)ConvolutionDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        ConvolutionDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input sound");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select impulse response");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Impulse response", 4));
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField, pathField2};
        pathField3.deriveFrom(pathFieldArray, "$D0$B0Con$B1$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Convolution Settings", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Convolution");
        jComboBox.addItem("Deconvolution");
        jComboBox.addItem("Conv w/ inversion");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_MODE, 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 259, itemListener);
        JCheckBox jCheckBox = new JCheckBox("Truncate overlaps");
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 1, itemListener);
        JCheckBox jCheckBox2 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Norm. IR energy", 4));
        this.gui.addCheckbox(jCheckBox2, 0, itemListener);
        ParamField paramField = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Trunc fadeout", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 513, null);
        JCheckBox jCheckBox3 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Make minimum phase", 4));
        this.gui.addCheckbox(jCheckBox3, 3, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        jComboBox2.addItem("Input + IR");
        jComboBox2.addItem("Input (no change)");
        jComboBox2.addItem("Inp + IR\\{support}");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("File length", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 261, itemListener);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Morphing", 1, 0));
        JCheckBox jCheckBox4 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Morph IRs", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox4, 2, itemListener);
        JComboBox<String> jComboBox3 = new JComboBox<String>();
        jComboBox3.addItem("Rect X-Fade");
        jComboBox3.addItem("Polar X-Fade");
        jComboBox3.addItem("Correlate + shift");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_MORPHPOLICY, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox3, 260, itemListener);
        ParamField paramField2 = new ParamField(new ParamSpace(1.0, 100000.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("# of IRs in file", 4));
        gridBagConstraints.weightx = 0.8;
        this.gui.addParamField(paramField2, 514, null);
        EnvIcon envIcon = new EnvIcon(this.getComponent());
        gridBagConstraints.weightx = 0.0;
        this.gui.addGadget(envIcon, 1792);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new JLabel());
        ParamField paramField3 = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Window size", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 515, null);
        ParamField paramField4 = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Overlap", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 516, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block145: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            float[][] fArray4;
            float[][] fArray5;
            float[] fArray6;
            AudioFileDescr audioFileDescr;
            AudioFileDescr audioFileDescr2;
            AudioFileDescr audioFileDescr3;
            float f = 0.0f;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            floatFileArray = null;
            fileArray = null;
            float[][] fArray7 = null;
            float[][] fArray8 = null;
            float[] fArray9 = null;
            boolean bl = false;
            Param param = new Param(1.0, 1);
            float f2 = 1.0f;
            int n = 1;
            Modulator modulator = null;
            Param param2 = null;
            SpectStream spectStream = null;
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = false;
            Object object = new float[2][][];
            float[][] fArray10 = null;
            float[][] fArray11 = null;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            float[] fArray12 = new float[4];
            float[] fArray13 = new float[4];
            int n7 = 0;
            boolean bl3 = this.pr.bool[3];
            try {
                int n8;
                int n9;
                int n10;
                double d;
                Param param3;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                Param param4;
                int n17;
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr3 = audioFile3.getDescr();
                int n18 = audioFileDescr3.channels;
                int n19 = (int)audioFileDescr3.length;
                int n20 = n19 * n18;
                if (n20 <= 0) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block145;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                audioFileDescr2 = audioFile2.getDescr();
                int n21 = audioFileDescr2.channels;
                int n22 = (int)audioFileDescr2.length;
                int n23 = n22 * (bl3 ? 2 : 1);
                int n24 = n22 * n21;
                if (n24 <= 0) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block145;
                PathField pathField = (PathField)this.gui.getItemObj(1026);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                IOUtil.createEmptyFile((File)new File(this.pr.text[2]));
                audioFileDescr = new AudioFileDescr(audioFileDescr3);
                pathField.fillStream(audioFileDescr);
                audioFileDescr.channels = n17 = Math.max(n18, n21);
                Param param5 = param4 = new Param(0.0, 0);
                nArray[0] = -1;
                nArray[1] = -1;
                nArray2[0] = 0;
                nArray2[1] = 0;
                if (this.pr.bool[2]) {
                    n = Math.max(1, Math.min(n22, (int)this.pr.para[2].value));
                    n23 = (n22 /= n) * (bl3 ? 2 : 1);
                    n24 = n22 * n21;
                    n16 = Math.max(1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[3].value) + 0.5));
                    n15 = n16 + n23 - 1;
                    for (n14 = 2; n14 < n15; n14 <<= 1) {
                    }
                    n13 = n14 << 1;
                    bl = this.pr.intg[4] == 1;
                    n4 = Math.min(n16 >> 1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[4].value) + 0.5));
                    if (n4 > 0) {
                        fArray10 = new float[n18][n4];
                        fArray11 = new float[n18][n4];
                        for (n12 = 0; n12 < n18; ++n12) {
                            fArray6 = fArray10[n12];
                            for (n11 = 0; n11 < n4; ++n11) {
                                fArray6[n11] = 0.0f;
                            }
                        }
                        for (n12 = 0; n12 < n17; ++n12) {
                            fArray6 = fArray11[n12];
                            for (n11 = 0; n11 < n4; ++n11) {
                                fArray6[n11] = 0.0f;
                            }
                        }
                    }
                    param2 = new Param(this.pr.para[2].value - 1.0, this.pr.para[2].unit);
                    spectStream = new SpectStream();
                    spectStream.setChannels(n18);
                    spectStream.setBands(0.0f, (float)audioFileDescr3.rate / 2.0f, 1, 1);
                    spectStream.setRate((float)audioFileDescr3.rate, n16 - n4);
                    spectStream.setEstimatedLength((n19 + n16 - n4 - 1) / (n16 - n4));
                    spectStream.getDescr();
                    fArray8 = new float[n21][n14 + 2];
                    for (n12 = 0; n12 < 2; ++n12) {
                        object[n12] = new float[n21][bl3 ? n13 : n14 + 2];
                    }
                    modulator = new Modulator(param4, param2, this.pr.envl[0], spectStream);
                    param5.value = -1.0;
                    for (n12 = 0; n12 < n19; n12 += n16) {
                        param3 = modulator.calc();
                        d = param3.value;
                        if (d % 1.0 < 0.0012) {
                            d = Math.floor(d);
                        }
                        if (d % 1.0 > 0.9988) {
                            d = Math.ceil(d);
                        }
                        param3.value = d;
                        if (Math.abs(d - param5.value) >= 0.0012) {
                            nArray2[0] = (int)Math.floor(d);
                            nArray2[1] = (int)Math.ceil(d);
                            ++n3;
                            param5 = param3;
                        }
                        for (n11 = 0; n11 < 2; ++n11) {
                            if (nArray2[n11] == nArray[0] || nArray2[n11] == nArray[1]) continue;
                            ++n2;
                            if (nArray2[1 - n11] == nArray[n11]) {
                                n10 = nArray[n11];
                                nArray[n11] = nArray[1 - n11];
                                nArray[1 - n11] = n10;
                            }
                            nArray[n11] = nArray2[n11];
                        }
                        ++spectStream.framesRead;
                    }
                    param5.value = -1.0;
                    nArray[0] = -1;
                    nArray[1] = -1;
                    nArray2[0] = 0;
                    nArray2[1] = 0;
                    spectStream.framesRead = 0L;
                    modulator = new Modulator(param4, param2, this.pr.envl[0], spectStream);
                } else {
                    n15 = 2 * (n23 - 1);
                    for (n14 = 2; n14 < n15; n14 <<= 1) {
                    }
                    n13 = n14 << 1;
                    n16 = n14 - n23 + 1;
                    n2 = 1;
                    fArray8 = new float[n21][bl3 ? n13 : n14 + 2];
                    for (n12 = 0; n12 < 2; ++n12) {
                        object[n12] = fArray8;
                    }
                }
                int n25 = n23 - 1;
                if (this.pr.bool[1] && (n25 = Math.min(n25, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[1].value) + 0.5))) > 0) {
                    fArray9 = Filter.createKaiserWindow(n25, 6.0f);
                }
                audioFile2.readMarkers();
                Vector<Marker> vector = (Vector<Marker>)audioFileDescr2.getProperty((Object)"markers");
                List list = (List)audioFileDescr2.getProperty((Object)"regions");
                if (vector != null && (n9 = Marker.find((List)vector, (String)MARK_SUPPORT, (int)0)) >= 0) {
                    n7 = (int)((Marker)vector.get((int)n9)).pos;
                    if (n7 > n22) {
                        n7 = 0;
                    }
                    if (bl3) {
                        n7 = 0;
                    }
                }
                if (this.pr.intg[5] == 0 && n7 > 0) {
                    Region region;
                    if (vector != null) {
                        for (n12 = 0; n12 < vector.size(); ++n12) {
                            Marker marker = (Marker)vector.get(n12);
                            vector.set(n12, new Marker(marker.pos + (long)n7, marker.name));
                        }
                        if (Marker.find(vector, (String)MARK_SUPPORT, (int)0) < 0) {
                            Marker.add(vector, (Marker)new Marker((long)n7, MARK_SUPPORT));
                        }
                    } else {
                        vector = new Vector<Marker>();
                        Marker.add(vector, (Marker)new Marker((long)n7, MARK_SUPPORT));
                        audioFileDescr.setProperty("markers", vector);
                    }
                    if (list != null) {
                        for (n12 = 0; n12 < list.size(); ++n12) {
                            region = (Region)list.get(n12);
                            list.set(n12, new Region(new Span(region.span.getStart() + (long)n7, region.span.getStop() + (long)n7), region.name));
                        }
                    }
                    if ((region = (Region)audioFileDescr.getProperty((Object)"loop")) != null) {
                        audioFileDescr.setProperty("loop", (Object)new Region(new Span(region.span.getStart() + (long)n7, region.span.getStop() + (long)n7), region.name));
                    }
                }
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block145;
                switch (this.pr.intg[5]) {
                    case 0: {
                        n8 = n19 + n25;
                        break;
                    }
                    case 1: {
                        n8 = n19;
                        break;
                    }
                    case 2: {
                        n8 = n19 + Math.max(0, n25 - n7);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(this.pr.intg[5]));
                    }
                }
                int n26 = n8 * n17;
                fArray7 = new float[n17][n14 + 2];
                fArray5 = new float[n17][n25];
                long l = 0L;
                long l2 = (long)(n2 * (n22 + n24)) + (long)(n19 + n20) + (long)(n8 + n26);
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n17];
                    floatFileArray = new FloatFile[n17];
                    for (n12 = 0; n12 < n17; ++n12) {
                        fileArray[n12] = IOUtil.createTempFile();
                        floatFileArray[n12] = new FloatFile(fileArray[n12], 1);
                    }
                    l2 += (long)n8;
                } else {
                    f2 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block145;
                int n27 = 0;
                int n28 = 0;
                if (this.pr.intg[5] != 0) {
                    n28 = -n7;
                }
                n12 = 1;
                while (this.threadRunning && n12 != 0) {
                    float f3;
                    int n29;
                    int n30;
                    int n31;
                    if (n5 > 0) {
                        for (n11 = 0; n11 < n18; ++n11) {
                            System.arraycopy(fArray10[n11], 0, fArray7[n11], 0, n5);
                        }
                    }
                    int n32 = Math.min(n19 - n27 + n31, n16);
                    for (n31 = n5; this.threadRunning && n31 < n32; n31 += n15) {
                        n15 = Math.min(8192, n32 - n31);
                        audioFile3.readFrames(fArray7, n31, n15);
                        n27 += n15;
                        this.setProgression((float)(l += (long)n15) / (float)l2);
                    }
                    if (!this.threadRunning) break block145;
                    for (n11 = 0; n11 < n18; ++n11) {
                        fArray6 = fArray7[n11];
                        for (n30 = n32; n30 < n14 + 2; ++n30) {
                            fArray6[n30] = 0.0f;
                        }
                    }
                    if (n4 > 0) {
                        n5 = n4;
                        for (n11 = 0; n11 < n18; ++n11) {
                            System.arraycopy(fArray7[n11], n16 - n4, fArray10[n11], 0, n5);
                        }
                    }
                    for (n11 = 0; this.threadRunning && n11 < n18; ++n11) {
                        Fourier.realTransform(fArray7[n11], n14, 1);
                        this.setProgression((float)(l += (long)(n32 - n5)) / (float)l2);
                    }
                    if (!this.threadRunning) break block145;
                    for (n11 = n18; n11 < n17; ++n11) {
                        System.arraycopy(fArray7[n11 % n18], 0, fArray7[n11], 0, n14 + 2);
                    }
                    if (n32 > n5) {
                        double d2;
                        if (modulator != null) {
                            param3 = modulator.calc();
                            ++spectStream.framesRead;
                            d = Math.max(0.0, Math.min(param2.value, param3.value));
                            if (d % 1.0 < 0.0012) {
                                d = Math.floor(d);
                            }
                            if (d % 1.0 > 0.9988) {
                                d = Math.ceil(d);
                            }
                            param3.value = d;
                            if (Math.abs(d - param5.value) >= 0.0012) {
                                param5 = param3;
                                bl2 = true;
                                nArray2[0] = (int)Math.floor(d);
                                nArray2[1] = (int)Math.ceil(d);
                            }
                        }
                        for (n11 = 0; this.threadRunning && n11 < 2; ++n11) {
                            if (nArray2[n11] == nArray[0] || nArray2[n11] == nArray[1]) continue;
                            if (nArray2[1 - n11] == nArray[n11]) {
                                fArray4 = object[n11];
                                object[n11] = object[1 - n11];
                                object[1 - n11] = fArray4;
                                n10 = nArray[n11];
                                nArray[n11] = nArray[1 - n11];
                                nArray[1 - n11] = n10;
                            }
                            fArray4 = object[n11];
                            audioFile2.seekFrame((long)(nArray2[n11] * n22));
                            for (int i = 0; this.threadRunning && i < n22; i += n15) {
                                n15 = Math.min(8192, n22 - i);
                                audioFile2.readFrames(fArray4, i, n15);
                                this.setProgression((float)(l += (long)n15) / (float)l2);
                            }
                            if (!this.threadRunning) break block145;
                            for (n30 = 0; n30 < n21; ++n30) {
                                fArray6 = fArray4[n30];
                                for (n29 = n22; n29 < n14 + 2; ++n29) {
                                    fArray6[n29] = 0.0f;
                                }
                            }
                            if (this.pr.bool[0]) {
                                double d3 = 0.0;
                                for (n30 = 0; n30 < n21; ++n30) {
                                    fArray6 = fArray4[n30];
                                    for (n29 = 0; n29 < n22; ++n29) {
                                        f3 = fArray6[n29];
                                        d3 += (double)(f3 * f3);
                                    }
                                }
                                d3 = Math.sqrt(d3) / (double)n21;
                                d = Math.min(1000.0, 1.0 / Math.abs(d3));
                                for (n30 = 0; n30 < n21; ++n30) {
                                    fArray6 = fArray4[n30];
                                    for (n29 = 0; n29 < n22; ++n29) {
                                        fArray6[n29] = (float)((double)fArray6[n29] * d);
                                    }
                                }
                            }
                            for (n30 = 0; this.threadRunning && n30 < n21; ++n30) {
                                int n33;
                                fArray6 = fArray4[n30];
                                Fourier.realTransform(fArray6, n14, 1);
                                if (this.pr.intg[3] == 1) {
                                    int n34 = n14 + 4;
                                    int n35 = -1;
                                    n29 = 0;
                                    n33 = 1;
                                    while (n29 <= n14) {
                                        f3 = fArray6[n29] * fArray6[n29] + fArray6[n33] * fArray6[n33];
                                        if (f3 != 0.0f) {
                                            int n36 = n29;
                                            fArray6[n36] = fArray6[n36] / f3;
                                            int n37 = n33;
                                            fArray6[n37] = fArray6[n37] / -f3;
                                        } else {
                                            fArray6[n29] = Float.POSITIVE_INFINITY;
                                            fArray6[n33] = Float.POSITIVE_INFINITY;
                                            n34 = Math.min(n34, n29);
                                            n35 = Math.max(n35, n33);
                                        }
                                        n29 += 2;
                                        n33 += 2;
                                    }
                                    for (n29 = n34; n29 <= n35; ++n29) {
                                        f3 = fArray6[n29];
                                        if (f3 != Float.POSITIVE_INFINITY) continue;
                                        n33 = n29 - 2;
                                        int n38 = 1;
                                        int n39 = 0;
                                        while (n38 >= 0) {
                                            n39 = Math.abs(n33);
                                            if (n39 <= n14 + 1) {
                                                f3 = fArray6[n39];
                                                if (f3 != Float.POSITIVE_INFINITY) {
                                                    fArray13[n38] = f3;
                                                    fArray12[n38--] = n33;
                                                }
                                            } else {
                                                fArray13[n38] = 0.0f;
                                                fArray12[n38--] = n33;
                                            }
                                            n33 -= 2;
                                        }
                                        n33 = n29 + 2;
                                        n38 = 2;
                                        n39 = 0;
                                        while (n38 <= 3) {
                                            int n40 = n39 = n33 <= n14 + 1 ? n33 : (n14 << 1) - n33;
                                            if (n39 >= 0) {
                                                f3 = fArray6[n39];
                                                if (f3 != Float.POSITIVE_INFINITY) {
                                                    fArray13[n38] = f3;
                                                    fArray12[n38++] = n33;
                                                }
                                            } else {
                                                fArray13[n38] = 0.0f;
                                                fArray12[n38++] = n33;
                                            }
                                            n33 += 2;
                                        }
                                        fArray6[n29] = Util.polyInterpolate(fArray12, fArray13, 4, n29);
                                    }
                                } else if (this.pr.intg[3] == 2) {
                                    d = Double.POSITIVE_INFINITY;
                                    d2 = 0.0;
                                    n29 = 0;
                                    n33 = 1;
                                    while (n29 <= n14) {
                                        double d4 = fArray6[n29] * fArray6[n29] + fArray6[n33] * fArray6[n33];
                                        if (d4 > d2) {
                                            d2 = d4;
                                        } else if (d4 < d) {
                                            d = d4;
                                        }
                                        n29 += 2;
                                        n33 += 2;
                                    }
                                    d = Math.sqrt(d) + Math.sqrt(d2);
                                    n29 = 0;
                                    n33 = 1;
                                    while (n29 <= n14) {
                                        f3 = (float)(d / Math.sqrt(fArray6[n29] * fArray6[n29] + fArray6[n33] * fArray6[n33]) - 1.0);
                                        int n41 = n29;
                                        fArray6[n41] = fArray6[n41] * f3;
                                        int n42 = n33;
                                        fArray6[n42] = fArray6[n42] * f3;
                                        n29 += 2;
                                        n33 += 2;
                                    }
                                }
                                if (bl || bl3) {
                                    Fourier.rect2Polar(fArray6, 0, fArray6, 0, n14 + 2);
                                    Fourier.unwrapPhases(fArray6, 0, fArray6, 0, n14 + 2);
                                }
                                this.setProgression((float)(l += (long)n22) / (float)l2);
                                if (!bl3) continue;
                                for (n29 = 0; n29 <= n14; n29 += 2) {
                                    fArray6[n29] = (float)Math.log(Math.max(1.0E-48, (double)fArray6[n29]));
                                }
                                n33 = n14 - 2;
                                for (n29 = n14 + 2; n29 < n13; n29 += 2) {
                                    fArray6[n29] = fArray6[n33];
                                    fArray6[n29 + 1] = -fArray6[n33 + 1];
                                    n33 -= 2;
                                }
                                Fourier.complexTransform(fArray6, n14, -1);
                                n29 = 2;
                                n33 = n13 - 2;
                                while (n29 < n14) {
                                    int n43 = n29;
                                    fArray6[n43] = fArray6[n43] + fArray6[n33];
                                    int n44 = n29 + 1;
                                    fArray6[n44] = fArray6[n44] - fArray6[n33 + 1];
                                    n29 += 2;
                                    n33 -= 2;
                                }
                                fArray6[n14 + 1] = -fArray6[n14 + 1];
                                for (n29 = n14 + 2; n29 < n13; ++n29) {
                                    fArray6[n29] = 0.0f;
                                }
                                Fourier.complexTransform(fArray6, n14, 1);
                                for (n29 = 0; n29 <= n14; n29 += 2) {
                                    fArray6[n29] = (float)Math.exp(fArray6[n29]);
                                }
                                Fourier.polar2Rect(fArray6, 0, fArray6, 0, n14 + 2);
                                Fourier.realTransform(fArray6, n14, -1);
                                float f4 = 0.0f;
                                n7 = n23 >> 1;
                                for (n29 = 0; n29 < n22; ++n29) {
                                    f3 = Math.abs(fArray6[n29]);
                                    if (!(f3 > f4)) continue;
                                    f4 = f3;
                                    n7 = n29;
                                }
                                n15 = n7 >> 1;
                                if (n15 > 0) {
                                    float[] fArray14 = Filter.createWindow(n15, 4);
                                    n29 = n15 - 1;
                                    for (n33 = 0; n33 < fArray14.length; ++n33) {
                                        int n45 = n29--;
                                        fArray6[n45] = fArray6[n45] * fArray14[n33];
                                    }
                                    n29 = n22 - n15;
                                    n33 = 0;
                                    while (n29 < n22) {
                                        int n46 = n29++;
                                        fArray6[n46] = fArray6[n46] * fArray14[n33];
                                        ++n33;
                                    }
                                }
                                for (n29 = n22; n29 < n14; ++n29) {
                                    fArray6[n29] = 0.0f;
                                }
                                Fourier.realTransform(fArray6, n14, 1);
                                if (!bl) continue;
                                Fourier.rect2Polar(fArray6, 0, fArray6, 0, n14 + 2);
                            }
                            nArray[n11] = nArray2[n11];
                        }
                        if (!this.threadRunning) break block145;
                        if (bl2) {
                            fArray4 = nArray2[0] == nArray[0] ? object[0] : object[1];
                            float[][] fArray15 = fArray3 = nArray2[1] == nArray[1] ? object[1] : object[0];
                            if (fArray4 != fArray3) {
                                d2 = param5.value % 1.0;
                                d = 1.0 - d2;
                                for (n11 = 0; n11 < n21; ++n11) {
                                    fArray6 = fArray4[n11];
                                    fArray2 = fArray3[n11];
                                    fArray = fArray8[n11];
                                    for (n30 = 0; n30 <= n14; ++n30) {
                                        fArray[n30] = (float)(d * (double)fArray6[n30] + d2 * (double)fArray2[n30]);
                                        fArray[++n30] = (float)(d * (double)fArray6[n30] + d2 * (double)fArray2[n30]);
                                    }
                                }
                            } else {
                                for (n11 = 0; n11 < n21; ++n11) {
                                    System.arraycopy(fArray4[n11], 0, fArray8[n11], 0, n14 + 2);
                                }
                            }
                            if (bl) {
                                for (n11 = 0; n11 < n21; ++n11) {
                                    Fourier.polar2Rect(fArray8[n11], 0, fArray8[n11], 0, n14 + 2);
                                }
                            }
                            bl2 = false;
                        }
                        for (n11 = 0; this.threadRunning && n11 < n17; ++n11) {
                            fArray6 = fArray7[n11];
                            fArray2 = fArray8[n11 % n21];
                            n30 = 0;
                            n29 = 1;
                            while (n30 <= n14) {
                                f3 = fArray6[n30];
                                fArray6[n30] = f3 * fArray2[n30] - fArray6[n29] * fArray2[n29];
                                fArray6[n29] = f3 * fArray2[n29] + fArray6[n29] * fArray2[n30];
                                n30 += 2;
                                n29 += 2;
                            }
                            Fourier.realTransform(fArray6, n14, -1);
                            fArray2 = fArray5[n11];
                            n15 = Math.min(n25, n32);
                            for (n30 = n15 - 1; n30 >= 0; --n30) {
                                int n47 = n30;
                                fArray6[n47] = fArray6[n47] + fArray2[n30];
                            }
                            System.arraycopy(fArray2, n15, fArray2, 0, n25 - n15);
                            if (fArray9 == null) {
                                n30 = 0;
                                n29 = n32;
                                while (n30 < n25 - n15) {
                                    int n48 = n30++;
                                    fArray2[n48] = fArray2[n48] + fArray6[n29];
                                    ++n29;
                                }
                                n30 = n25 - n15;
                                n29 = n32 + n30;
                                while (n30 < n25) {
                                    fArray2[n30] = fArray6[n29];
                                    ++n30;
                                    ++n29;
                                }
                            } else {
                                n30 = 0;
                                n29 = n32;
                                while (n30 < n25 - n15) {
                                    int n49 = n30;
                                    fArray2[n49] = fArray2[n49] + fArray9[n30] * fArray6[n29];
                                    ++n30;
                                    ++n29;
                                }
                                n30 = n25 - n15;
                                n29 = n32 + n30;
                                while (n30 < n25) {
                                    fArray2[n30] = fArray9[n30] * fArray6[n29];
                                    ++n30;
                                    ++n29;
                                }
                            }
                            this.setProgression((float)(l += (long)(n32 - n5)) / (float)l2);
                        }
                        if (!this.threadRunning) {
                            break block145;
                        }
                    } else {
                        n32 = Math.min(n8 - n28, Math.max(n6, n25));
                        n5 = 0;
                        n12 = 0;
                        for (n11 = 0; n11 < n17; ++n11) {
                            fArray6 = fArray7[n11];
                            fArray2 = fArray5[n11];
                            for (n30 = 0; n30 < n25; ++n30) {
                                int n50 = n30;
                                fArray6[n50] = fArray6[n50] + fArray2[n30];
                            }
                            l += (long)n32;
                        }
                    }
                    if (n4 > 0) {
                        for (n11 = 0; n11 < n17; ++n11) {
                            fArray6 = fArray7[n11];
                            fArray2 = fArray11[n11];
                            n30 = 0;
                            n29 = n16 - n4;
                            while (n30 < n6) {
                                f3 = n30 / (n6 - 1);
                                float f5 = fArray6[n29++];
                                fArray6[n30] = fArray6[n30] * f3 + fArray2[n30] * (1.0f - f3);
                                fArray2[n30++] = f5;
                            }
                            System.arraycopy(fArray6, n16 - n4 + n6, fArray2, n6, n4 - n6);
                        }
                        n6 = n5;
                    }
                    n32 -= n6;
                    n31 = 0;
                    if (n28 < 0) {
                        n31 = Math.min(-n28, n32);
                        n28 += n31;
                    }
                    if (n28 >= 0) {
                        while (this.threadRunning && n31 < n32) {
                            n15 = Math.min(8192, n32 - n31);
                            if (floatFileArray != null) {
                                for (n11 = 0; n11 < n17; ++n11) {
                                    fArray6 = fArray7[n11];
                                    n30 = n31;
                                    for (n29 = 0; n29 < n15; ++n29) {
                                        f3 = Math.abs(fArray6[n30]);
                                        if (f3 > f) {
                                            f = f3;
                                        }
                                        ++n30;
                                    }
                                    floatFileArray[n11].writeFloats(fArray6, n31, n15);
                                }
                            } else {
                                for (n11 = 0; n11 < n17; ++n11) {
                                    fArray6 = fArray7[n11];
                                    n30 = n31;
                                    for (n29 = 0; n29 < n15; ++n29) {
                                        f3 = Math.abs(fArray6[n30]);
                                        int n51 = n30;
                                        fArray6[n51] = fArray6[n51] * f2;
                                        if (f3 > f) {
                                            f = f3;
                                        }
                                        ++n30;
                                    }
                                }
                                audioFile.writeFrames(fArray7, n31, n15);
                            }
                            n28 += n15;
                            n31 += n15;
                            this.setProgression((float)(l += (long)n15) / (float)l2);
                        }
                    }
                    if (this.threadRunning) continue;
                    break block145;
                }
                if (this.pr.intg[2] == 0) {
                    Param param6 = new Param(f, 1);
                    f2 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / param6.value), (int)param6.unit), null).value;
                    this.normalizeAudioFile(floatFileArray, audioFile, fArray7, f2, 1.0f);
                    for (n12 = 0; n12 < n17; ++n12) {
                        floatFileArray[n12].cleanUp();
                        floatFileArray[n12] = null;
                        fileArray[n12].delete();
                        fileArray[n12] = null;
                    }
                }
                this.setProgression(1.0f);
                audioFile2.close();
                audioFile2 = null;
                audioFileDescr2 = null;
                fArray6 = null;
                fArray2 = null;
                fArray4 = null;
                fArray3 = null;
                fArray = null;
                fArray8 = null;
                object = null;
                fArray5 = null;
                fArray10 = null;
                fArray11 = null;
                fArray9 = null;
                audioFile3.close();
                audioFile3 = null;
                audioFileDescr3 = null;
                fArray7 = null;
                audioFile.close();
                audioFile = null;
                audioFileDescr = null;
                if (this.threadRunning) {
                    this.handleClipping(f *= f2);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                fArray6 = null;
                fArray2 = null;
                fArray4 = null;
                fArray3 = null;
                fArray = null;
                fArray7 = null;
                fArray8 = null;
                object = null;
                fArray5 = null;
                fArray10 = null;
                fArray11 = null;
                fArray9 = null;
                audioFileDescr3 = null;
                audioFileDescr2 = null;
                audioFileDescr = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (floatFileArray != null) {
            for (int i = 0; i < floatFileArray.length; ++i) {
                if (floatFileArray[i] != null) {
                    floatFileArray[i].cleanUp();
                }
                if (fileArray[i] == null) continue;
                fileArray[i].delete();
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(513);
        if (component != null) {
            component.setEnabled(this.pr.bool[1]);
        }
        if ((component = this.gui.getItemObj(260)) != null) {
            component.setEnabled(this.pr.bool[2]);
        }
        if ((component = this.gui.getItemObj(514)) != null) {
            component.setEnabled(this.pr.bool[2]);
        }
        if ((component = this.gui.getItemObj(1792)) != null) {
            component.setEnabled(this.pr.bool[2]);
        }
        if ((component = this.gui.getItemObj(515)) != null) {
            component.setEnabled(this.pr.bool[2]);
        }
        if ((component = this.gui.getItemObj(516)) != null) {
            component.setEnabled(this.pr.bool[2]);
        }
    }
}

