/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.Application;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.Marker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class DeclickDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_IMPULSEFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_CHECKSIZE = 2;
    private static final int PR_XFADE = 3;
    private static final int PR_PROBBOUND = 4;
    private static final int PR_MINAMP = 0;
    private static final int PR_FSCAPEDETECT = 0;
    private static final int PR_FSCAPEREPAIR = 1;
    private static final int PR_MARKERDETECT = 2;
    private static final int PR_MARKERREPAIR = 3;
    private static final int CHECK_16 = 0;
    private static final int CHECK_32 = 1;
    private static final int CHECK_64 = 2;
    private static final int XFADE_512 = 0;
    private static final int XFADE_1024 = 1;
    private static final int XFADE_2048 = 2;
    private static final int PROB_5PM = 0;
    private static final int PROB_1PM = 1;
    private static final int PROB_05PM = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_IMPULSEFILE = "ImpFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_CHECKSIZE = "CheckSize";
    private static final String PRN_XFADE = "XFade";
    private static final String PRN_PROBBOUND = "ProbBound";
    private static final String PRN_MINAMP = "MinAmp";
    private static final String PRN_FSCAPEDETECT = "FScDetect";
    private static final String PRN_FSCAPEREPAIR = "FScRepair";
    private static final String PRN_MARKERDETECT = "MarkDetect";
    private static final String PRN_MARKERREPAIR = "MarkRepair";
    private static final String[] prText = new String[]{"", "", null};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile", "ImpFile"};
    private static final int[] prIntg = new int[]{0, 0, 1, 1, 1};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "CheckSize", "XFade", "ProbBound"};
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"MinAmp"};
    private static final boolean[] prBool = new boolean[]{true, true, true, true};
    private static final String[] prBoolName = new String[]{"FScDetect", "FScRepair", "MarkDetect", "MarkRepair"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_IMPULSEFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_CHECKSIZE = 258;
    private static final int GG_XFADE = 259;
    private static final int GG_PROBBOUND = 260;
    private static final int GG_MINAMP = 512;
    private static final int GG_FSCAPEDETECT = 0;
    private static final int GG_FSCAPEREPAIR = 1;
    private static final int GG_MARKERDETECT = 2;
    private static final int GG_MARKERREPAIR = 3;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private JLabel lbClicks;
    private static final String MARK_CLICK = "Click";

    public DeclickDlg() {
        super("Declick");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            DeclickDlg.static_pr.text = prText;
            DeclickDlg.prText[2] = new File(new File(Application.installDir, "sounds"), "declickIR.aif").getPath();
            DeclickDlg.static_pr.textName = prTextName;
            DeclickDlg.static_pr.intg = prIntg;
            DeclickDlg.static_pr.intgName = prIntgName;
            DeclickDlg.static_pr.bool = prBool;
            DeclickDlg.static_pr.boolName = prBoolName;
            DeclickDlg.static_pr.para = prPara;
            DeclickDlg.static_pr.para[0] = new Param(-60.0, 785);
            DeclickDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(DeclickDlg.static_pr.intg, 0, 1);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = DeclickDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 0: 
                    case 1: {
                        ((DeclickDlg)DeclickDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        DeclickDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0DClk$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        this.gui.addLabel(new GroupLabel("Detection Settings", 1, 0));
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Let FScape detect", 4));
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("16");
        jComboBox.addItem("32");
        jComboBox.addItem("64");
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Check size [smp]", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 258, itemListener);
        JCheckBox jCheckBox2 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Read markers", 4));
        this.gui.addCheckbox(jCheckBox2, 2, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        jComboBox2.addItem("1 : 200");
        jComboBox2.addItem("1 : 1000");
        jComboBox2.addItem("1 : 2000");
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Probablity bound", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 260, itemListener);
        ParamSpace paramSpace = new ParamSpace(-144.0, 0.0, 0.1, 785);
        ParamField paramField = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 3;
        this.gui.addLabel(new JLabel("Min. amp.", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 512, null);
        this.gui.addLabel(new GroupLabel("Repair Settings", 1, 0));
        JCheckBox jCheckBox3 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Let FScape repair", 4));
        this.gui.addCheckbox(jCheckBox3, 1, itemListener);
        JComboBox<String> jComboBox3 = new JComboBox<String>();
        jComboBox3.addItem("512");
        jComboBox3.addItem("1024");
        jComboBox3.addItem("2048");
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("XFade size [smp]", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox3, 259, itemListener);
        JCheckBox jCheckBox4 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Write markers", 4));
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox4, 3, itemListener);
        PathField pathField3 = new PathField(16, "Select IR file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Impulse response", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.addLabel(new GroupLabel("Click View", 1, 0));
        this.lbClicks = new JLabel(" ");
        this.gui.addLabel(this.lbClicks);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    public void process() {
        int n;
        Graphics graphics;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block81: {
            float[] fArray;
            float[] fArray2;
            float[] fArray3;
            float[][] fArray4;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            floatFileArray = null;
            fileArray = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            AudioFileDescr audioFileDescr3 = null;
            int n2 = 0;
            float[][] fArray5 = null;
            Param param = new Param(1.0, 1);
            int n3 = -1;
            Marker marker = null;
            graphics = null;
            int n4 = 0;
            int n5 = 0;
            try {
                int n6;
                float[] fArray6;
                int n7;
                int n8;
                float f;
                float f2 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                switch (this.pr.intg[4]) {
                    case 0: {
                        f = 2.58f;
                        break;
                    }
                    case 1: {
                        f = 3.1f;
                        break;
                    }
                    default: {
                        f = 3.3f;
                    }
                }
                graphics = this.lbClicks.getGraphics();
                Dimension dimension = this.lbClicks.getSize();
                if (graphics != null) {
                    this.lbClicks.repaint();
                    graphics.setColor(Color.red);
                }
                switch (this.pr.intg[2]) {
                    case 0: {
                        n8 = 16;
                        break;
                    }
                    case 1: {
                        n8 = 32;
                        break;
                    }
                    default: {
                        n8 = 64;
                    }
                }
                switch (this.pr.intg[3]) {
                    case 0: {
                        n7 = 512;
                        break;
                    }
                    case 1: {
                        n7 = 1024;
                        break;
                    }
                    default: {
                        n7 = 2048;
                    }
                }
                int n9 = n7 >> 1;
                int n10 = n9 + n8 / 4 + n8 / 2 + n8 / 4 + n9;
                int n11 = n9 + (n8 >> 2);
                int n12 = n8 >> 1;
                int n13 = n10 - n12;
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile3.getDescr();
                int n14 = audioFileDescr.channels;
                int n15 = (int)audioFileDescr.length;
                if (n15 * n14 < 1) {
                    throw new EOFException("File is empty");
                }
                List list = (List)audioFileDescr.getProperty((Object)"markers");
                Vector<Object> vector = list != null ? new Vector(list) : new Vector<Marker>();
                if (this.pr.bool[1] || this.pr.bool[3]) {
                    audioFile = AudioFile.openAsRead((File)new File(this.pr.text[2]));
                    audioFileDescr3 = audioFile.getDescr();
                    n2 = audioFileDescr3.channels;
                    n5 = (int)Math.min(audioFileDescr3.length, (long)n9);
                    fArray5 = new float[n2][n7 + 2];
                    for (n = 0; n < n2; ++n) {
                        fArray6 = fArray5[n];
                        for (n6 = 0; n6 < fArray6.length; ++n6) {
                            fArray6[n6] = 0.0f;
                        }
                    }
                    PathField pathField = (PathField)this.gui.getItemObj(1025);
                    if (pathField == null) {
                        throw new IOException("Bug! Missing property!");
                    }
                    audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                    pathField.fillStream(audioFileDescr2);
                    IOUtil.createEmptyFile((File)new File(this.pr.text[1]));
                    n4 = n15;
                }
                if (!this.threadRunning) break block81;
                fArray4 = new float[n14][n10];
                fArray3 = new float[n8];
                fArray2 = new float[n7 + 2];
                int n16 = n10 / n12;
                int n17 = (n15 + n12 - 1) / n12 + (n16 - 1);
                int n18 = n17 - n16;
                int n19 = 0;
                fArray = Filter.createWindow(n9, 1);
                for (n = 0; n < n14; ++n) {
                    fArray6 = fArray4[n];
                    for (n6 = 0; n6 < n10; ++n6) {
                        fArray6[n6] = 0.0f;
                    }
                }
                for (n6 = 0; n6 < fArray2.length; ++n6) {
                    fArray2[n6] = 0.0f;
                }
                if (this.pr.bool[2] && list != null) {
                    Collections.sort(list);
                    n3 = Marker.find((List)list, (String)MARK_CLICK, (int)0);
                    if (n3 >= 0) {
                        marker = (Marker)list.get(n3);
                    }
                }
                long l = 0L;
                long l2 = (long)n15 + (long)n4 + (long)(n17 * n12);
                if (this.pr.bool[1] && !this.pr.bool[3]) {
                    audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                }
                if (this.pr.bool[3]) {
                    fileArray = new File[n14];
                    floatFileArray = new FloatFile[n14];
                    for (n = 0; n < n14; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n14; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n4;
                }
                if (!this.threadRunning) break block81;
                if (audioFile != null) {
                    l2 += (long)n5;
                    audioFile.readFrames(fArray5, 0, n5);
                    for (n = 0; n < n2; ++n) {
                        Fourier.realTransform(fArray5[n], n7, 1);
                    }
                    audioFile.close();
                    audioFile = null;
                    this.setProgression((float)(l += (long)n5) / (float)l2);
                }
                if (!this.threadRunning) break block81;
                int n20 = 0;
                int n21 = 0;
                while (this.threadRunning && n19 < n17) {
                    int n22;
                    int n23;
                    int n24 = Math.min(n15 - n20, n12);
                    for (n22 = 0; this.threadRunning && n22 < n24; n22 += n23) {
                        n23 = Math.min(8192, n24 - n22);
                        audioFile3.readFrames(fArray4, n22 + n13, n23);
                        n20 += n23;
                        this.setProgression((float)(l += (long)n23) / (float)l2);
                    }
                    if (this.threadRunning) {
                        float f3;
                        for (n = 0; n < n14; ++n) {
                            fArray6 = fArray4[n];
                            for (n6 = n24 + n13; n6 < n10; ++n6) {
                                fArray6[n6] = 0.0f;
                            }
                        }
                        int n25 = n12;
                        int n26 = -1;
                        if (this.pr.bool[0]) {
                            for (n = 0; n < n14; ++n) {
                                fArray6 = fArray4[n];
                                float f4 = 0.0f;
                                n6 = n9;
                                for (n23 = 0; n23 < n8; ++n23) {
                                    fArray3[n23] = fArray6[n6 + 1] - fArray6[n6];
                                    f4 += fArray3[n23];
                                    ++n6;
                                }
                                f4 /= (float)n8;
                                float f5 = 0.0f;
                                for (n23 = 0; n23 < n8; ++n23) {
                                    f3 = fArray3[n23] - f4;
                                    f5 += f3 * f3;
                                }
                                f5 = (float)Math.sqrt(f5 / (float)n8);
                                float f6 = f * f5;
                                n6 = 0;
                                n23 = (n8 >> 2) - 1;
                                while (n6 < n12) {
                                    if (Math.abs(fArray3[n23] - f4) >= f6 && Math.abs(fArray3[n23]) >= f2) {
                                        n25 = Math.min(n25, n6);
                                        n26 = Math.max(n26, n6);
                                        if (this.pr.bool[3]) {
                                            vector.add(new Marker((long)((n19 - n16 + 1) * n12 + n6 + n11), MARK_CLICK));
                                        }
                                    }
                                    ++n6;
                                    ++n23;
                                }
                            }
                        }
                        if (this.pr.bool[2]) {
                            n6 = (n19 - n16 + 1) * n12 + n11;
                            while (marker != null) {
                                if (marker.pos >= (long)n6 && marker.pos < (long)(n6 + n12)) {
                                    n25 = Math.min(n25, (int)marker.pos - n6);
                                    n26 = Math.max(n26, (int)marker.pos - n6);
                                    if ((n3 = Marker.find((List)list, (String)MARK_CLICK, (int)(n3 + 1))) >= 0) {
                                        marker = (Marker)list.get(n3);
                                        continue;
                                    }
                                    marker = null;
                                    continue;
                                }
                                if (marker.pos >= (long)n6) break;
                                if ((n3 = Marker.find((List)list, (String)MARK_CLICK, (int)(n3 + 1))) >= 0) {
                                    marker = (Marker)list.get(n3);
                                    continue;
                                }
                                marker = null;
                            }
                        }
                        if (n26 >= 0 && n19 >= n16 && n19 <= n18) {
                            if (graphics != null) {
                                int n27 = (int)((float)n19 / (float)n17 * (float)dimension.width + 0.5f);
                                graphics.drawLine(n27, 0, n27, dimension.height - 1);
                            }
                            if (this.pr.bool[1]) {
                                for (n = 0; n < n14; ++n) {
                                    fArray6 = fArray4[n];
                                    System.arraycopy(fArray6, n25 + n11 - n9, fArray2, 0, n9);
                                    for (n6 = n9; n6 < n7; ++n6) {
                                        fArray2[n6] = 0.0f;
                                    }
                                    n6 = 0;
                                    for (n23 = n9 - 1; n23 >= 0; n23 -= 2) {
                                        int n28 = n6++;
                                        fArray2[n28] = fArray2[n28] * fArray[n23];
                                    }
                                    for (n23 = 0; n23 < n9; n23 += 2) {
                                        int n29 = n6++;
                                        fArray2[n29] = fArray2[n29] * fArray[n23];
                                    }
                                    Fourier.realTransform(fArray2, n7, 1);
                                    float[] fArray7 = fArray5[n % n2];
                                    for (n6 = 0; n6 <= n7; n6 += 2) {
                                        n23 = n6 + 1;
                                        f3 = fArray2[n6];
                                        fArray2[n6] = f3 * fArray7[n6] - fArray2[n23] * fArray7[n23];
                                        fArray2[n23] = f3 * fArray7[n23] + fArray2[n23] * fArray7[n6];
                                    }
                                    Fourier.realTransform(fArray2, n7, -1);
                                    n23 = n9 >> 1;
                                    n6 = n25 + n11 - n23;
                                    int n30 = 0;
                                    while (n23 < n9) {
                                        f3 = fArray[n30];
                                        fArray6[n6] = f3 * fArray6[n6] + (1.0f - f3) * fArray2[n23];
                                        ++n6;
                                        ++n23;
                                        n30 += 2;
                                    }
                                    n30 = n26 + n11;
                                    while (n6 <= n30) {
                                        fArray6[n6] = fArray2[n23];
                                        ++n6;
                                        ++n23;
                                    }
                                    n30 = 0;
                                    while (n30 < n9) {
                                        f3 = fArray[n30];
                                        fArray6[n6] = (1.0f - f3) * fArray6[n6] + f3 * fArray2[n23];
                                        n30 += 2;
                                        ++n6;
                                        ++n23;
                                    }
                                }
                            }
                        }
                        ++n19;
                        this.setProgression((float)(l += (long)n12) / (float)l2);
                        if (this.threadRunning) {
                            if (n19 >= n16) {
                                n24 = Math.min(n4 - n21, n12);
                                if (floatFileArray != null) {
                                    for (n = 0; n < n14; ++n) {
                                        floatFileArray[n].writeFloats(fArray4[n], 0, n24);
                                    }
                                    n21 += n24;
                                    n22 += n24;
                                    this.setProgression((float)(l += (long)n24) / (float)l2);
                                } else if (audioFile2 != null) {
                                    for (n22 = 0; this.threadRunning && n22 < n24; n22 += n23) {
                                        n23 = Math.min(8192, n24 - n22);
                                        audioFile2.writeFrames(fArray4, n22, n23);
                                        n21 += n23;
                                        this.setProgression((float)(l += (long)n23) / (float)l2);
                                    }
                                }
                            }
                            for (n = 0; n < n14; ++n) {
                                fArray6 = fArray4[n];
                                System.arraycopy(fArray6, n12, fArray6, 0, n10 - n12);
                            }
                            continue;
                        }
                    }
                    break block81;
                }
                if (this.threadRunning) {
                    if (floatFileArray != null) {
                        Collections.sort(vector);
                        if (vector.size() > 65535) {
                            System.out.println("WARNING: too many markers (" + vector.size() + "). Truncating to 65535!");
                            while (vector.size() > 65535) {
                                vector.remove(65535);
                            }
                        }
                        audioFileDescr2.setProperty("markers", vector);
                        audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                        this.normalizeAudioFile(floatFileArray, audioFile2, fArray4, 1.0f, 1.0f);
                        for (n = 0; n < n14; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    if (audioFile2 != null) {
                        audioFile2.close();
                        audioFile2 = null;
                    }
                    audioFile3.close();
                    audioFile3 = null;
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                audioFileDescr3 = null;
                fArray4 = null;
                fArray3 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(258);
        if (component != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(260)) != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(512)) != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(259)) != null) {
            component.setEnabled(this.pr.bool[1]);
        }
        if ((component = this.gui.getItemObj(1026)) != null) {
            component.setEnabled(this.pr.bool[1]);
        }
    }
}

