/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class DrMurkeDlg
extends ModulePanel {
    private static final boolean verbose = false;
    private static final int PR_INPUTFILE = 0;
    private static final int PR_CTRLFILE = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_MODE = 3;
    private static final int PR_CHANNELUP = 4;
    private static final int PR_CHANNELDOWN = 5;
    private static final int PR_SPACINGTYPE = 6;
    private static final int PR_THRESHUP = 0;
    private static final int PR_THRESHDOWN = 1;
    private static final int PR_DURUP = 2;
    private static final int PR_DURDOWN = 3;
    private static final int PR_ATTACK = 4;
    private static final int PR_RELEASE = 5;
    private static final int PR_GAIN = 6;
    private static final int PR_SPACING = 7;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_CTRLFILE = "CtrlFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_MODE = "Mode";
    private static final String PRN_CHANNELUP = "ChannelUp";
    private static final String PRN_CHANNELDOWN = "ChannelDown";
    private static final String PRN_SPACINGTYPE = "SpacingType";
    private static final String PRN_THRESHUP = "ThreshUp";
    private static final String PRN_THRESHDOWN = "ThreshDown";
    private static final String PRN_DURUP = "DurUp";
    private static final String PRN_DURDOWN = "DurDown";
    private static final String PRN_ATTACK = "Attack";
    private static final String PRN_RELEASE = "Release";
    private static final String PRN_SPACING = "Spacing";
    private static final String[] MODE_NAMES = new String[]{"Keep Upper Chunks", "Keep Down Chunks"};
    private static final int MODE_UPPER = 0;
    private static final int MODE_DOWN = 1;
    private static final String[] CHANNEL_NAMES = new String[]{"Take Maximum", "Take Minimum"};
    private static final int CHANNEL_MAX = 0;
    private static final int CHANNEL_MIN = 1;
    private static final String[] SPACING_NAMES = new String[]{"Fixed Spacing:", "Original Spacing"};
    private static final int SPACING_FIXED = 0;
    private static final int SPACING_ORIGINAL = 1;
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "CtrlFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0, 1, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "Mode", "ChannelUp", "ChannelDown", "SpacingType"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"ThreshUp", "ThreshDown", "DurUp", "DurDown", "Attack", "Release", "Gain", "Spacing"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_CTRLFILE = 1025;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_MODE = 259;
    private static final int GG_CHANNELUP = 260;
    private static final int GG_CHANNELDOWN = 261;
    private static final int GG_SPACINGTYPE = 262;
    private static final int GG_THRESHUP = 512;
    private static final int GG_THRESHDOWN = 513;
    private static final int GG_DURUP = 514;
    private static final int GG_DURDOWN = 515;
    private static final int GG_ATTACK = 516;
    private static final int GG_RELEASE = 517;
    private static final int GG_GAIN = 518;
    private static final int GG_SPACING = 519;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public DrMurkeDlg() {
        super("Dr Murke");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            DrMurkeDlg.static_pr.text = prText;
            DrMurkeDlg.static_pr.textName = prTextName;
            DrMurkeDlg.static_pr.intg = prIntg;
            DrMurkeDlg.static_pr.intgName = prIntgName;
            DrMurkeDlg.static_pr.para = prPara;
            DrMurkeDlg.static_pr.para[0] = new Param(30.0, 17);
            DrMurkeDlg.static_pr.para[1] = new Param(20.0, 17);
            DrMurkeDlg.static_pr.para[2] = new Param(100.0, 2);
            DrMurkeDlg.static_pr.para[3] = new Param(10.0, 2);
            DrMurkeDlg.static_pr.para[4] = new Param(10.0, 2);
            DrMurkeDlg.static_pr.para[5] = new Param(1000.0, 2);
            DrMurkeDlg.static_pr.para[7] = new Param(1000.0, 2);
            DrMurkeDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(DrMurkeDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(DrMurkeDlg.static_pr.para, 6);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = DrMurkeDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 262: {
                        ((DrMurkeDlg)DrMurkeDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        DrMurkeDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select control file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Control file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField3.deriveFrom(pathFieldArray, "$D0$F0Mur$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 518, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Segmentation Settings", 1, 0));
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[5], Constants.spaces[7]};
        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{Constants.spaces[8]};
        ParamField paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Up Thresh:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 512, null);
        ParamField paramField2 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Min. Up Duration:", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 514, null);
        ParamField paramField3 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Down Thresh:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 513, null);
        ParamField paramField4 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Min. Down Duration:", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 515, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 0; n < CHANNEL_NAMES.length; ++n) {
            jComboBox.addItem(CHANNEL_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Multi-channel Up Treatment:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 260, null);
        ParamField paramField5 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Attack:", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField5, 516, null);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < CHANNEL_NAMES.length; ++n) {
            jComboBox2.addItem(CHANNEL_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Multi-channel Down Treatment:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox2, 261, null);
        ParamField paramField6 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Release:", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField6, 517, null);
        JComboBox<String> jComboBox3 = new JComboBox<String>();
        for (n = 0; n < MODE_NAMES.length; ++n) {
            jComboBox3.addItem(MODE_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Mode:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox3, 259, null);
        JComboBox<String> jComboBox4 = new JComboBox<String>();
        for (n = 0; n < SPACING_NAMES.length; ++n) {
            jComboBox4.addItem(SPACING_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addChoice(jComboBox4, 262, itemListener);
        ParamField paramField7 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField7, 519, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile = null;
        AudioFile audioFile2 = null;
        AudioFile audioFile3 = null;
        float f = 1.0f;
        Param param = new Param(1.0, 1);
        float f2 = 0.0f;
        try {
            audioFile = AudioFile.openAsRead((File)new File(this.pr.text[0]));
            AudioFileDescr audioFileDescr = audioFile.getDescr();
            int n = audioFileDescr.channels;
            long l = audioFileDescr.length;
            if (l < 1L || n < 1) {
                throw new EOFException("File is empty");
            }
            audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
            AudioFileDescr audioFileDescr2 = audioFile2.getDescr();
            int n2 = audioFileDescr2.channels;
            long l2 = audioFileDescr2.length;
            if (l2 < 1L || n2 < 1) {
                throw new EOFException("File is empty");
            }
            double d = (double)l2 / (double)l;
            PathField pathField = (PathField)this.gui.getItemObj(1026);
            if (pathField == null) {
                throw new IOException("Bug! Missing property!");
            }
            AudioFileDescr audioFileDescr3 = new AudioFileDescr(audioFileDescr);
            pathField.fillStream(audioFileDescr3);
            audioFile3 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr3);
            if (this.threadRunning) {
                AudioFile audioFile4;
                boolean bl;
                boolean bl2 = bl = this.pr.intg[2] == 0;
                if (bl) {
                    audioFile4 = this.createTempFile(audioFileDescr3);
                } else {
                    f = (float)Param.transform((Param)this.pr.para[6], (int)1, (Param)param, null).value;
                    audioFile4 = null;
                }
                if (this.threadRunning) {
                    int n3;
                    int n4;
                    long l3;
                    Track track;
                    long l4 = 0L;
                    long l5 = l2 * (long)(bl ? 2 : 1);
                    float[][] fArray = new float[n][8192];
                    float[][] fArray2 = new float[n][8192];
                    float[][] fArray3 = new float[n2][8192];
                    float[] fArray4 = new float[n2];
                    float f3 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                    float f4 = (float)Param.transform((Param)this.pr.para[1], (int)1, (Param)param, null).value;
                    long l6 = Math.max(1L, (long)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[2].value) * d + 0.5));
                    long l7 = Math.max(1L, (long)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[3].value) * d + 0.5));
                    long l8 = (long)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[4].value) + 0.5);
                    long l9 = (long)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[5].value) + 0.5);
                    AboveFunc aboveFunc = this.pr.intg[4] == 0 ? new AboveFunc(new MaxFunc(), f4) : new AboveFunc(new MinFunc(), f4);
                    BelowFunc belowFunc = this.pr.intg[5] == 0 ? new BelowFunc(new MaxFunc(), f3) : new BelowFunc(new MinFunc(), f3);
                    Track track2 = new Track("up", l7, aboveFunc, this.pr.intg[3] == 0);
                    track2.other = track = new Track("dn", l6, belowFunc, this.pr.intg[3] == 1);
                    track.other = track2;
                    Track track3 = track.write ? track2 : track;
                    ArrayList<Fade> arrayList = new ArrayList<Fade>();
                    long l10 = 0L;
                    long l11 = 0L;
                    long l12 = 0L;
                    Fade fade = null;
                    boolean bl3 = this.pr.intg[6] == 1;
                    long l13 = l3 = bl3 ? 0L : (long)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[7].value) + 0.5);
                    for (long i = 0L; this.threadRunning && i < l2; i += (long)n4) {
                        n4 = (int)Math.min(8192L, l2 - i);
                        audioFile2.readFrames(fArray3, 0, n4);
                        for (int j = 0; j < n4; ++j) {
                            long l14;
                            long l15;
                            for (n3 = 0; n3 < n2; ++n3) {
                                fArray4[n3] = fArray3[n3][j];
                            }
                            n3 = track3.fun.thresh(fArray4) ? 1 : 0;
                            long l16 = i + (long)j;
                            long l17 = (long)((double)l16 / d + 0.5);
                            if (n3 != 0) {
                                track3.offCount = 0L;
                                continue;
                            }
                            if (track3.offCount == 0L) {
                                track3.offFrame = l17;
                            }
                            ++track3.offCount;
                            if (track3.offCount < track3.maxCount) continue;
                            if (track3.write) {
                                fade.out(track3.offFrame, l9);
                                arrayList.add(fade);
                                fade = null;
                                l15 = Math.max(0L, (l12 += l17 - l11 + l3) - l8 - l10);
                                l14 = bl3 ? Math.min(l - l10, l15) : l15;
                                f2 = this.writeFrames(audioFile4 == null ? audioFile3 : audioFile4, l10, l14, fArray2, arrayList, f2, bl, f);
                                l10 += l14;
                            } else {
                                l15 = Math.max(0L, track3.offFrame - l8);
                                l14 = Math.min(l8, track3.offFrame - l15);
                                l11 = l15 + l14;
                                if (bl3) {
                                    long l18 = l15 + l14;
                                    if (l18 < l12) {
                                        throw new IllegalArgumentException("Ooops. Assertion");
                                    }
                                    l12 = l18;
                                }
                                fade = new Fade(audioFile, fArray, l15, l12 - l14, l14);
                            }
                            track3 = track3.other;
                            track3.offCount = 0L;
                        }
                        this.setProgression((float)(l4 += (long)n4) / (float)l5);
                    }
                    if (this.threadRunning) {
                        audioFile2.close();
                        audioFile2 = null;
                        long l19 = 0L;
                        if (fade != null) {
                            arrayList.add(fade);
                        }
                        if (bl3) {
                            l19 = l - l10;
                        } else {
                            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                                Fade fade2 = (Fade)arrayList.get(n3);
                                l19 = Math.max(l19, fade2.remaining(l10));
                            }
                        }
                        f2 = this.writeFrames(audioFile4 == null ? audioFile3 : audioFile4, l10, l19, fArray2, arrayList, f2, bl, f);
                        audioFile.close();
                        audioFile = null;
                        if (bl) {
                            f = (float)Param.transform((Param)this.pr.para[6], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                            this.normalizeAudioFile(audioFile4, audioFile3, fArray, f, 1.0f);
                            this.deleteTempFile(audioFile4);
                        }
                        this.setProgression(1.0f);
                        if (this.threadRunning) {
                            audioFile3.close();
                            audioFile3 = null;
                            this.handleClipping(f2 *= f);
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
    }

    private float writeFrames(AudioFile audioFile, long l, long l2, float[][] fArray, List list, float f, boolean bl, float f2) throws IOException {
        long l3 = l + l2;
        while (l < l3) {
            int n = (int)Math.min(8192L, l3 - l);
            Util.clear(fArray);
            for (int i = list.size() - 1; i >= 0; --i) {
                Fade fade = (Fade)list.get(i);
                if (fade.remaining(l) == 0L) {
                    list.remove(i);
                    continue;
                }
                fade.process(fArray, l, 0, n);
            }
            f = Math.max(f, Util.maxAbs(fArray, 0, n));
            if (!bl) {
                Util.mult(fArray, 0, n, f2);
            }
            audioFile.writeFrames(fArray, 0, n);
            l += (long)n;
        }
        return f;
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(519);
        if (component != null) {
            component.setEnabled(this.pr.intg[6] == 0);
        }
    }

    private static class Fade {
        private final AudioFile af;
        private final float[][] inBuf;
        private final long inOffset;
        private long fadeOutOffset = -1L;
        private final long outOffset;
        private final long fadeInFrames;
        private long fadeOutFrames;
        private long fadeOutStop;
        private final long fileNumFrames;

        public Fade(AudioFile audioFile, float[][] fArray, long l, long l2, long l3) throws IOException {
            this.af = audioFile;
            this.inBuf = fArray;
            this.inOffset = l;
            this.outOffset = l2;
            this.fadeInFrames = l3;
            this.fileNumFrames = audioFile.getFrameNum();
        }

        public void out(long l, long l2) {
            if (this.fadeOutOffset >= 0L) {
                throw new IllegalStateException("Duplicate call");
            }
            if (l < this.inOffset) {
                throw new IllegalArgumentException("" + this.inOffset + " -> " + l);
            }
            this.fadeOutOffset = l - this.inOffset;
            this.fadeOutFrames = l2;
            this.fadeOutStop = Math.min(this.fileNumFrames - this.inOffset, this.fadeOutOffset + this.fadeOutFrames);
        }

        public long remaining(long l) throws IOException {
            return Math.max(0L, (this.fadeOutOffset == -1L ? this.fileNumFrames - this.inOffset : this.fadeOutStop) - (l - this.outOffset));
        }

        public void process(float[][] fArray, long l, int n, int n2) throws IOException {
            this.fadeIn(fArray, l, n, n2);
            this.fadeOut(fArray, l, n, n2);
        }

        private void fadeIn(float[][] fArray, long l, int n, int n2) throws IOException {
            long l2;
            long l3 = l - this.outOffset;
            long l4 = Math.max(0L, -l3);
            if (l4 >= (long)n2) {
                return;
            }
            int n3 = (int)l4;
            int n4 = n + n3;
            int n5 = n2 - n3;
            long l5 = l3 + (long)n3;
            long l6 = l2 = this.fadeOutOffset == -1L ? l5 + (long)n5 : Math.min(this.fadeOutOffset, l5 + (long)n5);
            if (l2 <= l5) {
                return;
            }
            int n6 = (int)(l2 - l5);
            long l7 = this.inOffset + l5;
            long l8 = Math.max(0L, -l7);
            if (l4 >= (long)n6) {
                return;
            }
            int n7 = (int)l8;
            int n8 = n4 + n7;
            int n9 = n6 - n7;
            long l9 = l5 + (long)n7;
            long l10 = l7 + (long)n7;
            if (this.af.getFramePosition() != l10) {
                this.af.seekFrame(l10);
            }
            this.af.readFrames(this.inBuf, 0, n9);
            int n10 = 0;
            int n11 = n8;
            while (n10 < n9) {
                float f = Math.max(0.0f, Math.min(1.0f, (float)(l9 + (long)n10) / (float)this.fadeInFrames));
                for (int i = 0; i < fArray.length; ++i) {
                    float[] fArray2 = fArray[i];
                    int n12 = n11;
                    fArray2[n12] = fArray2[n12] + this.inBuf[i][n10] * f;
                }
                ++n10;
                ++n11;
            }
        }

        private void fadeOut(float[][] fArray, long l, int n, int n2) throws IOException {
            if (this.fadeOutOffset == -1L) {
                return;
            }
            long l2 = l - (this.outOffset + this.fadeOutOffset);
            long l3 = Math.max(0L, -l2);
            if (l3 >= (long)n2) {
                return;
            }
            int n3 = (int)l3;
            int n4 = n + n3;
            long l4 = l2 + (long)n3;
            long l5 = Math.min(this.fileNumFrames, this.inOffset + this.fadeOutOffset + l4);
            int n5 = (int)Math.min((long)(n2 - n3), this.fileNumFrames - l5);
            if (this.af.getFramePosition() != l5) {
                this.af.seekFrame(l5);
            }
            this.af.readFrames(this.inBuf, 0, n5);
            int n6 = 0;
            int n7 = n4;
            while (n6 < n5) {
                float f = Math.max(0.0f, Math.min(1.0f, 1.0f - (float)(l4 + (long)n6) / (float)this.fadeOutFrames));
                for (int i = 0; i < fArray.length; ++i) {
                    float[] fArray2 = fArray[i];
                    int n8 = n7;
                    fArray2[n8] = fArray2[n8] + this.inBuf[i][n6] * f;
                }
                ++n6;
                ++n7;
            }
        }
    }

    private static class Track {
        final String name;
        final long maxCount;
        final ThreshFunc fun;
        final boolean write;
        long offCount = 0L;
        long offFrame;
        Track other;

        public Track(String string, long l, ThreshFunc threshFunc, boolean bl) {
            this.name = string;
            this.maxCount = l;
            this.fun = threshFunc;
            this.write = bl;
        }
    }

    private static class BelowFunc
    implements ThreshFunc {
        private final CollapseFunc collapse;
        private final float thresh;

        public BelowFunc(CollapseFunc collapseFunc, float f) {
            this.collapse = collapseFunc;
            this.thresh = f;
        }

        @Override
        public boolean thresh(float[] fArray) {
            return this.collapse.collapse(fArray) < this.thresh;
        }
    }

    private static class AboveFunc
    implements ThreshFunc {
        private final CollapseFunc collapse;
        private final float thresh;

        public AboveFunc(CollapseFunc collapseFunc, float f) {
            this.collapse = collapseFunc;
            this.thresh = f;
        }

        @Override
        public boolean thresh(float[] fArray) {
            return this.collapse.collapse(fArray) >= this.thresh;
        }
    }

    private static class MaxFunc
    implements CollapseFunc {
        private MaxFunc() {
        }

        @Override
        public float collapse(float[] fArray) {
            float f = fArray[0];
            for (int i = 0; i < fArray.length; ++i) {
                f = Math.max(f, fArray[i]);
            }
            return f;
        }
    }

    private static class MinFunc
    implements CollapseFunc {
        private MinFunc() {
        }

        @Override
        public float collapse(float[] fArray) {
            float f = fArray[0];
            for (int i = 0; i < fArray.length; ++i) {
                f = Math.min(f, fArray[i]);
            }
            return f;
        }
    }

    private static interface ThreshFunc {
        public boolean thresh(float[] var1);
    }

    private static interface CollapseFunc {
        public float collapse(float[] var1);
    }
}

