/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.CircuitPanel;
import de.sciss.fscape.gui.CompactPanel;
import de.sciss.fscape.gui.FilterBox;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamEvent;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.ParamListener;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.gui.VectorPanel;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.gui.VectorSpace;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.Marker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class FIRDesignerDlg
extends ModulePanel
implements VectorPanel.Client {
    public static final int QUAL_LOW = 0;
    public static final int QUAL_MEDIUM = 1;
    public static final int QUAL_GOOD = 2;
    public static final int QUAL_VERYGOOD = 3;
    public static final String[] QUAL_NAMES = new String[]{"Short", "Medium", "Long", "Very Long"};
    public static final String MARK_SUPPORT = "Support";
    private static final int PR_OUTPUTFILE = 0;
    private static final int PR_CIRCUIT = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_OUTPUTRATE = 2;
    private static final int PR_QUALITY = 3;
    private static final int PR_WINDOW = 4;
    private static final int PR_GAINTYPE = 5;
    private static final int PR_MINPHASE = 0;
    private static final int PR_GAIN = 0;
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_CIRCUIT = "Circuit";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputRes";
    private static final String PRN_OUTPUTRATE = "OutputRate";
    private static final String PRN_QUALITY = "Quality";
    private static final String PRN_WINDOW = "Window";
    private static final String PRN_MINPHASE = "MinPhase";
    private static final String[] prText = new String[]{"", "03{1;false;1000.0,3;250.0,35;0.0,785;0.0,2;false;5000.0,3;1000.0,35}"};
    private static final String[] prTextName = new String[]{"OutputFile", "Circuit"};
    private static final int[] prIntg = new int[]{0, 2, 0, 2, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputRes", "OutputRate", "Quality", "Window", "GainType"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"MinPhase"};
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"Gain"};
    private static final int GG_OUTPUTFILE = 1024;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_OUTPUTRATE = 258;
    private static final int GG_QUALITY = 259;
    private static final int GG_WINDOW = 260;
    private static final int GG_GAINTYPE = 261;
    private static final int GG_MINPHASE = 0;
    private static final int GG_GAIN = 512;
    private static final int GG_CIRCUIT = 2048;
    private static final int GG_FILTERTYPE = 2049;
    private static final int GG_SIGN = 2050;
    private static final int GG_CUTOFF = 2051;
    private static final int GG_BANDWIDTH = 2052;
    private static final int GG_FILTERGAIN = 2053;
    private static final int GG_DELAY = 2054;
    private static final int GG_OTLIMIT = 2055;
    private static final int GG_OTSPACING = 2056;
    private static final int GG_OVERTONES = 2057;
    private static final int GG_ROLLOFF = 2058;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_SELECTED = 0;
    private static final int CMD_DESELECTED = 1;
    private static final int CMD_CREATED = 2;
    private static final int CMD_DELETED = 3;
    private FilterBox currentFlt = null;
    private static final String ERR_RESULT_EMPTY = "IR length will be zero";
    private final MessageFormat msgHertz = new MessageFormat("{0,number,0.0} Hz", Locale.US);
    private final MessageFormat msgDecibel = new MessageFormat("{0,number,0.0} dB", Locale.US);
    private final MessageFormat msgPlain = new MessageFormat("{0,number,0.000}", Locale.US);
    private VectorPanel spectPane;
    private CircuitPanel ggCircuit;

    public FIRDesignerDlg() {
        super("FIR Designer");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            FIRDesignerDlg.static_pr.text = prText;
            FIRDesignerDlg.static_pr.textName = prTextName;
            FIRDesignerDlg.static_pr.intg = prIntg;
            FIRDesignerDlg.static_pr.intgName = prIntgName;
            FIRDesignerDlg.static_pr.bool = prBool;
            FIRDesignerDlg.static_pr.boolName = prBoolName;
            FIRDesignerDlg.static_pr.para = prPara;
            FIRDesignerDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(FIRDesignerDlg.static_pr.intg, 0, -1, 2);
            this.fillDefaultGain(FIRDesignerDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = FIRDesignerDlg.this.gui.getItemID(itemEvent);
                boolean bl = FIRDesignerDlg.this.currentFlt != null;
                switch (n) {
                    case 2049: {
                        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.filterType = jComboBox.getSelectedIndex();
                        FIRDesignerDlg.this.ggCircuit.repaintBox(FIRDesignerDlg.this.currentFlt);
                        FIRDesignerDlg.this.reflectPropertyChanges();
                        break;
                    }
                    case 2050: {
                        JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.sign = jCheckBox.isSelected();
                        FIRDesignerDlg.this.ggCircuit.repaintBox(FIRDesignerDlg.this.currentFlt);
                        break;
                    }
                    case 2057: {
                        JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.overtones = jCheckBox.isSelected();
                        FIRDesignerDlg.this.ggCircuit.repaintBox(FIRDesignerDlg.this.currentFlt);
                        FIRDesignerDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        ParamListener paramListener = new ParamListener(){

            @Override
            public void paramChanged(ParamEvent paramEvent) {
                int n = FIRDesignerDlg.this.gui.getItemID((EventObject)((Object)paramEvent));
                boolean bl = FIRDesignerDlg.this.currentFlt != null;
                switch (n) {
                    case 2051: {
                        ParamField paramField = (ParamField)paramEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.cutOff = paramField.getParam();
                        break;
                    }
                    case 2052: {
                        ParamField paramField = (ParamField)paramEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.bandwidth = paramField.getParam();
                        break;
                    }
                    case 2058: {
                        ParamField paramField = (ParamField)paramEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.rollOff = paramField.getParam();
                        break;
                    }
                    case 2053: {
                        ParamField paramField = (ParamField)paramEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.gain = paramField.getParam();
                        FIRDesignerDlg.this.ggCircuit.repaintBox(FIRDesignerDlg.this.currentFlt);
                        break;
                    }
                    case 2054: {
                        ParamField paramField = (ParamField)paramEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.delay = paramField.getParam();
                        FIRDesignerDlg.this.ggCircuit.repaintBox(FIRDesignerDlg.this.currentFlt);
                        break;
                    }
                    case 2055: {
                        ParamField paramField = (ParamField)paramEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.otLimit = paramField.getParam();
                        break;
                    }
                    case 2056: {
                        ParamField paramField = (ParamField)paramEvent.getSource();
                        if (!bl) break;
                        ((FIRDesignerDlg)FIRDesignerDlg.this).currentFlt.otSpacing = paramField.getParam();
                    }
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FIRDesignerDlg.this.gui.getItemID(actionEvent);
                switch (n) {
                    case 2048: {
                        boolean bl;
                        String string = actionEvent.getActionCommand();
                        int n2 = -1;
                        if (string.equals("act")) {
                            n2 = 0;
                        } else if (string.equals("des")) {
                            n2 = 1;
                        } else if (string.equals("new")) {
                            n2 = 2;
                        } else if (string.equals("rem")) {
                            n2 = 3;
                        }
                        FilterBox filterBox = null;
                        switch (n2) {
                            case 0: 
                            case 2: {
                                filterBox = (FilterBox)((CircuitPanel)actionEvent.getSource()).getActiveBox();
                            }
                        }
                        if (filterBox == FIRDesignerDlg.this.currentFlt) {
                            return;
                        }
                        FIRDesignerDlg.this.currentFlt = filterBox;
                        boolean bl2 = bl = filterBox != null;
                        if (bl) {
                            ParamField paramField;
                            JCheckBox jCheckBox;
                            JComboBox jComboBox = (JComboBox)FIRDesignerDlg.this.gui.getItemObj(2049);
                            if (jComboBox != null) {
                                jComboBox.setSelectedIndex(filterBox.filterType);
                                switch (filterBox.filterType) {
                                    default: 
                                }
                            }
                            if ((jCheckBox = (JCheckBox)FIRDesignerDlg.this.gui.getItemObj(2050)) != null) {
                                jCheckBox.setSelected(filterBox.sign);
                            }
                            if ((paramField = (ParamField)FIRDesignerDlg.this.gui.getItemObj(2051)) != null) {
                                paramField.setParam(filterBox.cutOff);
                            }
                            if ((paramField = (ParamField)FIRDesignerDlg.this.gui.getItemObj(2052)) != null) {
                                paramField.setParam(filterBox.bandwidth);
                            }
                            if ((paramField = (ParamField)FIRDesignerDlg.this.gui.getItemObj(2058)) != null) {
                                paramField.setParam(filterBox.rollOff);
                            }
                            if ((paramField = (ParamField)FIRDesignerDlg.this.gui.getItemObj(2053)) != null) {
                                paramField.setParam(filterBox.gain);
                            }
                            if ((paramField = (ParamField)FIRDesignerDlg.this.gui.getItemObj(2054)) != null) {
                                paramField.setParam(filterBox.delay);
                            }
                            if ((jCheckBox = (JCheckBox)FIRDesignerDlg.this.gui.getItemObj(2057)) != null) {
                                jCheckBox.setSelected(filterBox.overtones);
                            }
                            if ((paramField = (ParamField)FIRDesignerDlg.this.gui.getItemObj(2055)) != null) {
                                paramField.setParam(filterBox.otLimit);
                            }
                            if ((paramField = (ParamField)FIRDesignerDlg.this.gui.getItemObj(2056)) != null) {
                                paramField.setParam(filterBox.otSpacing);
                            }
                        }
                        FIRDesignerDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        Box box = Box.createVerticalBox();
        box.add(new GroupLabel("FIR Output", 1, 0));
        CompactPanel compactPanel = new CompactPanel();
        PathField pathField = new PathField(113, "Select output file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        this.gui.registerGadget(pathField, 1024);
        this.gui.registerGadget(pathField.getTypeGadget(), 256);
        this.gui.registerGadget(pathField.getResGadget(), 257);
        this.gui.registerGadget(pathField.getRateGadget(), 258);
        compactPanel.addGadget(new JLabel("File name:", 4));
        compactPanel.addGadget(pathField);
        compactPanel.newLine();
        Box box2 = Box.createHorizontalBox();
        Component[] componentArray = this.createGadgets(0);
        compactPanel.addGadget(new JLabel("Gain", 4));
        this.gui.registerGadget(componentArray[0], 512);
        ((ParamField)componentArray[0]).addParamListener(paramListener);
        this.gui.registerGadget(componentArray[1], 261);
        ((JComboBox)componentArray[1]).addItemListener(itemListener);
        box2.add(componentArray[0]);
        box2.add(componentArray[1]);
        compactPanel.addGadget(box2);
        compactPanel.compact();
        box.add(compactPanel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)box, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new GroupLabel("Filter Settings", 1, 0), "North");
        this.ggCircuit = new CircuitPanel(new FilterBox());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.putClientProperty("styleId", "attached");
        jTabbedPane.addTab(PRN_CIRCUIT, this.ggCircuit);
        this.gui.registerGadget(this.ggCircuit, 2048);
        this.ggCircuit.addActionListener(actionListener);
        this.spectPane = new VectorPanel(this, 7);
        jTabbedPane.addTab("Mag. spectrum", this.spectPane);
        compactPanel = new CompactPanel();
        box2 = Box.createHorizontalBox();
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("All Pass");
        jComboBox.addItem("Low Pass");
        jComboBox.addItem("High Pass");
        jComboBox.addItem("Band Pass");
        jComboBox.addItem("Band Stop");
        compactPanel.addGadget(new JLabel("Type:", 4));
        this.gui.registerGadget(jComboBox, 2049);
        jComboBox.addItemListener(itemListener);
        box2.add(jComboBox);
        JCheckBox jCheckBox = new JCheckBox("Subtract");
        this.gui.registerGadget(jCheckBox, 2050);
        jCheckBox.addItemListener(itemListener);
        box2.add(jCheckBox);
        compactPanel.addGadget(box2);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[18], Constants.spaces[19]};
        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{Constants.spaces[15], paramSpaceArray[0], paramSpaceArray[1]};
        ParamSpace[] paramSpaceArray3 = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9]};
        compactPanel.newLine();
        ParamField paramField = new ParamField(Constants.spaces[15]);
        compactPanel.addGadget(new JLabel("Cutoff:", 4));
        this.gui.registerGadget(paramField, 2051);
        paramField.addParamListener(paramListener);
        compactPanel.addGadget(paramField);
        compactPanel.newLine();
        ParamField paramField2 = new ParamField(paramSpaceArray);
        paramField2.setReference(paramField);
        compactPanel.addGadget(new JLabel("Roll-off:", 4));
        this.gui.registerGadget(paramField2, 2058);
        paramField2.addParamListener(paramListener);
        compactPanel.addGadget(paramField2);
        compactPanel.newLine();
        ParamField paramField3 = new ParamField(paramSpaceArray);
        paramField3.setReference(paramField);
        compactPanel.addGadget(new JLabel("Bandwidth:", 4));
        this.gui.registerGadget(paramField3, 2052);
        paramField3.addParamListener(paramListener);
        compactPanel.addGadget(paramField3);
        compactPanel.newLine();
        ParamField paramField4 = new ParamField(Constants.spaces[7]);
        compactPanel.addGadget(new JLabel("Gain:", 4));
        this.gui.registerGadget(paramField4, 2053);
        paramField4.addParamListener(paramListener);
        compactPanel.addGadget(paramField4);
        compactPanel.newLine();
        ParamField paramField5 = new ParamField(paramSpaceArray3);
        compactPanel.addGadget(new JLabel("Delay:", 4));
        this.gui.registerGadget(paramField5, 2054);
        paramField5.addParamListener(paramListener);
        compactPanel.addGadget(paramField5);
        compactPanel.newLine();
        compactPanel.addEmptyColumn();
        JCheckBox jCheckBox2 = new JCheckBox("Add 'overtones'");
        this.gui.registerGadget(jCheckBox2, 2057);
        jCheckBox2.addItemListener(itemListener);
        compactPanel.addGadget(jCheckBox2);
        compactPanel.newLine();
        ParamField paramField6 = new ParamField(paramSpaceArray2);
        paramField6.setReference(paramField);
        compactPanel.addGadget(new JLabel("Limit freq:", 4));
        this.gui.registerGadget(paramField6, 2055);
        paramField6.addParamListener(paramListener);
        compactPanel.addGadget(paramField6);
        compactPanel.newLine();
        ParamField paramField7 = new ParamField(paramSpaceArray);
        paramField7.setReference(paramField);
        compactPanel.addGadget(new JLabel("Spacing:", 4));
        this.gui.registerGadget(paramField7, 2056);
        paramField7.addParamListener(paramListener);
        compactPanel.addGadget(paramField7);
        compactPanel.compact(8, 0);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jTabbedPane, "Center");
        jPanel3.add((Component)compactPanel, "North");
        jPanel2.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(3, 4, 2));
        JComboBox jComboBox2 = new JComboBox();
        GUISupport.addItemsToChoice(Filter.getWindowNames(), jComboBox2);
        jPanel4.add(new JLabel("IIR\u2192FIR win:", 4));
        this.gui.registerGadget(jComboBox2, 260);
        jComboBox2.addItemListener(itemListener);
        jPanel4.add(jComboBox2);
        JComboBox<String> jComboBox3 = new JComboBox<String>();
        for (String string : QUAL_NAMES) {
            jComboBox3.addItem(string);
        }
        jPanel4.add(Box.createHorizontalStrut(4));
        jPanel4.add(new JLabel("Filter Length:", 4));
        this.gui.registerGadget(jComboBox3, 259);
        jComboBox3.addItemListener(itemListener);
        jPanel4.add(jComboBox3);
        JCheckBox jCheckBox3 = new JCheckBox("Make minimum phase");
        this.gui.registerGadget(jCheckBox3, 0);
        jCheckBox3.addItemListener(itemListener);
        jPanel4.add(Box.createHorizontalStrut(4));
        jPanel4.add(jCheckBox3);
        jPanel.add((Component)jPanel4, "South");
        this.initGUI(this, 6, jPanel);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        this.ggCircuit.setCircuit(this.pr.text[1]);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
        this.pr.text[1] = this.ggCircuit.getCircuit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void process() {
        AudioFile audioFile;
        block25: {
            float f = 0.0f;
            audioFile = null;
            int n = 1;
            Param param = new Param(1.0, 1);
            try {
                int n2;
                int n3;
                int n4;
                PathField pathField = (PathField)this.gui.getItemObj(1024);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                AudioFileDescr audioFileDescr = new AudioFileDescr();
                pathField.fillStream(audioFileDescr);
                audioFileDescr.channels = n;
                if (!this.threadRunning) break block25;
                Point point = this.calcLength(this.ggCircuit, audioFileDescr);
                int n5 = point.x + point.y;
                if (this.pr.bool[0]) {
                    n5 *= 2;
                }
                if (n5 <= 0) {
                    throw new IOException(ERR_RESULT_EMPTY);
                }
                for (n4 = 2; n4 < n5; n4 <<= 1) {
                }
                int n6 = n4 << 1;
                IOUtil.createEmptyFile((File)new File(this.pr.text[0]));
                long l = 0L;
                long l2 = (long)n5 * 3L;
                float[] fArray = new float[this.pr.bool[0] ? n6 : n4 + 2];
                float[][] fArrayArray = new float[n][];
                for (n3 = 0; n3 < n; ++n3) {
                    fArrayArray[n3] = fArray;
                }
                float[][] fArrayArray2 = new float[3][];
                fArrayArray2[0] = fArray;
                fArrayArray2[1] = new float[1];
                fArrayArray2[1][0] = 0.0f;
                fArrayArray2[2] = new float[point.x];
                this.calcIR(this.ggCircuit, audioFileDescr, fArrayArray2, point, n4);
                this.setProgression((float)(l += (long)n5) / (float)l2);
                if (!this.threadRunning) break block25;
                if (this.pr.bool[0]) {
                    if (fArrayArray2[1][0] == 0.0f) {
                        Util.rotate(fArray, n4, fArrayArray2[2], -point.x);
                        Fourier.realTransform(fArray, n4, 1);
                        fArrayArray2[1][0] = 1.0f;
                    }
                    Fourier.rect2Polar(fArray, 0, fArray, 0, n4 + 2);
                    for (n3 = 0; n3 <= n4; n3 += 2) {
                        fArray[n3] = (float)Math.log(Math.max(1.0E-48, (double)fArray[n3]));
                    }
                    n3 = n4 + 2;
                    n2 = n4 - 2;
                    while (n3 < n6) {
                        fArray[n3++] = fArray[n2];
                        fArray[n3++] = 0.0f;
                        n2 -= 2;
                    }
                    Fourier.complexTransform(fArray, n4, -1);
                    n2 = n6 - 2;
                    for (n3 = 2; n3 < n4; n3 += 2, n2 -= 2) {
                        int n7 = n3;
                        fArray[n7] = fArray[n7] + fArray[n2];
                        int n8 = n3 + 1;
                        fArray[n8] = fArray[n8] - fArray[n2 + 1];
                    }
                    fArray[n4 + 1] = -fArray[n4 + 1];
                    for (n3 = n4 + 2; n3 < n6; ++n3) {
                        fArray[n3] = 0.0f;
                    }
                    Fourier.complexTransform(fArray, n4, 1);
                    for (n3 = 0; n3 <= n4; n3 += 2) {
                        fArray[n3] = (float)Math.exp(fArray[n3]);
                    }
                    Fourier.polar2Rect(fArray, 0, fArray, 0, n4 + 2);
                }
                if (fArrayArray2[1][0] == 1.0f) {
                    Fourier.realTransform(fArray, n4, -1);
                    Util.rotate(fArray, n4, fArrayArray2[2], point.x);
                    fArrayArray2[1][0] = 0.0f;
                }
                this.setProgression((float)(l += (long)n5) / (float)l2);
                if (!this.threadRunning) break block25;
                int n9 = point.x;
                for (n3 = 0; n3 < n5; ++n3) {
                    float f2 = Math.abs(fArray[n3]);
                    if (!(f2 > f)) continue;
                    f = f2;
                    if (!this.pr.bool[0]) continue;
                    n9 = n3;
                }
                if (this.pr.bool[0]) {
                    int n10;
                    n2 = n9 >> 1;
                    float[] fArray2 = Filter.createWindow(n2, 4);
                    int n11 = n2 - 1;
                    for (n10 = 0; n10 < fArray2.length; ++n10) {
                        int n12 = n11--;
                        fArray[n12] = fArray[n12] * fArray2[n10];
                    }
                    n11 = n5 - n2;
                    n10 = 0;
                    while (n11 < n5) {
                        int n13 = n11++;
                        fArray[n13] = fArray[n13] * fArray2[n10];
                        ++n10;
                    }
                }
                float f3 = this.pr.intg[5] == 1 ? (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value : (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f), (int)1), null).value;
                int n14 = 0;
                while (n14 < n5) {
                    int n15 = n14++;
                    fArray[n15] = fArray[n15] * f3;
                }
                f *= f3;
                ArrayList<Marker> arrayList = new ArrayList<Marker>(1);
                arrayList.add(new Marker((long)n9, MARK_SUPPORT));
                audioFileDescr.setProperty("markers", arrayList);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                for (n14 = 0; this.threadRunning && n14 < n5; n14 += n2) {
                    n2 = Math.min(8192, n5 - n14);
                    audioFile.writeFrames((float[][])fArrayArray, n14, n2);
                    this.setProgression((float)(l += (long)n2) / (float)l2);
                }
                if (this.threadRunning) {
                    audioFile.close();
                    audioFile = null;
                    if (!this.threadRunning) {
                        // empty if block
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                float[][] fArray = null;
                Object var14_15 = null;
                float[][] fArray3 = null;
                Object var8_7 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }

    @Override
    public void requestUpdate(boolean bl, boolean bl2) {
        float f;
        double d;
        double d2;
        int n;
        double d3;
        double d4;
        float[] fArray;
        int n2;
        int n3;
        int n4;
        int n5 = 1;
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        double d5 = 8.685889638065035;
        double d6 = 1.0;
        AudioFileDescr audioFileDescr = new AudioFileDescr();
        PathField pathField = (PathField)this.gui.getItemObj(1024);
        CircuitPanel circuitPanel = (CircuitPanel)this.gui.getItemObj(2048);
        if (pathField == null || circuitPanel == null) {
            return;
        }
        this.fillPropertyArray();
        pathField.fillStream(audioFileDescr);
        audioFileDescr.channels = 1;
        Point point = this.calcLength(circuitPanel, audioFileDescr);
        int n6 = point.x + point.y;
        if (n6 <= 0) {
            return;
        }
        for (n4 = 2; n4 < n6; n4 <<= 1) {
        }
        if (bl) {
            while (n4 < 8192) {
                n4 <<= 1;
                point = new Point(point.x * 2, point.y * 2);
            }
        } else {
            while (n4 < 4096) {
                n4 <<= 1;
                point = new Point(point.x * 2, point.y * 2);
            }
            n3 = 4096;
            while (n3 < n4) {
                n3 <<= 1;
                ++n5;
            }
        }
        float[] fArray2 = new float[n4 + 2];
        float[][] fArrayArray = new float[3][];
        fArrayArray[0] = fArray2;
        fArrayArray[1] = new float[1];
        fArrayArray[1][0] = 0.0f;
        fArrayArray[2] = new float[point.x];
        this.calcIR(circuitPanel, audioFileDescr, fArrayArray, point, n4);
        if (fArrayArray[1][0] != 1.0f) {
            Fourier.realTransform(fArray2, n4, 1);
        }
        if (bl) {
            n2 = 2049;
            fArray = new float[n2];
            d6 = 1000.0;
            d4 = 16.0;
            d3 = audioFileDescr.rate / 2.0;
            double d7 = d6 * d6 / d3;
            double d8 = Math.log(d3 / d7);
            double d9 = Math.log(d4 / d7) / d8;
            double d10 = (1.0 - d9) / (double)(n2 - 1);
            double d11 = d7 / audioFileDescr.rate * (double)n4;
            for (n = 0; n < n2; ++n) {
                double d12 = Math.exp(((double)n * d10 + d9) * d8);
                double d13 = d12 * d11;
                n3 = (int)d13 << 1;
                d12 = d13 % 1.0;
                d2 = fArray2[n3];
                d = fArray2[n3 + 1];
                d13 = Math.sqrt(d2 * d2 + d * d) * (1.0 - d12);
                if (n3 < n4) {
                    d2 = fArray2[n3 + 2];
                    d = fArray2[n3 + 3];
                    f = (float)(d13 + Math.sqrt(d2 * d2 + d * d) * d12);
                } else {
                    f = (float)d13;
                }
                fArray[n] = f;
                if (f > f2) {
                    f2 = f;
                }
                if (!(f < f3)) continue;
                f3 = f;
            }
        } else {
            n2 = (n4 >> n5) + 1;
            fArray = new float[n2];
            n3 = 0;
            n = 0;
            n5 = 1 << n5;
            while (n3 <= n4) {
                d2 = fArray2[n3];
                d = fArray2[n3 + 1];
                fArray[n] = f = (float)Math.sqrt(d2 * d2 + d * d);
                if (f > f2) {
                    f2 = f;
                }
                if (f < f3) {
                    f3 = f;
                }
                n3 += n5;
                ++n;
            }
            d4 = 0.0;
            d3 = audioFileDescr.rate / 2.0;
        }
        if (bl2) {
            for (n = 0; n < n2; ++n) {
                fArray[n] = (float)(d5 * Math.log(Math.max(1.0E-8, (double)fArray[n])));
            }
            f3 = (float)(d5 * Math.log(Math.max(1.0E-8, (double)f3)));
            f2 = (float)(d5 * Math.log(Math.max(1.0E-8, (double)f2)));
            f2 = (float)(Math.ceil((double)f2 / 6.0) * 6.0);
            f3 = (float)(Math.ceil((double)f3 / 6.0) * 6.0);
        } else {
            f2 = (float)(Math.ceil((double)f2 * 10.0) / 10.0);
            f3 = (float)(Math.floor((double)f3 * 10.0) / 10.0);
        }
        VectorSpace vectorSpace = bl ? VectorSpace.createLogLinSpace((double)d4, (double)d3, (double)d6, (double)f3, (double)f2, null, null, null, null) : VectorSpace.createLinSpace((double)d4, (double)d3, (double)f3, (double)f2, null, null, null, null);
        this.spectPane.setSpace(vectorSpace);
        this.spectPane.setVector(fArray);
    }

    @Override
    public String formatHText(double d, boolean bl) {
        return this.msgHertz.format(new Object[]{d});
    }

    @Override
    public String formatVText(double d, boolean bl) {
        if (bl) {
            return this.msgDecibel.format(new Object[]{d});
        }
        return this.msgPlain.format(new Object[]{d});
    }

    private Point calcLength(CircuitPanel circuitPanel, AudioFileDescr audioFileDescr) {
        Object e;
        Iterator iterator = circuitPanel.getElements();
        Point point = new Point(0, 0);
        if (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof CircuitPanel) {
                point = this.calcLength((CircuitPanel)e, audioFileDescr);
            } else if (e instanceof FilterBox) {
                point = ((FilterBox)e).calcLength(audioFileDescr, this.pr.intg[3]);
            } else assert (false) : e.getClass().getName();
        }
        while (iterator.hasNext()) {
            Point point2;
            e = iterator.next();
            if (e instanceof CircuitPanel) {
                point2 = this.calcLength((CircuitPanel)e, audioFileDescr);
            } else if (e instanceof FilterBox) {
                point2 = ((FilterBox)e).calcLength(audioFileDescr, this.pr.intg[3]);
            } else {
                assert (false) : e.getClass().getName();
                point2 = null;
            }
            if (circuitPanel.getType() == 2) {
                point.x = Math.max(point.x, point2.x);
                point.y = Math.max(point.y, point2.y);
                continue;
            }
            point.x += point2.x;
            point.y += Math.max(0, point2.y - 1);
        }
        return point;
    }

    private void calcIR(CircuitPanel circuitPanel, AudioFileDescr audioFileDescr, float[][] fArray, Point point, int n) {
        Object e;
        Iterator iterator = circuitPanel.getElements();
        Object object = null;
        if (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof CircuitPanel) {
                this.calcIR((CircuitPanel)e, audioFileDescr, fArray, point, n);
            } else if (e instanceof FilterBox) {
                ((FilterBox)e).calcIR(audioFileDescr, this.pr.intg[3], this.pr.intg[4], fArray[0], point);
            } else assert (false) : e.getClass().getName();
        }
        while (iterator.hasNext()) {
            int n2;
            e = iterator.next();
            if (object == null) {
                object = new float[3][];
                object[0] = new float[fArray[0].length];
                object[1] = new float[1];
                object[2] = fArray[2];
            }
            object[1][0] = 0.0f;
            if (e instanceof CircuitPanel) {
                this.calcIR((CircuitPanel)e, audioFileDescr, (float[][])object, point, n);
            } else if (e instanceof FilterBox) {
                ((FilterBox)e).calcIR(audioFileDescr, this.pr.intg[3], this.pr.intg[4], object[0], point);
            } else assert (false) : e.getClass().getName();
            float[] fArray2 = fArray[0];
            float[] fArray3 = object[0];
            if (fArray[1][0] == object[1][0]) {
                if (circuitPanel.getType() == 1 && fArray[1][0] == 0.0f) {
                    Util.rotate(fArray2, n, fArray[2], -point.x);
                    Fourier.realTransform(fArray2, n, 1);
                    Util.rotate(fArray3, n, fArray[2], -point.x);
                    Fourier.realTransform(fArray3, n, 1);
                    fArray[1][0] = 1.0f;
                    object[1][0] = 1.0f;
                }
            } else if (fArray[1][0] == 0.0f) {
                Util.rotate(fArray2, n, fArray[2], -point.x);
                Fourier.realTransform(fArray2, n, 1);
                fArray[1][0] = 1.0f;
            } else {
                Util.rotate(fArray3, n, fArray[2], -point.x);
                Fourier.realTransform(fArray3, n, 1);
                object[1][0] = 1.0f;
            }
            if (circuitPanel.getType() == 2) {
                for (n2 = n + 1; n2 >= 0; --n2) {
                    int n3 = n2;
                    fArray2[n3] = fArray2[n3] + fArray3[n2];
                }
                continue;
            }
            for (n2 = n + 1; n2 >= 0; --n2) {
                int n4 = n2;
                fArray2[n4] = fArray2[n4] * fArray3[n2];
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        FilterBox filterBox = this.currentFlt;
        boolean bl = filterBox != null;
        boolean bl2 = true;
        boolean bl3 = true;
        Component component = this.gui.getItemObj(2049);
        if (component != null) {
            component.setEnabled(bl);
        }
        if ((component = this.gui.getItemObj(2050)) != null) {
            component.setEnabled(bl);
        }
        if ((component = this.gui.getItemObj(2053)) != null) {
            component.setEnabled(bl);
        }
        if ((component = this.gui.getItemObj(2054)) != null) {
            component.setEnabled(bl);
        }
        if (bl) {
            switch (filterBox.filterType) {
                case 0: {
                    bl3 = false;
                }
                case 1: 
                case 2: {
                    bl2 = false;
                }
            }
        }
        if ((component = this.gui.getItemObj(2051)) != null) {
            component.setEnabled(bl && bl3);
        }
        if ((component = this.gui.getItemObj(2058)) != null) {
            component.setEnabled(bl && bl3);
        }
        if ((component = this.gui.getItemObj(2052)) != null) {
            component.setEnabled(bl && bl2);
        }
        if ((component = this.gui.getItemObj(2057)) != null) {
            component.setEnabled(bl && bl2);
            if (bl) {
                boolean bl4 = bl2 = bl2 && filterBox.overtones;
            }
        }
        if ((component = this.gui.getItemObj(2055)) != null) {
            component.setEnabled(bl && bl2);
        }
        if ((component = this.gui.getItemObj(2056)) != null) {
            component.setEnabled(bl && bl2);
        }
    }
}

