/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.CircuitPanel;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.io.AudioFileDescr;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.UIManager;

public class FilterBox
implements CircuitPanel.Box,
Icon {
    public static final int FLT_ALLPASS = 0;
    public static final int FLT_LOWPASS = 1;
    public static final int FLT_HIGHPASS = 2;
    public static final int FLT_BANDPASS = 3;
    public static final int FLT_BANDSTOP = 4;
    public static final int FLTNUM = 5;
    public int filterType = 0;
    public boolean sign = false;
    public Param cutOff;
    public Param rollOff;
    public Param bandwidth;
    public Param gain;
    public Param delay;
    public boolean overtones = false;
    public Param otLimit;
    public Param otSpacing;
    private static final Stroke strkLine = new BasicStroke(0.5f);
    private final boolean isDark = UIManager.getBoolean("dark-skin");
    private final Paint pntBack = this.isDark ? Color.darkGray : Color.lightGray;
    private static final Paint pntArea = new Color(66, 94, 157, 127);
    private final Paint pntLine = this.isDark ? Color.lightGray : Color.black;
    private static final int ICON_WIDTH = 32;
    private static final int ICON_HEIGHT = 32;
    private static final int[][] iconPolyX = new int[][]{{0, 31, 31, 0}, {0, 10, 20, 31, 0}, {0, 10, 20, 31, 31}, {0, 6, 12, 18, 24, 31}, {0, 6, 12, 18, 24, 31, 31, 0}};
    private static final int[][] iconPolyY = new int[][]{{8, 8, 31, 31}, {8, 8, 31, 31, 31}, {31, 31, 8, 8, 31}, {31, 31, 8, 8, 31, 31}, {8, 8, 31, 31, 8, 8, 31, 31}};
    private static final int[] iconLineNum = new int[]{2, 4, 4, 6, 6, 6, 6};

    public FilterBox() {
        this.cutOff = new Param(1000.0, 3);
        this.rollOff = new Param(0.0, 35);
        this.bandwidth = new Param(250.0, 35);
        this.gain = new Param(0.0, 785);
        this.delay = new Param(0.0, 2);
        this.otLimit = new Param(5000.0, 3);
        this.otSpacing = new Param(1000.0, 35);
    }

    public FilterBox(FilterBox filterBox) {
        this.cutOff = (Param)filterBox.cutOff.clone();
        this.rollOff = (Param)filterBox.rollOff.clone();
        this.bandwidth = (Param)filterBox.bandwidth.clone();
        this.gain = (Param)filterBox.gain.clone();
        this.delay = (Param)filterBox.delay.clone();
        this.otLimit = (Param)filterBox.otLimit.clone();
        this.otSpacing = (Param)filterBox.otSpacing.clone();
        this.filterType = filterBox.filterType;
        this.sign = filterBox.sign;
        this.overtones = filterBox.overtones;
    }

    public Point calcLength(AudioFileDescr audioFileDescr, int n) {
        double d = audioFileDescr.rate;
        int n2 = 3;
        int n3 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.delay, (int)2, null, null).value) + 0.5);
        double[][] dArray = this.calcFrequencies(d);
        double[] dArray2 = dArray[0];
        double d2 = d / 2.0;
        if (dArray2.length == 0) {
            Point point = new Point(0, 1 + n3);
            return point;
        }
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(dArray2[i] < d2) || !(dArray2[i] > 0.0)) continue;
            d2 = dArray2[i];
        }
        double d3 = d / d2;
        switch (n) {
            case 1: {
                n2 = 6;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 24;
            }
        }
        int n4 = (int)((double)n2 * d3 + 0.5);
        Point point = new Point(n4, Math.max(0, n4 - 1 + n3));
        return point;
    }

    public void calcIR(AudioFileDescr audioFileDescr, int n, int n2, float[] fArray, Point point) {
        int n3;
        double d = audioFileDescr.rate;
        double d2 = Math.PI * 2 / d;
        int n4 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.delay, (int)2, null, null).value) + 0.5);
        int n5 = point.x + n4;
        Param param = new Param(1.0, 1);
        double[][] dArray = this.calcFrequencies(d);
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        int n6 = 3;
        double d3 = 1.0;
        double d4 = d / 2.0;
        double d5 = Param.transform((Param)this.gain, (int)1, (Param)param, null).value * (double)(this.sign ? -1 : 1);
        for (n3 = 0; n3 < fArray.length; ++n3) {
            fArray[n3] = 0.0f;
        }
        if (this.filterType == 0) {
            fArray[n5] = (float)d5;
        } else {
            switch (n) {
                case 1: {
                    n6 = 6;
                    break;
                }
                case 2: {
                    n6 = 12;
                    break;
                }
                case 3: {
                    n6 = 24;
                }
            }
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                if (!(dArray2[n3] < d4) || !(dArray2[n3] > 0.0)) continue;
                d4 = dArray2[n3];
            }
            int n7 = Math.max(1, (int)((double)n6 * d / d4 + 0.5));
            if (this.filterType == 3) {
                d3 = -1.0;
            }
            double d6 = 0.0;
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                if (!(dArray2[n3] <= 0.0)) {
                    double d7 = d2 * dArray2[n3];
                    d6 += d3 * dArray2[n3];
                    double d8 = d2 * dArray3[n3];
                    for (int i = 1; i < n7; ++i) {
                        double d9 = d3 * (Math.sin(d7 * (double)i) / (double)i);
                        double d10 = d8 * (double)i;
                        double d11 = 0.4052847345693511 * d10 * d10;
                        int n8 = n5 + i;
                        fArray[n8] = fArray[n8] + (float)(d9 *= Math.cos(d10) / (1.0 - d11));
                        int n9 = n5 - i;
                        fArray[n9] = fArray[n9] + (float)d9;
                    }
                    int n10 = n5;
                    fArray[n10] = fArray[n10] + (float)(d3 * d7);
                }
                d3 = -d3;
            }
            d6 /= d;
            float[] fArray2 = Filter.createWindow(n7, n2);
            double d12 = 0.0;
            for (n3 = 0; n3 < n7; ++n3) {
                int n11 = n5 + n3;
                fArray[n11] = fArray[n11] * fArray2[n3];
                int n12 = n5 - n3;
                fArray[n12] = fArray[n12] * fArray2[n3];
                d12 += (double)fArray[n5 + n3] * (double)fArray[n5 + n3];
            }
            fArray2 = null;
            d5 *= Math.sqrt(d6 / (d12 -= (double)fArray[n5] * (double)fArray[n5] / 2.0));
            for (n3 = 1; n3 < n7; ++n3) {
                int n13 = n5 + n3;
                fArray[n13] = fArray[n13] * (float)d5;
                int n14 = n5 - n3;
                fArray[n14] = fArray[n14] * (float)d5;
            }
            int n15 = n5;
            fArray[n15] = fArray[n15] * (float)d5;
        }
    }

    private double[][] calcFrequencies(double d) {
        double[] dArray;
        double[] dArray2;
        switch (this.filterType) {
            case 1: 
            case 2: {
                int n = this.filterType == 1 ? 1 : 2;
                dArray2 = new double[n];
                dArray = new double[n];
                if (n == 2) {
                    dArray2[0] = d / 2.0;
                    dArray[0] = 0.0;
                }
                Param param = this.cutOff;
                Param param2 = new Param(-Math.abs(this.rollOff.value / 2.0), this.rollOff.unit);
                Param param3 = new Param(Math.abs(this.rollOff.value / 2.0), this.rollOff.unit);
                Param param4 = Param.transform(param2, 3, param, null);
                Param param5 = Param.transform(param3, 3, param, null);
                dArray2[n - 1] = this.cutOff.value;
                dArray[n - 1] = Math.max(param4.value, param5.value) - Math.min(param4.value, param5.value);
                break;
            }
            case 3: 
            case 4: {
                Param param = this.cutOff;
                Param param6 = new Param(-Math.abs(this.bandwidth.value / 2.0), this.bandwidth.unit);
                Param param7 = new Param(Math.abs(this.bandwidth.value / 2.0), this.bandwidth.unit);
                double d2 = Param.transform((Param)this.otLimit, (int)3, (Param)this.cutOff, null).value;
                ArrayList<Param> arrayList = new ArrayList<Param>();
                boolean bl = this.otSpacing.value < 0.0;
                boolean bl2 = this.overtones && this.otSpacing.value != 0.0;
                do {
                    Param param8 = Param.transform(param6, 3, param, null);
                    Param param9 = Param.transform(param7, 3, param, null);
                    arrayList.add(param8);
                    arrayList.add(param9);
                    param = Param.transform(this.otSpacing, 3, param, null);
                } while (bl2 && (bl && param.value > d2 || !bl && param.value < d2));
                if (this.filterType == 4) {
                    arrayList.add(new Param(d / 2.0, 3));
                }
                dArray2 = new double[arrayList.size()];
                dArray = new double[arrayList.size()];
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = ((Param)arrayList.get((int)i)).value;
                    dArray[i] = 0.0;
                }
                break;
            }
            case 0: {
                dArray2 = new double[]{};
                dArray = new double[1];
                break;
            }
            default: {
                assert (false) : this.filterType;
                return null;
            }
        }
        double[][] dArrayArray = new double[][]{dArray2, dArray};
        return dArrayArray;
    }

    @Override
    public Icon getIcon() {
        return this;
    }

    @Override
    public CircuitPanel.Box duplicate() {
        return new FilterBox(this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.filterType) + ';' + this.sign + ';' + this.cutOff.toString() + ';' + this.bandwidth.toString() + ';' + this.gain.toString() + ';' + this.delay.toString() + ';' + this.overtones + ';' + this.otLimit.toString() + ';' + this.otSpacing.toString() + ";" + this.rollOff.toString();
    }

    @Override
    public CircuitPanel.Box fromString(String string) {
        FilterBox filterBox = new FilterBox();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        filterBox.filterType = Integer.parseInt(stringTokenizer.nextToken());
        filterBox.sign = Boolean.valueOf(stringTokenizer.nextToken());
        filterBox.cutOff = Param.valueOf(stringTokenizer.nextToken());
        filterBox.bandwidth = Param.valueOf(stringTokenizer.nextToken());
        filterBox.gain = Param.valueOf(stringTokenizer.nextToken());
        filterBox.delay = Param.valueOf(stringTokenizer.nextToken());
        filterBox.overtones = Boolean.valueOf(stringTokenizer.nextToken());
        filterBox.otLimit = Param.valueOf(stringTokenizer.nextToken());
        filterBox.otSpacing = Param.valueOf(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            filterBox.rollOff = Param.valueOf(stringTokenizer.nextToken());
        }
        return filterBox;
    }

    @Override
    public int getIconWidth() {
        return 32;
    }

    @Override
    public int getIconHeight() {
        return 32;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(strkLine);
        graphics2D.setPaint(this.pntBack);
        graphics2D.translate(n, n2);
        graphics2D.fillRect(0, 0, 32, 32);
        graphics2D.setPaint(pntArea);
        graphics2D.fillPolygon(iconPolyX[this.filterType], iconPolyY[this.filterType], iconPolyX[this.filterType].length);
        graphics2D.setPaint(this.pntLine);
        graphics2D.drawPolyline(iconPolyX[this.filterType], iconPolyY[this.filterType], iconLineNum[this.filterType]);
        if (this.sign) {
            graphics2D.drawArc(0, 0, 6, 6, 0, 360);
            graphics2D.drawLine(0, 6, 6, 0);
        }
        graphics2D.translate(8, 0);
        if (this.gain.value < 0.0) {
            graphics2D.drawLine(6, 0, 0, 3);
            graphics2D.drawLine(0, 3, 6, 6);
        } else if (this.gain.value > 0.0) {
            graphics2D.drawLine(0, 0, 6, 3);
            graphics2D.drawLine(6, 3, 0, 6);
        }
        graphics2D.translate(8, 0);
        if (this.delay.value != 0.0) {
            graphics2D.drawLine(1, 0, 5, 0);
            graphics2D.drawLine(3, 0, 3, 6);
        }
        graphics2D.translate(8, 0);
        if (this.overtones) {
            graphics2D.drawLine(0, 0, 0, 6);
            graphics2D.drawLine(2, 1, 2, 6);
            graphics2D.drawLine(4, 2, 4, 6);
            graphics2D.drawLine(6, 3, 6, 6);
        }
        graphics2D.setTransform(affineTransform);
    }
}

