/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.io.ImageFile;
import de.sciss.fscape.io.ImageStream;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.JLabel;

public class Graph2SndDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_OUTPUTRATE = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputRes";
    private static final String PRN_OUTPUTRATE = "OutputRate";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputRes", "OutputRate"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_OUTPUTRATE = 258;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public Graph2SndDlg() {
        super("Graph->Sound Conversion");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            Graph2SndDlg.static_pr.text = prText;
            Graph2SndDlg.static_pr.textName = prTextName;
            Graph2SndDlg.static_pr.intg = prIntg;
            Graph2SndDlg.static_pr.intgName = prIntgName;
            this.fillDefaultAudioDescr(Graph2SndDlg.static_pr.intg, 0, 1, 2);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("File I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_IMAGE);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input image", 4));
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(113, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output sound", 4));
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        this.gui.registerGadget(pathField2.getRateGadget(), 258);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        ImageFile imageFile;
        block14: {
            imageFile = null;
            audioFile = null;
            ImageStream imageStream = null;
            AudioFileDescr audioFileDescr = null;
            int n = 8;
            byte[] byArray = null;
            try {
                imageFile = new ImageFile(this.pr.text[0], 0);
                imageStream = imageFile.initReader();
                int n2 = imageStream.width;
                int n3 = imageStream.height;
                n = imageStream.bitsPerSmp;
                int n4 = imageStream.smpPerPixel;
                int n5 = n2 * n3;
                byArray = imageFile.allocRow();
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                int n6 = 1;
                audioFileDescr = new AudioFileDescr();
                pathField.fillStream(audioFileDescr);
                audioFileDescr.channels = n6;
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block14;
                long l = 0L;
                long l2 = (long)n5 + (long)n3;
                int n7 = 0;
                float[][] fArray = new float[n6][n3];
                for (int i = 0; this.threadRunning && i < n3; ++i) {
                    imageFile.readRow(byArray);
                    for (int j = 0; j < 1; ++j) {
                        float f;
                        int n8;
                        int n9;
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        if (n == 8) {
                            n9 = 0;
                            n8 = j;
                            while (n9 < n2) {
                                f = 1.0f - (float)(byArray[n8] & 0xFF) / 255.0f;
                                f2 += f * ((float)n9 / (float)(n2 - 1));
                                f3 += f;
                                ++n9;
                                n8 += n4;
                            }
                        } else {
                            n9 = 0;
                            n8 = j;
                            while (n9 < n2) {
                                int n10 = n8 << 1;
                                f = 1.0f - (float)((byArray[n10++] & 0xFF) << 8 | byArray[n10] & 0xFF) / 65535.0f;
                                f2 += f * ((float)n9 / (float)(n2 - 1));
                                f3 += f;
                                ++n9;
                                n8 += n4;
                            }
                        }
                        fArray[j][i] = f3 > 0.0f ? f2 / f3 : 0.0f;
                    }
                    this.setProgression((float)(l += (long)n2) / (float)l2);
                }
                if (this.threadRunning) {
                    audioFile.writeFrames(fArray, 0, n3);
                    n7 += n3;
                    this.setProgression((float)(l += (long)n3) / (float)l2);
                    if (this.threadRunning) {
                        imageFile.close();
                        imageFile = null;
                        audioFile.close();
                        audioFile = null;
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                float[][] fArray = null;
                byArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (imageFile != null) {
            imageFile.cleanUp();
            imageFile = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
    }
}

