/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class MenuStrip
extends JMenu {
    protected Hashtable<String, JMenuItem> h;
    protected String label;
    protected ActionListener listener;

    public MenuStrip(String string, String[][] stringArray, ActionListener actionListener) {
        super(string);
        this.label = string;
        this.listener = actionListener;
        this.h = new Hashtable();
        this.h.put(string, this);
        MenuStrip.createStrip(this, this.h, stringArray, actionListener);
    }

    public boolean setItemEnabled(String string, boolean bl) {
        JMenuItem jMenuItem = this.h.get(string);
        if (jMenuItem != null) {
            jMenuItem.setEnabled(bl);
        }
        return jMenuItem != null;
    }

    public static boolean setItemEnabled(JMenuBar jMenuBar, String string, boolean bl) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            MenuStrip menuStrip = (MenuStrip)jMenuBar.getMenu(i);
            JMenuItem jMenuItem = menuStrip.getItem(string);
            if (jMenuItem == null) continue;
            jMenuItem.setEnabled(bl);
            return true;
        }
        return false;
    }

    public boolean setItemJLabel(String string, String string2) {
        JMenuItem jMenuItem = this.h.get(string);
        if (jMenuItem != null) {
            this.h.remove(string);
            MenuStrip.setItemLabelAndCut(jMenuItem, string2);
            this.h.put(string, jMenuItem);
        }
        return jMenuItem != null;
    }

    public static boolean setItemJLabel(JMenuBar jMenuBar, String string, String string2) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            MenuStrip menuStrip = (MenuStrip)jMenuBar.getMenu(i);
            JMenuItem jMenuItem = menuStrip.getItem(string);
            if (jMenuItem == null) continue;
            return menuStrip.setItemJLabel(string, string2);
        }
        return false;
    }

    public JMenuItem getItem(String string) {
        return this.h.get(string);
    }

    public static JMenuItem getItem(JMenuBar jMenuBar, String string) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            MenuStrip menuStrip = (MenuStrip)jMenuBar.getMenu(i);
            JMenuItem jMenuItem = menuStrip.getItem(string);
            if (jMenuItem == null) continue;
            return jMenuItem;
        }
        return null;
    }

    public static void createStrip(JMenu jMenu, Hashtable<String, JMenuItem> hashtable, String[][] stringArray, ActionListener actionListener) {
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = stringArray[i].length > 1;
            JMenu jMenu2 = jMenu;
            for (int j = 0; j < stringArray[i].length; ++j) {
                JMenuItem jMenuItem;
                String string = stringArray[i][j];
                if (string == null) {
                    jMenu2.addSeparator();
                    continue;
                }
                if (j == 0 && bl) {
                    jMenu2 = new JMenu();
                    jMenuItem = jMenu2;
                    jMenu.add(jMenuItem);
                } else {
                    jMenuItem = string.endsWith("#") ? new JCheckBoxMenuItem() : new JMenuItem();
                    jMenu2.add(jMenuItem);
                }
                MenuStrip.setItemLabelAndCut(jMenuItem, string);
                jMenuItem.addActionListener(actionListener);
                hashtable.put(string, jMenuItem);
            }
        }
    }

    public static void setItemLabelAndCut(JMenuItem jMenuItem, String string) {
        jMenuItem.setActionCommand(string);
        if (string.endsWith("#")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("&")) {
            string = string.substring(2);
        }
        jMenuItem.setText(string);
    }
}

