/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.Application;
import de.sciss.fscape.gui.DragContext;
import de.sciss.fscape.gui.EditOpDlg;
import de.sciss.fscape.gui.OpConnector;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.OpIconLabel;
import de.sciss.fscape.gui.PopupStrip;
import de.sciss.fscape.gui.SpectPatchDlg;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.gui.GUIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.SyncFailedException;
import java.rmi.NotBoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OpPanel
extends JPanel
implements ClipboardOwner,
ActionListener,
MouseListener,
MouseMotionListener {
    public static final String OBJ_NAME = "OpPanel";
    private SpectPatchDlg win;
    private DragContext dragContext = null;
    protected int preferredWidth = 250;
    protected int preferredHeight = 150;
    private PopupStrip popPanel;
    private PopupStrip popIcon;
    private PopupStrip popCon;
    private PopupStrip popNew;
    private Component popSource;
    private int popX;
    private int popY;
    private static final String MI_NEW = "New";
    private static final String MI_PASTE = "Paste";
    private static final String MI_EDIT = "Edit...";
    private static final String MI_RENAME = "Rename...";
    private static final String MI_MAKEALIAS = "Make alias";
    private static final String MI_CUT = "Cut";
    private static final String MI_COPY = "Copy";
    private static final String MI_DUPL = "Duplicate";
    private static final String MI_REMOVE = "Remove";
    private static final String MI_ORIGIN = "Origin";
    private static final String MI_TARGET = "Target";
    private static final String MI_HIDE = "Hide";
    private static final String[][] mPanel = new String[][]{null, {null}, {"Paste"}};
    private static final String[][] mIcon = new String[][]{{"Edit..."}, {"Rename..."}, {"Make alias"}, {null}, {"Cut"}, {"Copy"}, {"Duplicate"}, {"Remove"}};
    private static final String[][] mCon = new String[][]{null, null, {null}, {"Hide"}};
    private static String[][] mNew;
    private Vector vIcon;
    private Hashtable hCon;
    protected String[] optionsAliasDel = new String[]{"Cancel", "Remove", "Transform"};
    protected String[] optionsAliasEdit = new String[]{"Cancel", "Original", "Transform"};

    public OpPanel(SpectPatchDlg spectPatchDlg) {
        this.vIcon = new Vector();
        this.hCon = new Hashtable();
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.win = spectPatchDlg;
        Map map = Operator.getOperators();
        Iterator iterator = map.keySet().iterator();
        OpPanel.mPanel[0] = new String[1 + map.size()];
        mNew = new String[map.size()][1];
        OpPanel.mPanel[0][0] = MI_NEW;
        int n = 1;
        while (iterator.hasNext()) {
            OpPanel.mPanel[0][n] = (String)iterator.next();
            OpPanel.mNew[n - 1][0] = mPanel[0][n];
            ++n;
        }
        this.popPanel = new PopupStrip(mPanel, this);
        this.popIcon = new PopupStrip(mIcon, this);
        this.popNew = new PopupStrip(mNew, this);
        this.setOpaque(false);
    }

    @Override
    public String toString() {
        return OBJ_NAME;
    }

    public void clear() {
        this.vIcon = new Vector();
        this.hCon = new Hashtable();
        this.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operator addOperator(Operator operator, int n, int n2) {
        OpIcon opIcon = (OpIcon)operator.getIcon();
        Vector vector = this.vIcon;
        synchronized (vector) {
            this.vIcon.addElement(opIcon);
        }
        opIcon.addMouseListener(this);
        opIcon.getLabel().addMouseListener(this);
        opIcon.addMouseMotionListener(this);
        opIcon.setLocation(n, n2);
        opIcon.addTo(this);
        this.validateSize(opIcon);
        this.win.getDoc().addOperator(operator);
        return operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOperator(Operator operator) {
        OpIcon opIcon = (OpIcon)operator.getIcon();
        Enumeration<SpectStreamSlot> enumeration = operator.getSlots(2).elements();
        Cloneable cloneable = this.vIcon;
        synchronized (cloneable) {
            this.vIcon.removeElement(opIcon);
        }
        while (enumeration.hasMoreElements()) {
            SpectStreamSlot spectStreamSlot = enumeration.nextElement();
            SpectStreamSlot spectStreamSlot2 = spectStreamSlot.getLinked();
            OpConnector opConnector = this.getConnector(spectStreamSlot);
            cloneable = this.hCon;
            synchronized (cloneable) {
                this.hCon.remove(spectStreamSlot);
                this.hCon.remove(spectStreamSlot2);
            }
            opConnector.drawArrow(false);
            this.remove(opConnector);
            try {
                spectStreamSlot.divorce();
            }
            catch (NotBoundException notBoundException) {}
        }
        opIcon.removeFrom(this);
        this.win.getDoc().removeOperator(operator);
    }

    public void renameOperator(Operator operator, String string) {
        OpIcon opIcon = (OpIcon)operator.getIcon();
        opIcon.setName(string);
    }

    public void moveOperator(Operator operator, int n, int n2) {
        OpIcon opIcon = (OpIcon)operator.getIcon();
        Enumeration<SpectStreamSlot> enumeration = operator.getSlots(2).elements();
        opIcon.setLocation(n, n2);
        while (enumeration.hasMoreElements()) {
            SpectStreamSlot spectStreamSlot = enumeration.nextElement();
            OpConnector opConnector = this.getConnector(spectStreamSlot);
            opConnector.drawArrow(false);
            opConnector.adjustLocation();
            this.validateSize(opConnector);
        }
        this.validateSize(opIcon);
    }

    public void moveConnector(OpConnector opConnector, int n, int n2) {
        opConnector.drawArrow(false);
        opConnector.setLocation(n, n2);
        opConnector.drawArrow(true);
        this.validateSize(opConnector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpConnector getConnector(SpectStreamSlot spectStreamSlot) {
        OpConnector opConnector;
        Hashtable hashtable = this.hCon;
        synchronized (hashtable) {
            opConnector = (OpConnector)this.hCon.get(spectStreamSlot);
            if (opConnector == null) {
                opConnector = (OpConnector)this.hCon.get(spectStreamSlot.getLinked());
            }
        }
        return opConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkOperators(SpectStreamSlot spectStreamSlot, SpectStreamSlot spectStreamSlot2) throws NoSuchElementException, SyncFailedException, SlotAlreadyConnectedException {
        if ((spectStreamSlot.getFlags() & 0xF0) != 32) {
            SpectStreamSlot spectStreamSlot3 = spectStreamSlot;
            spectStreamSlot = spectStreamSlot2;
            spectStreamSlot2 = spectStreamSlot3;
        }
        spectStreamSlot.linkTo(spectStreamSlot2);
        OpConnector opConnector = new OpConnector(spectStreamSlot);
        opConnector.addMouseListener(this);
        opConnector.addMouseMotionListener(this);
        Hashtable hashtable = this.hCon;
        synchronized (hashtable) {
            this.hCon.put(spectStreamSlot, opConnector);
        }
        this.add(opConnector);
        this.validateSize(opConnector);
        opConnector.drawArrow(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void divorceOperators(SpectStreamSlot spectStreamSlot) throws NotBoundException {
        SpectStreamSlot spectStreamSlot2 = spectStreamSlot.getLinked();
        spectStreamSlot.divorce();
        OpConnector opConnector = this.getConnector(spectStreamSlot);
        Hashtable hashtable = this.hCon;
        synchronized (hashtable) {
            this.hCon.remove(spectStreamSlot);
            this.hCon.remove(spectStreamSlot2);
        }
        opConnector.drawArrow(false);
        this.remove(opConnector);
    }

    public void updateOperator(Operator operator) {
    }

    public OpIcon getOpIconAt(int n, int n2) {
        Component component = this.getComponentAt(n, n2);
        if (component != null && component != this) {
            if (component.toString().equals("OpIcon")) {
                return (OpIcon)component;
            }
            if (component.toString().equals("OpIconLabel")) {
                return ((OpIconLabel)component).getOpIcon();
            }
        }
        return null;
    }

    public OpIcon getOpIconAround(int n, int n2, OpIcon opIcon, int n3, int n4) {
        OpIconLabel opIconLabel = opIcon.getLabel();
        Rectangle rectangle = opIcon.getBounds();
        Rectangle rectangle2 = opIconLabel.getBounds();
        Rectangle rectangle3 = opIcon.getUnionBounds();
        int n5 = n - (rectangle.x + (rectangle.width >> 1));
        int n6 = n2 - (rectangle.y + (rectangle.height >> 1));
        rectangle.translate(n5 - n3, n6 - n4);
        rectangle2.translate(n5 - n3, n6 - n4);
        rectangle3.translate(n5 - n3, n6 - n4);
        rectangle.width += n3 << 1;
        rectangle2.width += n3 << 1;
        rectangle3.width += n3 << 1;
        rectangle.height += n4 << 1;
        rectangle2.height += n4 << 1;
        rectangle3.height += n4 << 1;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component == opIcon || component == opIconLabel) continue;
            Rectangle rectangle4 = component.getBounds();
            if (rectangle4.x >= rectangle3.x + rectangle3.width || rectangle4.y >= rectangle3.y + rectangle3.height || rectangle4.x <= rectangle3.x - rectangle4.width || rectangle4.y <= rectangle3.y - rectangle4.height || (rectangle4.x >= rectangle.x + rectangle.width || rectangle4.y >= rectangle.y + rectangle.height || rectangle4.x <= rectangle.x - rectangle4.width || rectangle4.y <= rectangle.y - rectangle4.height) && (rectangle4.x >= rectangle2.x + rectangle2.width || rectangle4.y >= rectangle2.y + rectangle2.height || rectangle4.x <= rectangle2.x - rectangle4.width || rectangle4.y <= rectangle2.y - rectangle4.height)) continue;
            if (component.toString().equals("OpIcon")) {
                return (OpIcon)component;
            }
            if (!component.toString().equals("OpIconLabel")) continue;
            return ((OpIconLabel)component).getOpIcon();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Hashtable hashtable = this.hCon;
        synchronized (hashtable) {
            Enumeration enumeration = this.hCon.elements();
            while (enumeration.hasMoreElements()) {
                OpConnector opConnector = (OpConnector)enumeration.nextElement();
                opConnector.drawArrowCorrect(graphics2D);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        try {
            Operator operator = (Operator)transferable.getTransferData(Operator.flavor);
            operator.dispose();
        }
        catch (Exception exception) {
            GUIUtil.displayError((Component)this.win.getComponent(), (Exception)exception, (String)"lostOwnership");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        OpIcon opIcon;
        String string = actionEvent.getActionCommand();
        Operator operator = null;
        if (!this.isEnabled()) {
            return;
        }
        if (string.equals(MI_EDIT)) {
            this.mouseClicked(new MouseEvent(this.popSource, 500, 0L, 16, 0, 0, 2, false));
        } else if (string.equals(MI_RENAME)) {
            String string2 = JOptionPane.showInputDialog(this.win.getComponent(), "Rename Operator", this.popSource.getName());
            if (string2 != null) {
                this.renameOperator(((OpIcon)this.popSource).getOperator(), string2);
            }
        } else if (string.equals(MI_CUT)) {
            Operator operator2 = (Operator)((OpIcon)this.popSource).getOperator().clone();
            if (operator2 != null) {
                Application.clipboard.setContents(operator2, this);
                this.removeOperator(((OpIcon)this.popSource).getOperator());
            }
        } else if (string.equals(MI_COPY)) {
            Operator operator3 = (Operator)((OpIcon)this.popSource).getOperator().clone();
            if (operator3 != null) {
                Application.clipboard.setContents(operator3, this);
            }
        } else if (string.equals(MI_DUPL)) {
            operator = (Operator)((OpIcon)this.popSource).getOperator().clone();
            if (operator != null) {
                opIcon = (OpIcon)operator.getIcon();
                String string3 = opIcon.getName();
                int n = string3.lastIndexOf(" copy");
                if (n >= 0) {
                    try {
                        int n2 = n + 5 == string3.length() ? 2 : Integer.parseInt(string3.substring(n + 6)) + 1;
                        opIcon.setName(string3.substring(0, n + 5) + ' ' + n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        opIcon.setName(string3 + " copy");
                    }
                } else {
                    opIcon.setName(string3 + " copy");
                }
            }
        } else if (string.equals(MI_MAKEALIAS)) {
            Operator operator4 = ((OpIcon)this.popSource).getOperator();
            operator = (Operator)operator4.clone();
            if (operator != null) {
                try {
                    operator.turnIntoAlias(operator4);
                    opIcon = (OpIcon)operator.getIcon();
                    opIcon.setName(opIcon.getName() + " alias");
                }
                catch (SyncFailedException syncFailedException) {
                    operator.dispose();
                    operator = null;
                }
                catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {}
            }
        } else if (string.equals(MI_REMOVE)) {
            Operator operator5 = ((OpIcon)this.popSource).getOperator();
            Enumeration enumeration = operator5.getAliases();
            if (enumeration.hasMoreElements()) {
                int n = JOptionPane.showOptionDialog(this.win.getComponent(), "You have made aliases from this Operator.\nDo you want to remove them or shall they\nbe transformed to genuine objects?", "Request", 0, 3, null, this.optionsAliasDel, this.optionsAliasDel[2]);
                switch (n) {
                    case 2: {
                        while (enumeration.hasMoreElements()) {
                            Operator operator6 = (Operator)enumeration.nextElement();
                            operator6.turnIntoGenuine();
                            opIcon = (OpIcon)operator6.getIcon();
                            String string4 = opIcon.getName();
                            if (string4.endsWith(" alias")) {
                                opIcon.setName(string4.substring(0, string4.length() - 6));
                            }
                            enumeration = operator5.getAliases();
                        }
                        break;
                    }
                    case 1: {
                        while (enumeration.hasMoreElements()) {
                            Operator operator7 = (Operator)enumeration.nextElement();
                            this.removeOperator(operator7);
                            enumeration = operator5.getAliases();
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.removeOperator(operator5);
        } else if (string.equals(MI_PASTE)) {
            Transferable transferable = Application.clipboard.getContents(this);
            if (transferable != null) {
                try {
                    operator = (Operator)transferable.getTransferData(Operator.flavor);
                    operator = (Operator)operator.clone();
                }
                catch (Exception exception) {
                    GUIUtil.displayError((Component)this.win.getComponent(), (Exception)exception, (String)string);
                }
            }
        } else if (string.equals(MI_HIDE)) {
            this.popSource.dispatchEvent(new MouseEvent(this.popSource, 500, System.currentTimeMillis(), 8, 0, 0, 1, false));
        } else if (this.popSource.toString().equals(OBJ_NAME)) {
            Map map = Operator.getOperators();
            String string5 = (String)map.get(string);
            if (string5 != null) {
                try {
                    operator = (Operator)Class.forName("de.sciss.fscape.op." + string5).newInstance();
                }
                catch (Exception exception) {
                    GUIUtil.displayError((Component)this.win.getComponent(), (Exception)exception, (String)string);
                }
            }
        } else if (this.popSource.toString().equals("OpConnector")) {
            Rectangle rectangle = this.popSource.getBounds();
            try {
                SpectStreamSlot spectStreamSlot = ((OpConnector)this.popSource).getOrigin();
                SpectStreamSlot spectStreamSlot2 = spectStreamSlot.getLinked();
                this.divorceOperators(spectStreamSlot);
                SpectStreamSlot spectStreamSlot3 = spectStreamSlot.getOwner().getSlot(string);
                OpConnector opConnector = null;
                if (spectStreamSlot3 != null) {
                    this.linkOperators(spectStreamSlot3, spectStreamSlot2);
                } else {
                    spectStreamSlot3 = spectStreamSlot2.getOwner().getSlot(string);
                    if (spectStreamSlot3 != null) {
                        this.linkOperators(spectStreamSlot, spectStreamSlot3);
                    }
                }
                if (spectStreamSlot3 != null && (opConnector = this.getConnector(spectStreamSlot3)) != null) {
                    Dimension dimension = opConnector.getSize();
                    this.moveConnector(opConnector, rectangle.x + (rectangle.width - dimension.width >> 1), rectangle.y + (rectangle.height - dimension.height >> 1));
                }
            }
            catch (NotBoundException notBoundException) {
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
            }
            catch (SyncFailedException syncFailedException) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (operator != null) {
            opIcon = (OpIcon)operator.getIcon();
            Point point = this.findFreePlaceAround(this.popX, this.popY, opIcon);
            this.addOperator(operator, point.x - 22, point.y - 22);
            opIcon.requestFocus();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isEnabled() || !mouseEvent.isPopupTrigger()) {
            return;
        }
        String string = mouseEvent.getSource().toString();
        if (string.equals(OBJ_NAME)) {
            this.panelContextMenu(mouseEvent);
        } else if (string.equals("OpIcon")) {
            this.iconContextMenu(mouseEvent);
        } else if (string.equals("OpConnector")) {
            this.connectorContextMenu(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        String string = mouseEvent.getSource().toString();
        if (string.equals(OBJ_NAME)) {
            this.panelPressed(mouseEvent);
        } else if (string.equals("OpIcon")) {
            this.iconPressed(mouseEvent);
        } else if (string.equals("OpConnector")) {
            this.connectorPressed(mouseEvent);
        } else if (string.equals("OpIconLabel")) {
            this.labelPressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        String string = mouseEvent.getSource().toString();
        if (string.equals(OBJ_NAME)) {
            this.panelReleased(mouseEvent);
        } else if (string.equals("OpIcon")) {
            this.iconReleased(mouseEvent);
        } else if (string.equals("OpConnector")) {
            this.connectorReleased(mouseEvent);
        } else if (string.equals("OpIconLabel")) {
            this.labelReleased(mouseEvent);
        }
        if (this.dragContext != null) {
            this.dragContext.mouseReleased(mouseEvent);
            this.dragContext = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled() || this.dragContext == null) {
            return;
        }
        this.dragContext.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void panelPressed(MouseEvent mouseEvent) {
        if (mouseEvent.isAltDown()) {
            SpectStreamSlot spectStreamSlot = this.getLinkAround(mouseEvent.getX(), mouseEvent.getY(), true);
            if (spectStreamSlot != null) {
                try {
                    this.divorceOperators(spectStreamSlot);
                    this.mouseDragged(mouseEvent);
                }
                catch (NotBoundException notBoundException) {
                    GUIUtil.displayError((Component)this.win.getComponent(), (Exception)notBoundException, (String)"panelPressed");
                }
            }
        } else {
            this.requestFocus();
            if (mouseEvent.isPopupTrigger()) {
                this.panelContextMenu(mouseEvent);
            }
        }
    }

    private void panelContextMenu(MouseEvent mouseEvent) {
        this.popSource = this;
        this.popX = mouseEvent.getX();
        this.popY = mouseEvent.getY();
        this.add(this.popPanel);
        this.popPanel.show(this, mouseEvent.getX(), mouseEvent.getY());
        this.remove(this.popPanel);
    }

    public void panelReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isAltDown()) {
            SpectStreamSlot spectStreamSlot = this.getLinkAround(mouseEvent.getX(), mouseEvent.getY(), true);
            if (spectStreamSlot == null) {
                this.popSource = this;
                this.popX = mouseEvent.getX();
                this.popY = mouseEvent.getY();
                this.add(this.popNew);
                this.popNew.show(this, mouseEvent.getX(), mouseEvent.getY());
                this.remove(this.popNew);
            } else {
                OpConnector opConnector = this.getConnector(spectStreamSlot);
                if (opConnector != null) {
                    opConnector.drawArrow(false);
                    Dimension dimension = opConnector.getSize();
                    opConnector.setLocation(mouseEvent.getX() - (dimension.width >> 1), mouseEvent.getY() - (dimension.height >> 1));
                    opConnector.setVisible(true);
                    this.updateOperator(spectStreamSlot.getOwner());
                }
            }
        } else if (this.dragContext != null) {
            this.dragContext.mouseReleased(mouseEvent);
            this.dragContext = null;
        }
        this.repaint();
    }

    private void iconContextMenu(MouseEvent mouseEvent) {
        OpIcon opIcon = (OpIcon)mouseEvent.getSource();
        Point point = opIcon.getLocation();
        this.popSource = opIcon;
        this.popX = mouseEvent.getX() + point.x;
        this.popY = mouseEvent.getY() + point.y;
        this.add(this.popIcon);
        this.popIcon.show(this.popSource, mouseEvent.getX(), mouseEvent.getY());
        this.remove(this.popIcon);
    }

    public void iconPressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.iconContextMenu(mouseEvent);
        } else if (mouseEvent.isAltDown()) {
            OpIcon opIcon = (OpIcon)mouseEvent.getSource();
            if (!opIcon.getOperator().getSlots(33).isEmpty()) {
                this.dragContext = new DragContext(mouseEvent, 1);
            }
        } else {
            this.dragContext = new DragContext(mouseEvent, 0);
        }
    }

    public void iconReleased(MouseEvent mouseEvent) {
        OpIcon opIcon = (OpIcon)mouseEvent.getSource();
        if (mouseEvent.getClickCount() == 2) {
            Operator operator = opIcon.getOperator();
            Operator operator2 = operator.getOriginal();
            if (operator2 != null) {
                int n = JOptionPane.showOptionDialog(this.win.getComponent(), "Aliases cannot be edited.\nDo you want to edit the original Operator\nor shall this Alias be transformed\ninto a genuine object?", "Request", 0, 3, null, this.optionsAliasEdit, this.optionsAliasEdit[2]);
                switch (n) {
                    case 2: {
                        operator.turnIntoGenuine();
                        opIcon = (OpIcon)operator.getIcon();
                        String string = opIcon.getName();
                        if (!string.endsWith(" alias")) break;
                        opIcon.setName(string.substring(0, string.length() - 6));
                        break;
                    }
                    case 1: {
                        operator = operator2;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            EditOpDlg editOpDlg = new EditOpDlg(this.win.getComponent(), operator);
            editOpDlg.setVisible(true);
            if (editOpDlg.getChoice()) {
                this.updateOperator(operator);
            }
            editOpDlg.dispose();
        } else {
            if (this.dragContext == null) {
                return;
            }
            if (this.dragContext.hasDragStarted()) {
                this.dragContext.mouseReleased(mouseEvent);
                if (this.dragContext.wasDragSuccessful()) {
                    OpIcon opIcon2 = (OpIcon)mouseEvent.getComponent();
                    Rectangle rectangle = opIcon2.getBounds();
                    switch (this.dragContext.getType()) {
                        case 0: {
                            this.moveOperator(opIcon2.getOperator(), rectangle.x + mouseEvent.getX() - (rectangle.width >> 1), rectangle.y + mouseEvent.getY() - (rectangle.height >> 1));
                            break;
                        }
                        case 1: {
                            Operator operator = opIcon2.getOperator();
                            try {
                                SpectStreamSlot spectStreamSlot = operator.getSlots(33).firstElement();
                                Operator operator3 = ((OpIcon)this.dragContext.getTarget()).getOperator();
                                SpectStreamSlot spectStreamSlot2 = operator3.getSlots(17).firstElement();
                                this.linkOperators(spectStreamSlot, spectStreamSlot2);
                            }
                            catch (Exception exception) {
                                GUIUtil.displayError((Component)this.win.getComponent(), (Exception)exception, (String)"link");
                            }
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                this.dragContext.mouseReleased(mouseEvent);
            }
            this.dragContext = null;
        }
        this.repaint();
    }

    private void connectorContextMenu(MouseEvent mouseEvent) {
        OpConnector opConnector = (OpConnector)mouseEvent.getSource();
        Point point = opConnector.getLocation();
        this.popSource = opConnector;
        this.popX = mouseEvent.getX() + point.x;
        this.popY = mouseEvent.getY() + point.y;
        Vector<SpectStreamSlot> vector = opConnector.getOrigin().getOwner().getSlots(33);
        String string = MI_ORIGIN;
        for (int i = 0; i < 2; ++i) {
            if (!vector.isEmpty()) {
                OpPanel.mCon[i] = new String[1 + vector.size()];
                OpPanel.mCon[i][0] = string;
                for (int j = 0; j < vector.size(); ++j) {
                    OpPanel.mCon[i][j + 1] = ((Object)vector.elementAt(j)).toString();
                }
            } else {
                OpPanel.mCon[i] = new String[0];
            }
            vector = opConnector.getOrigin().getLinked().getOwner().getSlots(17);
            string = MI_TARGET;
        }
        this.popCon = new PopupStrip(mCon, this);
        this.add(this.popCon);
        this.popCon.show(this.popSource, mouseEvent.getX(), mouseEvent.getY());
        this.remove(this.popCon);
    }

    public void connectorPressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.connectorContextMenu(mouseEvent);
        } else {
            this.dragContext = new DragContext(mouseEvent, 0);
        }
    }

    public void connectorReleased(MouseEvent mouseEvent) {
        OpConnector opConnector = (OpConnector)mouseEvent.getComponent();
        if (mouseEvent.isAltDown()) {
            opConnector.drawArrow(false);
            opConnector.setVisible(false);
            this.updateOperator(opConnector.getOrigin().getOwner());
        } else {
            if (this.dragContext == null) {
                return;
            }
            if (this.dragContext.hasDragStarted()) {
                this.dragContext.mouseReleased(mouseEvent);
                if (this.dragContext.wasDragSuccessful()) {
                    OpConnector opConnector2 = (OpConnector)mouseEvent.getComponent();
                    Rectangle rectangle = opConnector2.getBounds();
                    this.moveConnector(opConnector2, rectangle.x + mouseEvent.getX() - (rectangle.width >> 1), rectangle.y + mouseEvent.getY() - (rectangle.height >> 1));
                }
            } else {
                this.dragContext.mouseReleased(mouseEvent);
            }
            this.dragContext = null;
        }
        this.repaint();
    }

    public void labelPressed(MouseEvent mouseEvent) {
    }

    public void labelReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.popSource = ((OpIconLabel)mouseEvent.getComponent()).getOpIcon();
            this.actionPerformed(new ActionEvent(this, 1001, MI_RENAME));
        }
    }

    protected void validateSize(Component component) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = component.toString() == "OpIcon" ? ((OpIcon)component).getUnionBounds() : component.getBounds();
        if (!this.contains(rectangle.x + rectangle.width + 3, rectangle.y + rectangle.height + 3)) {
            this.preferredWidth = Math.max(dimension.width, rectangle.x + rectangle.width + 3);
            this.preferredHeight = Math.max(dimension.height, rectangle.y + rectangle.height + 3);
            Container container = this.getParent();
            container.doLayout();
        }
    }

    private Point findFreePlaceAround(int n, int n2, OpIcon opIcon) {
        double d;
        double d2 = d = Math.PI * 2;
        double d3 = 0.0;
        int n3;
        int n4;
        while (this.getOpIconAround(n4 = n + (int)(d3 * Math.cos(d2)), n3 = n2 + (int)(d3 * Math.sin(d2)), opIcon, 4, 4) != null || n4 < 22 || n3 < 22) {
            if (d2 >= d) {
                d2 = 0.0;
                d3 += 6.0;
                continue;
            }
            d2 += 6.0 / d3;
        }
        return new Point(n4, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpectStreamSlot getLinkAround(int n, int n2, boolean bl) {
        int n3 = 5;
        SpectStreamSlot spectStreamSlot = null;
        Hashtable hashtable = this.hCon;
        synchronized (hashtable) {
            Enumeration enumeration = this.hCon.elements();
            while (enumeration.hasMoreElements()) {
                OpConnector opConnector = (OpConnector)enumeration.nextElement();
                int n4 = OpConnector.getDistance(opConnector, n, n2);
                if (n4 < 0 || n4 >= n3) continue;
                spectStreamSlot = opConnector.getOrigin();
            }
        }
        if (spectStreamSlot != null && (spectStreamSlot.getFlags() & (bl ? 32 : 16)) == 0) {
            spectStreamSlot = spectStreamSlot.getLinked();
        }
        return spectStreamSlot;
    }
}

