/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.Marker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class PearsonPlotDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_PATTERNFILE = 1;
    private static final int PR_ICONFILE = 2;
    private static final int PR_OUTPUTFILE = 3;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_TRIGSOURCE = 3;
    private static final int PR_TRIGSIGN = 4;
    private static final int PR_GAIN = 0;
    private static final int PR_TRIGTHRESH = 1;
    private static final int PR_TRIGINTERVAL = 2;
    private static final int PR_PLOTGAIN = 3;
    private static final int PR_PLOTCHANGAIN = 4;
    private static final int PR_PLOTQUANTAMOUNT = 5;
    private static final int PR_PLOTOFFSET = 6;
    private static final int PR_PLOTNUM = 7;
    private static final int PR_WRITEMARK = 0;
    private static final int PR_PLOTQUANT = 1;
    private static final int PR_PLOTMAX = 2;
    private static final int SRC_SUM = 0;
    private static final int SRC_AND = 2;
    private static final int SIGN_POS = 0;
    private static final int SIGN_NEG = 1;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_PATTERNFILE = "PtrnFile";
    private static final String PRN_ICONFILE = "IconFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_WRITEMARK = "WriteMark";
    private static final String PRN_TRIGTHRESH = "TrigTresh";
    private static final String PRN_TRIGINTERVAL = "TrigInterv";
    private static final String PRN_PLOTGAIN = "PltGain";
    private static final String PRN_PLOTCHANGAIN = "PltChGain";
    private static final String PRN_PLOTQUANT = "PltQuant";
    private static final String PRN_PLOTQUANTAMOUNT = "PltQuantAmt";
    private static final String PRN_PLOTOFFSET = "PltOffset";
    private static final String PRN_PLOTMAX = "PltMax";
    private static final String PRN_PLOTNUM = "PltNum";
    private static final String PRN_TRIGSOURCE = "TrigSrc";
    private static final String PRN_TRIGSIGN = "TrigSign";
    private static final String[] prText = new String[]{"", "", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "PtrnFile", "IconFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "TrigSrc", "TrigSign"};
    private static final boolean[] prBool = new boolean[]{true, false, false};
    private static final String[] prBoolName = new String[]{"WriteMark", "PltQuant", "PltMax"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "TrigTresh", "TrigInterv", "PltGain", "PltChGain", "PltQuantAmt", "PltOffset", "PltNum"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1027;
    private static final int GG_PATTERNFILE = 1025;
    private static final int GG_ICONFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_TRIGSOURCE = 259;
    private static final int GG_TRIGSIGN = 260;
    private static final int GG_GAIN = 512;
    private static final int GG_TRIGTHRESH = 513;
    private static final int GG_TRIGINTERVAL = 514;
    private static final int GG_PLOTGAIN = 515;
    private static final int GG_PLOTCHANGAIN = 516;
    private static final int GG_PLOTQUANTAMOUNT = 517;
    private static final int GG_PLOTOFFSET = 518;
    private static final int GG_PLOTNUM = 519;
    private static final int GG_WRITEMARK = 0;
    private static final int GG_PLOTQUANT = 1;
    private static final int GG_PLOTMAX = 2;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private JLabel lbTrigs;
    private static final String ERR_CHANNELS = "Input + pattern must share\nsame # of channels!\n(or use sum source)";
    private static final String ERR_TOOSMALL = "Input cannot be shorter than pattern";
    private static final String ERR_SILENCE = "Pattern contains pure silence";
    private static final String MARK_TRIG = "Trig";

    public PearsonPlotDlg() {
        super("Pearson Plotter");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            PearsonPlotDlg.static_pr.text = prText;
            PearsonPlotDlg.static_pr.textName = prTextName;
            PearsonPlotDlg.static_pr.intg = prIntg;
            PearsonPlotDlg.static_pr.intgName = prIntgName;
            PearsonPlotDlg.static_pr.bool = prBool;
            PearsonPlotDlg.static_pr.boolName = prBoolName;
            PearsonPlotDlg.static_pr.para = prPara;
            PearsonPlotDlg.static_pr.para[1] = new Param(50.0, 17);
            PearsonPlotDlg.static_pr.para[2] = new Param(50.0, 2);
            PearsonPlotDlg.static_pr.para[3] = new Param(50.0, 17);
            PearsonPlotDlg.static_pr.para[4] = new Param(50.0, 17);
            PearsonPlotDlg.static_pr.para[5] = new Param(1.0, 258);
            PearsonPlotDlg.static_pr.para[6] = new Param(0.0, 2);
            PearsonPlotDlg.static_pr.para[7] = new Param(10.0, 0);
            PearsonPlotDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(PearsonPlotDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(PearsonPlotDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = PearsonPlotDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 1: 
                    case 2: {
                        ((PearsonPlotDlg)PearsonPlotDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        PearsonPlotDlg.this.reflectPropertyChanges();
                        break;
                    }
                    case 259: {
                        ((PearsonPlotDlg)PearsonPlotDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        PearsonPlotDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Control input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select matching pattern file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Pattern input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(16, "Select plot source file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Icon input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        PathField pathField4 = new PathField(49, "Select output file");
        pathField4.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField, pathField3};
        pathField4.deriveFrom(pathFieldArray, "$D0$B0Plot$B1$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Plot output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField4, 1027, null);
        this.gui.registerGadget(pathField4.getTypeGadget(), 256);
        this.gui.registerGadget(pathField4.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Trigger settings", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Sum");
        jComboBox.addItem("Parallel (OR)");
        jComboBox.addItem("Serial (AND)");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Source channels", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 259, itemListener);
        ParamField paramField = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Threshold", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 513, null);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        jComboBox2.addItem("Pos.(in phase)");
        jComboBox2.addItem("Neg.(antiphase)");
        jComboBox2.addItem("Both");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Thresh sign", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox2, 260, itemListener);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9]};
        ParamField paramField2 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Min.interval", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 514, null);
        this.gui.addLabel(new GroupLabel("Plotter settings", 1, 0));
        ParamField paramField3 = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Variable gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 515, null);
        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{Constants.spaces[12], Constants.spaces[13]};
        ParamField paramField4 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Offset", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 518, null);
        ParamField paramField5 = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Channel gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField5, 516, null);
        JCheckBox jCheckBox = new JCheckBox("Quantisize");
        gridBagConstraints.weightx = 0.1;
        this.gui.addCheckbox(jCheckBox, 1, itemListener);
        ParamField paramField6 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField6, 517, null);
        JCheckBox jCheckBox2 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Write markers", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox2, 0, itemListener);
        JCheckBox jCheckBox3 = new JCheckBox("Limit #plots");
        gridBagConstraints.weightx = 0.1;
        this.gui.addCheckbox(jCheckBox3, 2, itemListener);
        ParamField paramField7 = new ParamField(new ParamSpace(1.0, 10000.0, 1.0, 0));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField7, 519, null);
        this.gui.addLabel(new GroupLabel("Trigger View", 1, 0));
        this.lbTrigs = new JLabel(" ");
        this.gui.addLabel(this.lbTrigs);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        Graphics graphics;
        File file;
        RandomAccessFile randomAccessFile;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        AudioFile audioFile4;
        block104: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            float[][] fArray4;
            float[][] fArray5;
            audioFile4 = null;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            AudioFileDescr audioFileDescr3 = null;
            AudioFileDescr audioFileDescr4 = null;
            floatFileArray = null;
            fileArray = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            boolean bl = this.pr.intg[3] == 0;
            int n2 = 0;
            int[] nArray = null;
            byte[] byArray = null;
            randomAccessFile = null;
            file = null;
            graphics = null;
            try {
                int n3;
                int n4;
                int n5;
                float f3;
                int n6;
                int n7;
                int n8;
                int n9;
                audioFile4 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile4.getDescr();
                int n10 = audioFileDescr.channels;
                int n11 = (int)audioFileDescr.length;
                if (n11 < 1 || n10 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block104;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                audioFileDescr3 = audioFile2.getDescr();
                int n12 = audioFileDescr3.channels;
                int n13 = (int)audioFileDescr3.length;
                if (n13 < 1 || n12 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block104;
                if (n10 != n12 && !bl) {
                    throw new IOException(ERR_CHANNELS);
                }
                if (n11 < n13) {
                    throw new IOException(ERR_TOOSMALL);
                }
                audioFile = AudioFile.openAsRead((File)new File(this.pr.text[2]));
                audioFileDescr4 = audioFile.getDescr();
                int n14 = audioFileDescr4.channels;
                int n15 = (int)audioFileDescr4.length;
                if (n15 < 1 || n14 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block104;
                int n16 = bl ? 1 : n10;
                int n17 = Math.max(n16, n14);
                PathField pathField = (PathField)this.gui.getItemObj(1027);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                IOUtil.createEmptyFile((File)new File(this.pr.text[3]));
                audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFileDescr2.channels = n17;
                Vector<Marker> vector = (Vector<Marker>)audioFileDescr2.getProperty((Object)"markers");
                if (vector == null && this.pr.bool[0]) {
                    vector = new Vector<Marker>();
                    audioFileDescr2.setProperty("markers", vector);
                }
                if (!this.threadRunning) break block104;
                graphics = this.lbTrigs.getGraphics();
                Dimension dimension = this.lbTrigs.getSize();
                if (graphics != null) {
                    this.lbTrigs.repaint();
                    graphics.setColor(Color.red);
                }
                float f4 = (float)Param.transform((Param)this.pr.para[1], (int)1, (Param)param, null).value;
                int n18 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[2].value) + 0.5);
                float f5 = f4;
                float f6 = -f4;
                switch (this.pr.intg[4]) {
                    case 0: {
                        f6 = Float.NEGATIVE_INFINITY;
                        break;
                    }
                    case 1: {
                        f5 = Float.POSITIVE_INFINITY;
                    }
                }
                int n19 = this.pr.bool[1] ? (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[5], (int)2, (Param)new Param((double)0.0, (int)2), null).value) + 0.5) : 1;
                int n20 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[6], (int)2, (Param)new Param((double)0.0, (int)2), null).value) + 0.5);
                int n21 = 2 * n13 - 1;
                for (n9 = 2; n9 < n21; n9 <<= 1) {
                }
                int n22 = n9 - n13 + 1;
                int n23 = n22 - 2;
                int n24 = n9 - n23;
                fArray5 = new float[Math.max(Math.max(n10, n12), n14)][8192];
                fArray4 = new float[bl ? 1 : n12][n9 + 2];
                fArray3 = new float[n16][n9 + 2];
                float[][] fArray6 = new float[n16][n24];
                Util.clear(fArray4);
                Util.clear(fArray3);
                int n25 = n17 + 1;
                int n26 = n25 * 256;
                nArray = new int[n26];
                byArray = new byte[256];
                int n27 = 0;
                file = IOUtil.createTempFile();
                randomAccessFile = new RandomAccessFile(file, "rw");
                float f7 = (float)Param.transform((Param)this.pr.para[3], (int)1, (Param)param, null).value;
                float f8 = (float)Param.transform((Param)this.pr.para[4], (int)1, (Param)param, null).value;
                long l = 0L;
                long l2 = (long)n13 * (long)(1 + (bl ? 1 : n12)) + (long)n11 * (long)(1 + n16);
                l2 *= 2L;
                fileArray = new File[n17];
                floatFileArray = new FloatFile[n17];
                for (n = 0; n < n17; ++n) {
                    fileArray[n] = null;
                    floatFileArray[n] = null;
                }
                for (n = 0; n < n17; ++n) {
                    fileArray[n] = IOUtil.createTempFile();
                    floatFileArray[n] = new FloatFile(fileArray[n], 1);
                }
                if (!this.threadRunning) break block104;
                for (n7 = 0; this.threadRunning && n7 < n13; n7 += n8) {
                    n8 = Math.min(n13 - n7, 8192);
                    audioFile2.readFrames(fArray5, 0, n8);
                    if (bl && n12 > 1) {
                        fArray2 = fArray4[0];
                        for (n = 0; n < n12; ++n) {
                            fArray = fArray5[n];
                            n21 = 0;
                            n6 = n13 - n7;
                            while (n21 < n8) {
                                int n28 = --n6;
                                fArray2[n28] = fArray2[n28] + fArray[n21++];
                            }
                        }
                    } else {
                        for (n = 0; n < n12; ++n) {
                            fArray = fArray5[n];
                            fArray2 = fArray4[n];
                            n21 = 0;
                            n6 = n13 - n7;
                            while (n21 < n8) {
                                fArray2[--n6] = fArray[n21++];
                            }
                        }
                    }
                    this.setProgression((float)(l += (long)n8) / (float)l2);
                }
                if (!this.threadRunning) break block104;
                if (bl) {
                    n12 = 1;
                }
                for (n = 0; this.threadRunning && n < n12; ++n) {
                    fArray = fArray4[n];
                    n6 = 0;
                    double d = 0.0;
                    while (n6 < n13) {
                        d += (double)fArray[n6++];
                    }
                    f3 = (float)(-d / (double)n13);
                    n6 = 0;
                    d = 0.0;
                    while (n6 < n13) {
                        int n29 = n6++;
                        fArray[n29] = fArray[n29] + f3;
                    }
                    d = Math.sqrt(Filter.calcEnergy(fArray, 0, n13));
                    if (!(d > 0.0)) {
                        throw new IOException(ERR_SILENCE);
                    }
                    Util.mult(fArray, 0, n13, (float)(1.0 / d));
                    Fourier.realTransform(fArray, n9, 1);
                    this.setProgression((float)(l += (long)n13) / (float)l2);
                }
                if (!this.threadRunning) break block104;
                audioFile2.close();
                audioFile2 = null;
                audioFileDescr3 = null;
                int n30 = 1;
                n7 = 0;
                int n31 = 0;
                int n32 = -n18;
                while (this.threadRunning && n7 < n11) {
                    n5 = Math.min(n11 - n7 + n30, n22);
                    for (n4 = n30; this.threadRunning && n4 < n5; n4 += n8) {
                        n8 = Math.min(8192, n5 - n4);
                        if (bl && n10 > 1) {
                            audioFile4.readFrames(fArray5, 0, n8);
                            System.arraycopy(fArray5[0], 0, fArray3[0], n4, n8);
                            for (n = 1; n < n10; ++n) {
                                Util.add(fArray5[n], 0, fArray3[0], n4, n8);
                            }
                        } else {
                            audioFile4.readFrames(fArray3, n4, n8);
                        }
                        n7 += n8;
                        this.setProgression((float)(l += (long)n8) / (float)l2);
                    }
                    if (this.threadRunning) {
                        for (n = 0; n < n16; ++n) {
                            fArray = fArray3[n];
                            n21 = 0;
                            while (n21 < n30) {
                                fArray[n21++] = 0.0f;
                            }
                            n21 = n5;
                            while (n21 < n9) {
                                fArray[n21++] = 0.0f;
                            }
                        }
                        for (n = 0; this.threadRunning && n < n16; ++n) {
                            Fourier.realTransform(fArray3[n], n9, 1);
                            Fourier.complexMult(fArray4[n % n12], 0, fArray3[n], 0, fArray3[n], 0, n9 + 2);
                            Fourier.realTransform(fArray3[n], n9, -1);
                            Util.add(fArray6[n], 0, fArray3[n], 0, n24);
                            System.arraycopy(fArray3[n], n22 - 2, fArray6[n], 0, n24);
                            this.setProgression((float)(l += (long)n5) / (float)l2);
                        }
                        if (this.threadRunning) {
                            float f9;
                            int n33 = 0;
                            for (n = 0; n < n16; ++n) {
                                fArray = fArray3[n];
                                for (n21 = 1; n21 < n5 - 1; ++n21) {
                                    f3 = fArray[n21];
                                    f9 = f3 - fArray[n21 - 1];
                                    if (f9 > 0.0f) {
                                        f9 = fArray[n21 + 1] - f3;
                                        if (f9 < 0.0f && f3 > f5) {
                                            ++n33;
                                            continue;
                                        }
                                    } else if (f9 < 0.0f && (f9 = fArray[n21 + 1] - f3) > 0.0f && f3 < f6) {
                                        ++n33;
                                        continue;
                                    }
                                    fArray[n21] = 0.0f;
                                }
                            }
                            if (n33 > 0) {
                                switch (this.pr.intg[3]) {
                                    case 2: {
                                        block32: for (n21 = 1; n21 < n5 - 1; ++n21) {
                                            for (n = 0; n < n16; ++n) {
                                                if (fArray3[n][n21] == 0.0f) continue block32;
                                            }
                                            n6 = n31 + n21 - 1;
                                            if (n6 - n32 < n18) continue;
                                            n32 = n6;
                                            if (this.pr.bool[0]) {
                                                vector.add(new Marker((long)n6, MARK_TRIG));
                                            }
                                            if (graphics != null) {
                                                n3 = (int)((float)n6 / (float)n11 * (float)dimension.width + 0.5f);
                                                graphics.drawLine(n3, 0, n3, dimension.height - 1);
                                            }
                                            n6 += n19 >> 1;
                                            n6 += n20 - n6 % n19;
                                            f3 = 0.0f;
                                            for (n = 0; n < n16; ++n) {
                                                f3 += fArray3[n][n21];
                                            }
                                            f3 /= (float)n16;
                                            nArray[n27++] = n6;
                                            for (n = 0; n < n17; ++n) {
                                                f9 = 1.0f + f7 * (f3 + f8 * (fArray3[n % n16][n21] - f3) - 1.0f);
                                                nArray[n27++] = Float.floatToIntBits(f9);
                                            }
                                            if (n27 != n26) continue;
                                            this.writeBytes(randomAccessFile, nArray, 0, n26, byArray);
                                            n2 += n27;
                                            n27 = 0;
                                        }
                                        break;
                                    }
                                    default: {
                                        block36: for (n21 = 1; n21 < n5 - 1; ++n21) {
                                            for (n = 0; n < n16; ++n) {
                                                if (fArray3[n][n21] == 0.0f) continue;
                                                n6 = n31 + n21 - 1;
                                                if (n6 - n32 < n18) continue block36;
                                                n32 = n6;
                                                if (this.pr.bool[0]) {
                                                    vector.add(new Marker((long)n6, MARK_TRIG));
                                                }
                                                if (graphics != null) {
                                                    n3 = (int)((float)n6 / (float)n11 * (float)dimension.width + 0.5f);
                                                    graphics.drawLine(n3, 0, n3, dimension.height - 1);
                                                }
                                                n6 += n19 >> 1;
                                                n6 += n20 - n6 % n19;
                                                f3 = 0.0f;
                                                for (n = 0; n < n16; ++n) {
                                                    f3 += fArray3[n][n21];
                                                }
                                                f3 /= (float)n16;
                                                nArray[n27++] = n6;
                                                for (n = 0; n < n17; ++n) {
                                                    f9 = 1.0f + f7 * (f3 + f8 * (fArray3[n % n16][n21] - f3) - 1.0f);
                                                    nArray[n27++] = Float.floatToIntBits(f9);
                                                }
                                                if (n27 != n26) continue block36;
                                                this.writeBytes(randomAccessFile, nArray, 0, n26, byArray);
                                                n2 += n27;
                                                n27 = 0;
                                                continue block36;
                                            }
                                        }
                                    }
                                }
                            }
                            n31 = n7 - 1;
                            n30 = 2;
                            continue;
                        }
                    }
                    break block104;
                }
                if (!this.threadRunning) break block104;
                audioFile4.close();
                audioFile4 = null;
                audioFileDescr = null;
                fArray4 = null;
                fArray3 = null;
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
                this.writeBytes(randomAccessFile, nArray, 0, n27, byArray);
                randomAccessFile.seek(0L);
                n2 += n27;
                audioFile3 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                if ((n2 /= n25) > 0) {
                    int n34;
                    System.gc();
                    n26 = n2 * n25;
                    nArray = new int[n26];
                    for (n4 = 0; this.threadRunning && n4 < n26; n4 += n8) {
                        n8 = Math.min(nArray.length - n4, 8192);
                        this.readBytes(randomAccessFile, nArray, n4, n8, byArray);
                        this.setProgression(this.getProgression());
                    }
                    if (!this.threadRunning) break block104;
                    int n35 = (int)((Runtime.getRuntime().freeMemory() >> 4) * 3L / (long)n14);
                    if (n35 >= n15) {
                        n35 = n15;
                    } else if (n35 < 1024) {
                        throw new OutOfMemoryError("FScape ran out of memory");
                    }
                    fArray4 = new float[n14][n35];
                    int n36 = (n15 - 1) / n35;
                    int n37 = nArray[n26 - n25] + n15;
                    int n38 = nArray[0];
                    l2 = (long)n15 + (long)n37 + (long)n38;
                    int n39 = 0;
                    n30 = 0;
                    while (n39 <= n36) {
                        n31 = n38 + n30;
                        l2 += (long)(n37 - n31);
                        ++n39;
                        n30 += n35;
                    }
                    l = l2;
                    l2 *= 2L;
                    if (n38 > 0) {
                        Util.clear(fArray5);
                        for (n34 = 0; this.threadRunning && n34 < n38; n34 += n8) {
                            n8 = Math.min(8192, n38 - n34);
                            for (n = 0; n < n17; ++n) {
                                floatFileArray[n].writeFloats(fArray5[0], 0, n8);
                            }
                            this.setProgression((float)(l += (long)n8) / (float)l2);
                        }
                        if (!this.threadRunning) break block104;
                    }
                    n39 = 0;
                    n30 = 0;
                    while (this.threadRunning && n39 <= n36) {
                        int n40;
                        n31 = n38 + n30;
                        audioFile.seekFrame((long)n30);
                        int n41 = Math.min(n15 - n30, n35);
                        for (n4 = 0; this.threadRunning && n4 < n41; n4 += n8) {
                            n8 = Math.min(8192, n41 - n4);
                            audioFile.readFrames(fArray4, n4, n8);
                            this.setProgression((float)(l += (long)n8) / (float)l2);
                        }
                        if (!this.threadRunning) break block104;
                        n5 = Math.min(8192, n37 - n31);
                        for (n27 = 0; n27 < nArray.length && nArray[n27] + n30 + n41 <= n31; n27 += n25) {
                        }
                        for (n40 = n27; n40 < nArray.length && nArray[n40] < n31 + n5; n40 += n25) {
                        }
                        while (this.threadRunning && n31 < n37) {
                            boolean bl2;
                            n5 = Math.min(8192, n37 - n31);
                            while (n27 < nArray.length && nArray[n27] + n30 + n41 <= n31) {
                                n27 += n25;
                            }
                            while (n40 < nArray.length && nArray[n40] < n31 + n5) {
                                n40 += n25;
                            }
                            boolean bl3 = bl2 = n40 > n27 || n39 == n36;
                            if (bl2) {
                                n21 = Math.min(n5, Math.max(0, n34 - n31));
                                for (n = 0; n < n17; ++n) {
                                    fArray = fArray5[n];
                                    floatFileArray[n].seekFloat(n31);
                                    floatFileArray[n].readFloats(fArray, 0, n21);
                                    n6 = n21;
                                    while (n6 < n5) {
                                        fArray[n6++] = 0.0f;
                                    }
                                }
                                n21 = n27;
                                while (n21 < n40) {
                                    if ((n4 = (n6 = nArray[n21++] + n30) - n31) < 0) {
                                        n3 = -n4;
                                        n4 = 0;
                                    } else {
                                        n3 = 0;
                                    }
                                    n8 = Math.min(n5, n41 - n3 + n4);
                                    for (n = 0; n < n17; ++n) {
                                        f3 = Float.intBitsToFloat(nArray[n21++]);
                                        fArray = fArray4[n % n14];
                                        fArray2 = fArray5[n];
                                        int n42 = n4;
                                        int n43 = n3;
                                        while (n42 < n8) {
                                            int n44 = n42++;
                                            fArray2[n44] = fArray2[n44] + f3 * fArray[n43++];
                                        }
                                    }
                                }
                                for (n = 0; n < n17; ++n) {
                                    floatFileArray[n].seekFloat(n31);
                                    floatFileArray[n].writeFloats(fArray5[n], 0, n5);
                                }
                            }
                            n31 += n5;
                            this.setProgression((float)(l += (long)n5) / (float)l2);
                            if (this.threadRunning) continue;
                            break block104;
                        }
                        n34 = (int)floatFileArray[0].getSize();
                        ++n39;
                        n30 += n35;
                    }
                    if (!this.threadRunning) break block104;
                }
                f = this.pr.intg[2] == 0 ? (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value : (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                this.normalizeAudioFile(floatFileArray, audioFile3, fArray5, f, 1.0f);
                for (n = 0; n < n17; ++n) {
                    floatFileArray[n].cleanUp();
                    floatFileArray[n] = null;
                    fileArray[n].delete();
                    fileArray[n] = null;
                }
                if (this.threadRunning) {
                    audioFile3.close();
                    audioFile3 = null;
                    audioFileDescr2 = null;
                    audioFile.close();
                    audioFile = null;
                    audioFileDescr4 = null;
                    fArray5 = null;
                    f2 *= f;
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                audioFileDescr3 = null;
                audioFileDescr4 = null;
                fArray5 = null;
                fArray4 = null;
                fArray3 = null;
                fArray = null;
                fArray2 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (graphics != null) {
            graphics.dispose();
            graphics = null;
        }
        if (audioFile4 != null) {
            audioFile4.cleanUp();
            audioFile4 = null;
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
            audioFile3 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file != null) {
            file.delete();
        }
    }

    protected void writeBytes(RandomAccessFile randomAccessFile, int[] nArray, int n, int n2, byte[] byArray) throws IOException {
        n2 += n;
        while (n < n2) {
            int n3 = Math.min(n2 - n, byArray.length >> 2);
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5 = nArray[n++];
                byArray[n4++] = (byte)(n5 >> 24);
                byArray[n4++] = (byte)(n5 >> 16);
                byArray[n4++] = (byte)(n5 >> 8);
                byArray[n4++] = (byte)n5;
            }
            randomAccessFile.write(byArray, 0, n4);
        }
    }

    protected void readBytes(RandomAccessFile randomAccessFile, int[] nArray, int n, int n2, byte[] byArray) throws IOException {
        n2 += n;
        while (n < n2) {
            int n3 = Math.min(n2 - n << 2, byArray.length);
            randomAccessFile.readFully(byArray, 0, n3);
            int n4 = 0;
            while (n4 < n3) {
                nArray[n++] = byArray[n4++] << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(517);
        if (component != null) {
            component.setEnabled(this.pr.bool[1]);
        }
        if ((component = this.gui.getItemObj(519)) != null) {
            component.setEnabled(this.pr.bool[2]);
        }
        if ((component = this.gui.getItemObj(516)) != null) {
            component.setEnabled(this.pr.intg[3] != 0);
        }
    }
}

