/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.app.PreferenceEntrySync;
import de.sciss.fscape.Application;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.gui.PrefPathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.net.OSCRoot;
import de.sciss.gui.PrefCheckBox;
import de.sciss.gui.PrefComboBox;
import de.sciss.gui.PrefParamField;
import de.sciss.gui.SpringPanel;
import de.sciss.gui.StringItem;
import de.sciss.io.IOUtil;
import de.sciss.util.Flag;
import de.sciss.util.ParamSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PrefsPanel
extends JPanel {
    private static final ParamSpace spcIntegerFromZero = new ParamSpace(0.0, Double.POSITIVE_INFINITY, 1.0, 0, 0, 0.0);

    public PrefsPanel() {
        super(new BorderLayout());
        int n;
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        PrefsPanel prefsPanel = this;
        Flag flag = new Flag(false);
        Preferences preferences = Application.userPrefs;
        SpringPanel springPanel = new SpringPanel(2, 1, 4, 2);
        int n2 = 0;
        Preferences preferences2 = IOUtil.getUserPrefs();
        String string = "tmpdir";
        JLabel jLabel = new JLabel("Temporary Folder:", 11);
        springPanel.gridAdd((JComponent)jLabel, 0, n2);
        PrefPathField prefPathField = new PrefPathField(2, "Temporary Folder");
        prefPathField.setPreferences(preferences2, string);
        springPanel.gridAdd((JComponent)prefPathField, 1, n2);
        preferences2 = preferences;
        jLabel = new JLabel("Default Audio File Format:", 11);
        springPanel.gridAdd((JComponent)jLabel, 0, ++n2);
        Box box = Box.createHorizontalBox();
        PrefComboBox prefComboBox = new PrefComboBox();
        for (n = 0; n < GenericFile.TYPES_SOUND.length; ++n) {
            prefComboBox.addItem((Object)new StringItem(GenericFile.getFileTypeStr(GenericFile.TYPES_SOUND[n]), (Object)GenericFile.getTypeDescr(GenericFile.TYPES_SOUND[n])));
        }
        string = "audioFileType";
        prefComboBox.setPreferences(preferences2, string);
        box.add((Component)prefComboBox);
        prefComboBox = new PrefComboBox();
        for (n = 0; n < 4; ++n) {
            prefComboBox.addItem((Object)new StringItem(PathField.getSoundResID(n), (Object)PathField.getSoundResDescr(n)));
        }
        string = "audioFileRes";
        prefComboBox.setPreferences(preferences2, string);
        box.add((Component)prefComboBox);
        prefComboBox = new PrefComboBox();
        for (n = 0; n < 4; ++n) {
            prefComboBox.addItem((Object)new StringItem(PathField.getSoundRateID(n), (Object)PathField.getSoundRateDescr(n)));
        }
        string = "audioFileRate";
        prefComboBox.setPreferences(preferences2, string);
        box.add((Component)prefComboBox);
        springPanel.gridAdd((JComponent)box, 1, n2, -1, 1);
        preferences2 = preferences;
        string = "headroom";
        jLabel = new JLabel("Default Headroom:", 11);
        springPanel.gridAdd((JComponent)jLabel, 0, ++n2);
        PrefParamField prefParamField = new PrefParamField();
        prefParamField.addSpace(ParamSpace.spcAmpDecibels);
        prefParamField.setPreferences(preferences2, string);
        springPanel.gridAdd((JComponent)prefParamField, 1, n2, -1, 1);
        OSCRoot oSCRoot = OSCRoot.getInstance();
        preferences2 = oSCRoot.getPreferences();
        string = "active";
        jLabel = new JLabel("OSC Server:", 11);
        springPanel.gridAdd((JComponent)jLabel, 0, ++n2);
        box = Box.createHorizontalBox();
        PrefCheckBox prefCheckBox = new PrefCheckBox("Active");
        prefCheckBox.setPreferences(preferences2, string);
        box.add((Component)prefCheckBox);
        string = "protocol";
        jLabel = new JLabel("Protocol:", 11);
        box.add(Box.createHorizontalStrut(16));
        box.add(jLabel);
        prefComboBox = new PrefComboBox();
        prefComboBox.addItem((Object)new StringItem("tcp", (Object)"TCP"));
        prefComboBox.addItem((Object)new StringItem("udp", (Object)"UDP"));
        prefComboBox.setPreferences(preferences2, string);
        box.add((Component)prefComboBox);
        string = "port";
        jLabel = new JLabel("Port:", 11);
        box.add(Box.createHorizontalStrut(16));
        box.add(jLabel);
        prefParamField = new PrefParamField();
        prefParamField.addSpace(spcIntegerFromZero);
        prefParamField.setPreferences(preferences2, string);
        box.add((Component)prefParamField);
        springPanel.gridAdd((JComponent)box, 1, n2, -1, 1);
        ++n2;
        preferences2 = preferences;
        string = "laf-type";
        String string2 = "Look-and-Feel";
        prefComboBox = new PrefComboBox();
        prefComboBox.addItem((Object)new StringItem("native", (Object)"Native"));
        prefComboBox.addItem((Object)new StringItem("metal", (Object)"Metal"));
        prefComboBox.addItem((Object)new StringItem("light", (Object)"Submin Light"));
        prefComboBox.addItem((Object)new StringItem("dark", (Object)"Submin Dark"));
        prefComboBox.setPreferences(preferences2, string);
        springPanel.gridAdd((JComponent)prefComboBox, 1, n2, -1, 1);
        prefComboBox.addActionListener((ActionListener)new WarnPrefsChange((PreferenceEntrySync)prefComboBox, (Component)prefComboBox, flag, "For Look-and-Feel changes to take effect,\nthe application must be restarted.", string2));
        ++n2;
        preferences2 = preferences;
        string = "lafdecoration";
        string2 = "Look-and-Feel Window Decoration";
        prefCheckBox = new PrefCheckBox(string2);
        prefCheckBox.setPreferences(preferences2, string);
        springPanel.gridAdd((JComponent)prefCheckBox, 1, n2, -1, 1);
        prefCheckBox.addActionListener((ActionListener)new WarnPrefsChange((PreferenceEntrySync)prefCheckBox, (Component)prefCheckBox, flag, "For Look-and-Feel changes to take effect,\nthe application must be restarted.", string2));
        springPanel.makeCompactGrid();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)springPanel, "North");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel.add((Component)jPanel2, "South");
        prefsPanel.add((Component)jPanel, "Center");
    }

    private static class WarnPrefsChange
    implements ActionListener {
        private final PreferenceEntrySync pes;
        private final Component c;
        private final Flag haveWarned;
        private final String text;
        private final String title;
        private final String initialValue;

        protected WarnPrefsChange(PreferenceEntrySync preferenceEntrySync, Component component, Flag flag, String string, String string2) {
            this.pes = preferenceEntrySync;
            this.c = component;
            this.haveWarned = flag;
            this.text = string;
            this.title = string2;
            this.initialValue = preferenceEntrySync.getPreferenceNode().get(preferenceEntrySync.getPreferenceKey(), null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            String string = this.pes.getPreferenceNode().get(this.pes.getPreferenceKey(), this.initialValue);
            boolean bl2 = bl = !(string == null && this.initialValue == null || string != null && string.equals(this.initialValue));
            if (bl && !this.haveWarned.isSet()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(WarnPrefsChange.this.c, WarnPrefsChange.this.text, WarnPrefsChange.this.title, 1);
                    }
                });
                this.haveWarned.set(true);
            }
        }
    }
}

