/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ProgressBar
extends JProgressBar {
    protected float p = 0.0f;
    private long startTime;
    private long pauseTime;
    private int remain;
    private byte[] timeStr;
    protected int maximum = 0;
    private String altString = null;
    private static final Color COLOR_SUCCESS = new Color(0, 255, 0, 47);
    private static final Color COLOR_FAILURE = new Color(255, 0, 0, 47);
    private Paint pnt = null;
    private boolean timePainted = false;

    public ProgressBar() {
        super(0, 0, 4096);
        this.setStringPainted(true);
        this.timeStr = "00:00:00".getBytes();
        this.reset();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = ProgressBar.this.getSize();
                ProgressBar.this.maximum = dimension.width;
                ProgressBar.this.setMaximum(dimension.width);
                ProgressBar.this.setValue((int)(ProgressBar.this.p * (float)ProgressBar.this.maximum));
            }
        });
    }

    public void setText(String string) {
        this.altString = string;
        this.setString(string == null ? "" : string);
    }

    public synchronized void setProgression(float f) {
        int n = (int)(this.p * (float)this.maximum);
        this.p = Math.max(0.0f, Math.min(1.0f, f));
        int n2 = (int)(this.p * (float)this.maximum);
        int n3 = this.remain;
        if (n2 != n) {
            this.setValue(n2);
            if (f > 0.0f) {
                int n4 = (int)(System.currentTimeMillis() - this.startTime) / 1000;
                this.remain = (int)((float)n4 / f) - n4;
                if ((n4 >= 10 & this.remain >= 10 | this.timePainted) & this.altString == null & !this.isIndeterminate()) {
                    if (this.remain < n3 || this.remain - n3 >= 10) {
                        int n5 = this.remain % 60;
                        this.timeStr[6] = (byte)(n5 / 10 + 48);
                        this.timeStr[7] = (byte)(n5 % 10 + 48);
                        int n6 = this.remain / 60 % 60;
                        this.timeStr[3] = (byte)(n6 / 10 + 48);
                        this.timeStr[4] = (byte)(n6 % 10 + 48);
                        int n7 = this.remain / 3600 % 100;
                        this.timeStr[0] = (byte)(n7 / 10 + 48);
                        this.timeStr[1] = (byte)(n7 % 10 + 48);
                        this.setString(new String(this.timeStr));
                        this.timePainted = true;
                    } else {
                        this.remain = n3;
                    }
                }
            }
        }
    }

    public float getProgression() {
        return this.p;
    }

    public void reset() {
        this.setIndeterminate(false);
        this.setProgression(0.0f);
        this.setPaint(null);
        this.timePainted = false;
        this.setText(null);
        this.remain = 0x20000000;
        this.startTime = System.currentTimeMillis();
    }

    public void pause() {
        this.pauseTime = System.currentTimeMillis();
    }

    public void resume() {
        this.startTime += System.currentTimeMillis() - this.pauseTime;
    }

    public void finish(int n) {
        this.setIndeterminate(false);
        this.setValue(this.maximum);
        this.setString("");
        this.timePainted = false;
        if (n == 0) {
            this.setPaint(COLOR_SUCCESS);
        } else if (n == 1) {
            this.setPaint(COLOR_FAILURE);
        }
    }

    public void setPaint(Paint paint) {
        this.pnt = paint;
        this.repaint();
    }

    public Paint getPaint() {
        return this.pnt;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.pnt == null) {
            return;
        }
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        String string = UIManager.getLookAndFeel().getName();
        boolean bl = string.equals("WebLaF");
        int n = bl ? 3 : 1;
        int n2 = bl ? 3 : 2;
        int n3 = bl ? 3 : 2;
        int n4 = bl ? 3 : 2;
        graphics2D.setPaint(this.pnt);
        graphics2D.fillRect(n2, n, dimension.width - (n2 + n4), dimension.height - (n + n3));
        graphics2D.setPaint(paint);
    }
}

