/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.ProgressBar;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.ProgressComponent;
import de.sciss.icons.raphael.Shapes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProgressPanel
extends JPanel
implements ProgressComponent {
    private final ProgressBar pb = new ProgressBar();
    private final JLabel lb = new JLabel("", 4);
    private final JButton ggCancel;

    public ProgressPanel() {
        this.lb.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 4));
        GeneralPath generalPath = new GeneralPath();
        Shapes.Cross((Path2D)generalPath);
        final Shape shape = generalPath.createTransformedShape(AffineTransform.getScaleInstance(0.5, 0.5));
        final Color color = this.getForeground();
        final Color color2 = new Color(color.getRGB() & 0xFFFFFF | 0x60000000, true);
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(ProgressPanel.this.ggCancel.isEnabled() ? color : color2);
                graphics2D.translate(n, n2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                graphics2D.fill(shape);
                graphics2D.translate(-n, -n2);
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
        this.ggCancel = new JButton(icon);
        this.ggCancel.setEnabled(false);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.lb);
        this.add(this.pb);
        this.add(this.ggCancel);
    }

    public void pause() {
        this.pb.pause();
    }

    public void resume() {
        this.pb.resume();
    }

    public void setPaint(Paint paint) {
        this.pb.setPaint(paint);
    }

    public void addCancelListener(ActionListener actionListener) {
        this.ggCancel.addActionListener(actionListener);
    }

    public void removeCancelListener(ActionListener actionListener) {
        this.ggCancel.removeActionListener(actionListener);
    }

    public Component getComponent() {
        return this;
    }

    public void resetProgression() {
        this.pb.reset();
        this.ggCancel.setEnabled(true);
    }

    public void setProgression(float f) {
        if (f >= 0.0f) {
            this.pb.setProgression(f);
        } else {
            this.pb.setIndeterminate(true);
        }
    }

    public void finishProgression(int n) {
        this.pb.finish(n);
        this.ggCancel.setEnabled(false);
    }

    public void setProgressionText(String string) {
        this.lb.setText(string);
    }

    public void displayError(Exception exception, String string) {
        GUIUtil.displayError((Component)this, (Exception)exception, (String)string);
    }

    public void showMessage(int n, String string) {
        System.out.println(string);
    }
}

