/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.Region;
import de.sciss.io.Span;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SeekEnjoyDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_CTRLFILE = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_FADETYPE = 2;
    private static final int PR_GAINTYPE = 3;
    private static final int PR_SORTING = 4;
    private static final int PR_MINCHUNK = 0;
    private static final int PR_CROSSFADE = 1;
    private static final int PR_TOLERANCE = 2;
    private static final int PR_GAIN = 3;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_CTRLFILE = "CtrlFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FADETYPE = "FadeType";
    private static final String PRN_MINCHUNK = "MinChunk";
    private static final String PRN_CROSSFADE = "CrossFade";
    private static final String PRN_TOLERANCE = "Tolerance";
    private static final String PRN_SORTING = "Sorting";
    private static final String[] TYPE_NAMES = new String[]{"Equal Energy", "Equal Power"};
    private static final int TYPE_ENERGY = 0;
    private static final int TYPE_POWER = 1;
    private static final String[] SORT_NAMES = new String[]{"Ascending", "Descending"};
    private static final int SORT_ASCEND = 0;
    private static final int SORT_DESCEND = 1;
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "CtrlFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 1, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "FadeType", "GainType", "Sorting"};
    private static final Param[] prPara = new Param[]{null, null, null, null};
    private static final String[] prParaName = new String[]{"MinChunk", "CrossFade", "Tolerance", "Gain"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_CTRLFILE = 1025;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_FADETYPE = 258;
    private static final int GG_GAINTYPE = 259;
    private static final int GG_SORTING = 260;
    private static final int GG_MINCHUNK = 512;
    private static final int GG_CROSSFADE = 513;
    private static final int GG_TOLERANCE = 514;
    private static final int GG_GAIN = 515;
    private static final int GG_CURRENTINFO = 2048;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_LENGTH = "Control file cannot be\nlonger than input file!";

    public SeekEnjoyDlg() {
        super("Seek + Enjoy");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SeekEnjoyDlg.static_pr.text = prText;
            SeekEnjoyDlg.static_pr.textName = prTextName;
            SeekEnjoyDlg.static_pr.intg = prIntg;
            SeekEnjoyDlg.static_pr.intgName = prIntgName;
            SeekEnjoyDlg.static_pr.para = prPara;
            SeekEnjoyDlg.static_pr.para[0] = new Param(50.0, 2);
            SeekEnjoyDlg.static_pr.para[1] = new Param(50.0, 18);
            SeekEnjoyDlg.static_pr.para[2] = new Param(3.0, 785);
            SeekEnjoyDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(SeekEnjoyDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(SeekEnjoyDlg.static_pr.para, 3);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select control file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Control file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField3.deriveFrom(pathFieldArray, "$D0$F0Enj$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 515, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 259, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Segmentation Settings", 1, 0));
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9]};
        ParamField paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Min. Chunk Length", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 512, null);
        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9], new ParamSpace(Constants.spaces[11])};
        paramSpaceArray2[2] = new ParamSpace(paramSpaceArray2[2].min, 50.0, paramSpaceArray2[2].inc, paramSpaceArray2[2].unit);
        ParamField paramField2 = new ParamField(paramSpaceArray2);
        paramField2.setReference(paramField);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Crossfades", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 513, null);
        ParamSpace[] paramSpaceArray3 = new ParamSpace[]{Constants.spaces[6], Constants.spaces[7]};
        ParamField paramField3 = new ParamField(paramSpaceArray3);
        paramField3.setReference(new Param(1.0, 1));
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_TOLERANCE, 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 514, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 0; n < TYPE_NAMES.length; ++n) {
            jComboBox.addItem(TYPE_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Crossfade Type", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 258, null);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setBackground(null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("# of Regions", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addTextField(jTextField, 2048, null);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < SORT_NAMES.length; ++n) {
            jComboBox2.addItem(SORT_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_SORTING, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 260, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block58: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            int[] nArray;
            float[] fArray4;
            float[][] fArray5;
            AudioFileDescr audioFileDescr;
            AudioFileDescr audioFileDescr2;
            AudioFileDescr audioFileDescr3;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            floatFileArray = null;
            fileArray = null;
            Param param = new Param(0.0, 2);
            float f = 1.0f;
            Param param2 = new Param(1.0, 1);
            float f2 = 0.0f;
            try {
                Region region;
                float f3;
                float f4;
                int n2;
                int n3;
                float f5;
                int n4;
                int n5;
                this.gui.stringToJTextField("", 2048);
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr3 = audioFile3.getDescr();
                int n6 = audioFileDescr3.channels;
                int n7 = (int)audioFileDescr3.length;
                if (n7 < 1 || n6 < 1) {
                    throw new EOFException("File is empty");
                }
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                audioFileDescr2 = audioFile2.getDescr();
                int n8 = audioFileDescr2.channels;
                int n9 = (int)audioFileDescr2.length;
                if (n9 < 1 || n8 < 1) {
                    throw new EOFException("File is empty");
                }
                if (n9 > n7) {
                    throw new IOException(ERR_LENGTH);
                }
                float f6 = (float)n9 / (float)n7;
                PathField pathField = (PathField)this.gui.getItemObj(1026);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(audioFileDescr3);
                pathField.fillStream(audioFileDescr);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block58;
                long l = 0L;
                long l2 = ((long)n7 << 1) + ((long)n9 << 1);
                if (this.pr.intg[3] == 0) {
                    fileArray = new File[n6];
                    floatFileArray = new FloatFile[n6];
                    for (n = 0; n < n6; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n6; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n7;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[3], (int)1, (Param)param2, null).value;
                }
                if (!this.threadRunning) break block58;
                fArray5 = new float[n8][8192];
                fArray4 = new float[n9];
                float[] fArray6 = new float[n9];
                nArray = new int[n9];
                int[] nArray2 = new int[n9];
                int[] nArray3 = new int[n9];
                for (n5 = 0; n5 < n9; ++n5) {
                    nArray[n5] = n5;
                }
                System.arraycopy(nArray, 0, nArray2, 0, n9);
                for (int i = 0; this.threadRunning && i < n9; i += n4) {
                    n4 = Math.min(8192, n9 - i);
                    audioFile2.readFrames(fArray5, 0, n4);
                    System.arraycopy(fArray5[0], 0, fArray4, i, n4);
                    this.setProgression((float)(l += (long)n4) / (float)l2);
                }
                if (!this.threadRunning) break block58;
                audioFile2.close();
                audioFile2 = null;
                float f7 = Float.NEGATIVE_INFINITY;
                float f8 = Float.POSITIVE_INFINITY;
                for (n5 = 0; n5 < n9; ++n5) {
                    f5 = fArray4[n5];
                    if (f5 < f8) {
                        f8 = f5;
                    }
                    if (!(f5 > f7)) continue;
                    f7 = f5;
                }
                float f9 = f8 != f7 ? 1.0f / (f7 - f8) : 1.0f;
                for (n5 = 0; n5 < n9; ++n5) {
                    fArray4[n5] = (fArray4[n5] - f8) * f9;
                }
                System.arraycopy(fArray4, 0, fArray6, 0, n9);
                Util.quickSortFloat(fArray6, nArray, n9);
                if (this.pr.intg[4] == 1) {
                    n5 = 0;
                    for (n3 = n9 - 1; n5 < n3; ++n5, --n3) {
                        f5 = fArray6[n5];
                        fArray6[n5] = fArray6[n3];
                        fArray6[n3] = f5;
                        n2 = nArray[n5];
                        nArray[n5] = nArray[n3];
                        nArray[n3] = n2;
                    }
                }
                System.arraycopy(nArray, 0, nArray3, 0, n9);
                Util.quickSortInt(nArray3, nArray2, n9);
                this.setProgression((float)(l += (long)n9) / (float)l2);
                double d = Param.transform((Param)this.pr.para[0], (int)2, null, null).value;
                d = AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr3, (double)d);
                int n10 = Math.max(1, (int)(Math.ceil(d * (double)f6) + 0.5));
                d = Param.transform((Param)this.pr.para[2], (int)1, (Param)new Param((double)1.0, (int)1), null).value;
                if (d > 1.0) {
                    f4 = (float)d;
                    f3 = (float)(1.0 / d);
                } else {
                    f3 = (float)d;
                    f4 = (float)(1.0 / d);
                }
                Vector<Region> vector = new Vector<Region>();
                fArray3 = new float[n6][8192];
                float[][] fArray7 = new float[n6][8192];
                int n11 = 0;
                while (true) {
                    if (n11 < n9 && nArray[n11] < 0) {
                        ++n11;
                        continue;
                    }
                    if (n11 == n9) break;
                    n5 = nArray[n11];
                    f5 = fArray6[n11];
                    f7 = f5 * f4;
                    f8 = f5 * f3;
                    n5 = Math.max(0, n5 - (n10 >> 1));
                    for (n3 = Math.min(n9, n5 + n10); n3 < n9 && fArray4[n3] <= f7 && fArray4[n3] >= f8 && nArray[nArray2[n3]] >= 0; ++n3) {
                    }
                    --n5;
                    while (n5 > 0 && fArray4[n5] <= f7 && fArray4[n5] >= f8 && nArray[nArray2[n5]] >= 0) {
                        --n5;
                    }
                    for (n2 = ++n5; n2 < n3; ++n2) {
                        nArray[nArray2[n2]] = -1;
                    }
                    n5 = (int)((float)n5 / f6 + 0.5f);
                    n3 = Math.max(n5, Math.min(n7, (int)((float)n3 / f6 + 0.5f)));
                    region = new Region(new Span((long)n5, (long)n3), null);
                    vector.addElement(region);
                }
                if (!this.threadRunning) break block58;
                this.gui.stringToJTextField(String.valueOf(vector.size()), 2048);
                n4 = 0;
                for (n5 = 1; n5 < vector.size(); ++n5) {
                    region = (Region)vector.elementAt(n5);
                    n4 = (int)((long)n4 + region.span.getLength());
                }
                l2 = (long)n4 * (long)(this.pr.intg[3] == 0 ? 3 : 2);
                d = this.getProgression();
                l = (long)((double)l2 * d / (1.0 - d));
                l2 += l;
                vector.addElement(new Region(new Span((long)n7, (long)n7), null));
                region = new Region(new Span(0L, 0L), null);
                Region region2 = (Region)vector.elementAt(0);
                n11 = 0;
                int n12 = 0;
                for (n5 = 1; n5 < vector.size(); ++n5) {
                    int n13;
                    long l3 = l;
                    Region region3 = region;
                    region = region2;
                    region2 = (Region)vector.elementAt(n5);
                    int n14 = n11;
                    n11 = 0;
                    for (n13 = n12; n13 > 0; n13 -= n4) {
                        n4 = Math.min(8192, n13);
                        audioFile3.seekFrame((long)n14 + region3.span.getStart());
                        audioFile3.readFrames(fArray7, 0, n4);
                        audioFile3.seekFrame((long)n11 + region.span.getStart());
                        audioFile3.readFrames(fArray3, 0, n4);
                        switch (this.pr.intg[2]) {
                            case 0: {
                                for (n = 0; n < n6; ++n) {
                                    fArray2 = fArray3[n];
                                    fArray = fArray7[n];
                                    n3 = 0;
                                    n2 = n11;
                                    while (n3 < n4) {
                                        f9 = (float)n2 / (float)n12;
                                        fArray[n3] = fArray2[n3] * f9 + fArray[n3] * (1.0f - f9);
                                        ++n3;
                                        ++n2;
                                    }
                                }
                                break;
                            }
                            case 1: {
                                for (n = 0; n < n6; ++n) {
                                    fArray2 = fArray3[n];
                                    fArray = fArray7[n];
                                    n3 = 0;
                                    n2 = n11;
                                    while (n3 < n4) {
                                        f9 = (float)n2 / (float)n12;
                                        float f10 = 1.0f - f9;
                                        fArray[n3] = fArray2[n3] * (1.0f - f10 * f10) + fArray[n3] * (1.0f - f9 * f9);
                                        ++n3;
                                        ++n2;
                                    }
                                }
                                break;
                            }
                        }
                        if (floatFileArray != null) {
                            for (n = 0; n < n6; ++n) {
                                fArray2 = fArray7[n];
                                for (n3 = 0; n3 < n4; ++n3) {
                                    f9 = Math.abs(fArray2[n3]);
                                    if (!(f9 > f2)) continue;
                                    f2 = f9;
                                }
                                floatFileArray[n].writeFloats(fArray2, 0, n4);
                            }
                        } else {
                            for (n = 0; n < n6; ++n) {
                                fArray2 = fArray7[n];
                                for (n3 = 0; n3 < n4; ++n3) {
                                    f9 = Math.abs(fArray2[n3]);
                                    int n15 = n3;
                                    fArray2[n15] = fArray2[n15] * f;
                                    if (!(f9 > f2)) continue;
                                    f2 = f9;
                                }
                            }
                            audioFile.writeFrames(fArray7, 0, n4);
                        }
                        n14 += n4;
                        n11 += n4;
                        this.setProgression((float)(l += (long)n4) / (float)l2);
                        if (this.threadRunning) continue;
                        break block58;
                    }
                    n3 = (int)region.span.getLength();
                    n2 = (int)region2.span.getLength();
                    int n16 = Math.min(n3, n2);
                    param.value = AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr3, (long)n16);
                    d = Param.transform((Param)this.pr.para[1], (int)2, (Param)param, null).value;
                    n12 = Math.min(Math.min(n2 >> 1, n3 - n11), (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr3, (double)d) + 0.5));
                    n13 = n3 - n12;
                    while (n11 < n13) {
                        n4 = Math.min(8192, n13 - n11);
                        audioFile3.readFrames(fArray7, 0, n4);
                        if (floatFileArray != null) {
                            for (n = 0; n < n6; ++n) {
                                fArray2 = fArray7[n];
                                for (n2 = 0; n2 < n4; ++n2) {
                                    f9 = Math.abs(fArray2[n2]);
                                    if (!(f9 > f2)) continue;
                                    f2 = f9;
                                }
                                floatFileArray[n].writeFloats(fArray2, 0, n4);
                            }
                        } else {
                            for (n = 0; n < n6; ++n) {
                                fArray2 = fArray7[n];
                                for (n2 = 0; n2 < n4; ++n2) {
                                    f9 = Math.abs(fArray2[n2]);
                                    int n17 = n2;
                                    fArray2[n17] = fArray2[n17] * f;
                                    if (!(f9 > f2)) continue;
                                    f2 = f9;
                                }
                            }
                            audioFile.writeFrames(fArray7, 0, n4);
                        }
                        n11 += n4;
                        this.setProgression((float)(l += (long)n4) / (float)l2);
                        if (this.threadRunning) continue;
                        break block58;
                    }
                    l = l3 + (long)n3 + (long)n3;
                }
                audioFile3.close();
                audioFile3 = null;
                if (this.pr.intg[3] == 0) {
                    f = (float)Param.transform((Param)this.pr.para[3], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                    this.normalizeAudioFile(floatFileArray, audioFile, fArray7, f, 1.0f);
                    for (n = 0; n < n6; ++n) {
                        floatFileArray[n].cleanUp();
                        floatFileArray[n] = null;
                        fileArray[n].delete();
                        fileArray[n] = null;
                    }
                }
                if (this.threadRunning) {
                    audioFile.close();
                    audioFile = null;
                    this.setProgression(1.0f);
                    this.handleClipping(f2 *= f);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr3 = null;
                audioFileDescr2 = null;
                audioFileDescr = null;
                fArray3 = null;
                fArray4 = null;
                fArray5 = null;
                nArray = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }
}

