/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.OpPanel;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.session.SpectPatch;
import java.util.Enumeration;
import javax.swing.JScrollPane;

public class SpectPatchDlg
extends ModulePanel {
    private SpectPatch doc;
    private static final int PR_DOC = 0;
    private static final String PRN_DOC = "Patcher";
    private static final String[] prText = new String[]{""};
    private static final String[] prTextName = new String[]{"Patcher"};
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private OpPanel gagaPanel = null;

    public SpectPatchDlg() {
        super("Spectral Patcher");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SpectPatchDlg.static_pr.text = prText;
            SpectPatchDlg.static_pr.textName = prTextName;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gagaPanel = new OpPanel(this);
        JScrollPane jScrollPane = new JScrollPane(this.gagaPanel);
        jScrollPane.putClientProperty("styleId", "nofocus");
        this.gui = new GUISupport();
        this.doc = new SpectPatch(this);
        this.initGUI(this, 6, jScrollPane);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        this.doc.clear();
        this.doc.load(Presets.valueToProperties(this.pr.text[0]));
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
        this.pr.text[0] = Presets.propertiesToValue(this.doc.save());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void process() {
        block10: {
            try {
                float f;
                boolean bl = true;
                this.doc.start();
                do {
                    try {
                        SpectPatchDlg spectPatchDlg = this;
                        synchronized (spectPatchDlg) {
                            this.wait(3000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    f = this.calcProg(this.doc.getOperators());
                    if (!(f >= 0.0f)) break block10;
                    this.setProgression(f);
                    if (this.doc.running) continue;
                    bl = false;
                } while (this.threadRunning && bl);
                f = this.calcProg(this.doc.getOperators());
                if (f >= 0.0f) {
                    this.setProgression(f);
                }
            }
            catch (Exception exception) {
                this.setError(exception);
            }
        }
        try {
            this.doc.stop();
            return;
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    protected float calcProg(Enumeration enumeration) {
        float f = 0.0f;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            f += ((Operator)enumeration.nextElement()).getProgress();
            ++n;
        }
        if (n > 0) {
            return f / (float)n;
        }
        return -1.0f;
    }

    public OpPanel getOpPanel() {
        return this.gagaPanel;
    }

    public SpectPatch getDoc() {
        return this.doc;
    }

    public boolean clear() {
        this.gagaPanel.clear();
        return true;
    }
}

