/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.TopPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class VectorDisplay
extends JComponent {
    private float[] vector;
    private final GeneralPath path = new GeneralPath();
    private Shape pathTrns;
    private TextLayout txtLay = null;
    private Rectangle2D txtBounds;
    private Dimension recentSize;
    private Image image = null;
    private static final Stroke strkLine = new BasicStroke(0.5f);
    private static final Paint pntArea = new Color(66, 94, 157, 127);
    private final Paint pntBg;
    private final Paint pntLine;
    private final Paint pntLabel;
    private final AffineTransform trnsScreenToVirtual = new AffineTransform();
    private final AffineTransform trnsVirtualToScreen = new AffineTransform();
    private float min = 0.0f;
    private float max = 1.0f;
    private boolean fillArea = true;
    private String label = null;
    private final Vector<TopPainter> collTopPainters = new Vector();

    public VectorDisplay() {
        this(new float[0]);
    }

    public VectorDisplay(float[] fArray) {
        this(fArray, UIManager.getBoolean("dark-skin"));
    }

    public VectorDisplay(boolean bl) {
        this(new float[0], bl);
    }

    public VectorDisplay(float[] fArray, boolean bl) {
        this.setOpaque(false);
        this.setMinimumSize(new Dimension(64, 16));
        this.recentSize = this.getMinimumSize();
        this.setVector(null, fArray);
        this.pntBg = bl ? Color.darkGray : Color.lightGray;
        this.pntLine = bl ? Color.lightGray : Color.black;
        this.pntLabel = bl ? new Color(255, 255, 255, 63) : new Color(0, 0, 0, 63);
    }

    public void setVector(Object object, float[] fArray) {
        this.vector = fArray;
        this.recalculatePath();
        this.repaint();
    }

    public float[] getVector() {
        return this.vector;
    }

    public void setMinMax(float f, float f2) {
        if (this.min != f || this.max != f2) {
            this.min = f;
            this.max = f2;
            this.repaint();
        }
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public void setFillArea(boolean bl) {
        if (this.fillArea != bl) {
            this.fillArea = bl;
            this.repaint();
        }
    }

    public void setLabel(String string) {
        if (this.label == null || string == null || !this.label.equals(string)) {
            this.txtLay = null;
            this.label = string;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (dimension.width != this.recentSize.width || dimension.height != this.recentSize.height) {
            this.recentSize = dimension;
            this.recalculateTransforms();
            this.recreateImage();
            this.redrawImage();
        } else if (this.pathTrns == null) {
            this.recalculateTransforms();
            this.recreateImage();
            this.redrawImage();
        }
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
        }
        if (!this.collTopPainters.isEmpty()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < this.collTopPainters.size(); ++i) {
                this.collTopPainters.get(i).paintOnTop(graphics2D);
            }
        }
    }

    public void addTopPainter(TopPainter topPainter) {
        if (!this.collTopPainters.contains(topPainter)) {
            this.collTopPainters.add(topPainter);
        }
    }

    public void removeTopPainter(TopPainter topPainter) {
        this.collTopPainters.remove(topPainter);
    }

    private void recreateImage() {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = this.createImage(this.recentSize.width, this.recentSize.height);
    }

    private void redrawImage() {
        if (this.image == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        graphics2D.setPaint(this.pntBg);
        graphics2D.fillRect(0, 0, this.image.getWidth(this), this.image.getHeight(this));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.fillArea) {
            graphics2D.setPaint(pntArea);
            graphics2D.fill(this.pathTrns);
        }
        graphics2D.setStroke(strkLine);
        graphics2D.setPaint(this.pntLine);
        graphics2D.draw(this.pathTrns);
        if (this.label != null) {
            graphics2D.setPaint(this.pntLabel);
            if (this.txtLay == null) {
                this.txtLay = new TextLayout(this.label, this.getFont(), graphics2D.getFontRenderContext());
                this.txtBounds = this.txtLay.getBounds();
            }
            this.txtLay.draw(graphics2D, (float)this.recentSize.width - (float)this.txtBounds.getWidth() - 4.0f, (float)this.recentSize.height - (float)this.txtBounds.getHeight());
        }
        graphics2D.dispose();
    }

    private void recalculatePath() {
        float f = (this.min - this.max) / (float)this.recentSize.height + this.min;
        this.path.reset();
        if (this.vector.length > 0) {
            float f2 = 1.0f / (float)this.vector.length;
            this.path.moveTo(-0.01f, f);
            this.path.lineTo(-0.01f, this.vector[0]);
            for (int i = 0; i < this.vector.length; ++i) {
                this.path.lineTo((float)i * f2, this.vector[i]);
            }
            this.path.lineTo(1.01f, this.vector[this.vector.length - 1]);
            this.path.lineTo(1.01f, f);
            this.path.closePath();
        }
        this.pathTrns = null;
    }

    private void recalculateTransforms() {
        this.trnsVirtualToScreen.setToTranslation(0.0, this.recentSize.height);
        this.trnsVirtualToScreen.scale(this.recentSize.width, (float)this.recentSize.height / (this.min - this.max));
        this.trnsVirtualToScreen.translate(0.0, -this.min);
        this.trnsScreenToVirtual.setToTranslation(0.0, this.min);
        this.trnsScreenToVirtual.scale(1.0 / (double)this.recentSize.width, (this.min - this.max) / (float)this.recentSize.height);
        this.trnsScreenToVirtual.translate(0.0, -this.recentSize.height);
        this.pathTrns = this.path.createTransformedShape(this.trnsVirtualToScreen);
    }

    public Point2D screenToVirtual(Point2D point2D) {
        return this.trnsScreenToVirtual.transform(point2D, null);
    }

    public Shape screenToVirtual(Shape shape) {
        return this.trnsScreenToVirtual.createTransformedShape(shape);
    }

    public Point2D virtualToScreen(Point2D point2D) {
        return this.trnsVirtualToScreen.transform(point2D, null);
    }

    public Shape virtualToScreen(Shape shape) {
        return this.trnsVirtualToScreen.createTransformedShape(shape);
    }

    public Rectangle virtualToScreenClip(Rectangle2D rectangle2D) {
        Point2D point2D = this.trnsVirtualToScreen.transform(new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY()), null);
        Point2D point2D2 = this.trnsVirtualToScreen.transform(new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY()), null);
        return new Rectangle((int)Math.floor(point2D.getX()), (int)Math.floor(point2D.getY()), (int)Math.ceil(point2D2.getX()), (int)Math.ceil(point2D2.getY()));
    }
}

