/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.io;

import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.io.ImageStream;
import de.sciss.fscape.io.TIFFentry;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ImageFile
extends GenericFile {
    public static final String ERR_PARALLEL = "Colour planes not interleaved";
    public static final String ERR_COMPRESSED = "Unsupported compression";
    private boolean suckyPCdata = false;
    private boolean invert = false;
    private long stripOffsetOffs = 0L;
    private int stripOffsetSize;
    private int rowsPerStrip;
    private int numStrips;
    private int bytesPerRow;
    private int stripNum = -1;
    private int stripLeft = 0;
    private byte[] buf = null;
    private int bufSize;
    private int bufOffset;
    protected ImageStream stream = null;
    protected static final int NEWSUBTYPE_TAG = 254;
    protected static final int SUBTYPE_TAG = 255;
    protected static final int WIDTH_TAG = 256;
    protected static final int HEIGHT_TAG = 257;
    protected static final int BITSPERSMP_TAG = 258;
    protected static final int CMPTYPE_TAG = 259;
    protected static final int PHOTOMETR_TAG = 262;
    protected static final int DESCR_TAG = 270;
    protected static final int STRIPOFFS_TAG = 273;
    protected static final int SMPPERPIXEL_TAG = 277;
    protected static final int ROWSPERSTRIP_TAG = 278;
    protected static final int STRIPCOUNT_TAG = 279;
    protected static final int XRES_TAG = 282;
    protected static final int YRES_TAG = 283;
    protected static final int PLANE_TAG = 284;
    protected static final int RESUNIT_TAG = 296;
    protected static final int CMPTYPE_NONE = 1;
    protected static final int CMPTYPE_LZW = 5;
    protected static final int NEWSUBTYPE_THUMB = 1;
    protected static final int NEWSUBTYPE_TRANSP = 4;
    protected static final int SUBTYPE_THUMB = 2;
    protected static final int PHOTOMETR_GRAYINV = 0;
    protected static final int PHOTOMETR_GRAY = 1;
    protected static final int PHOTOMETR_RGB = 2;
    protected static final int PLANE_SERIAL = 1;
    protected static final int PLANE_PARALLEL = 2;
    protected static final int RESUNIT_NONE = 1;
    protected static final int RESUNIT_INCH = 2;
    protected static final int RESUNIT_CM = 3;

    public ImageFile(File file, int n) throws IOException {
        super(file, n & 0xFFFF000F | 0x10);
    }

    public ImageFile(String string, int n) throws IOException {
        this(new File(string), n);
    }

    public ImageStream initReader() throws IOException {
        if (this.stream == null) {
            this.stream = new ImageStream();
            this.readHeader();
            this.bufSize = 131072;
            this.bufSize -= this.bufSize % this.bytesPerRow;
            this.buf = new byte[Math.max(this.bytesPerRow, this.bufSize)];
        }
        this.stripNum = -1;
        this.stripLeft = 0;
        this.bufOffset = this.bufSize;
        return this.stream;
    }

    public void initWriter(ImageStream imageStream) throws IOException {
        this.stream = imageStream;
        this.bytesPerRow = imageStream.width * imageStream.smpPerPixel * (imageStream.bitsPerSmp + 7 >> 3);
        this.suckyPCdata = false;
        this.invert = false;
        this.rowsPerStrip = imageStream.height;
        this.numStrips = 1;
        this.bufSize = 131072;
        this.bufSize -= this.bufSize % this.bytesPerRow;
        this.buf = new byte[Math.max(this.bytesPerRow, this.bufSize)];
        this.bufOffset = 0;
        this.writeHeader();
    }

    public byte[] allocRow() {
        return new byte[this.stream.width * this.stream.smpPerPixel * (this.stream.bitsPerSmp + 7 >> 3)];
    }

    protected void seekNewStrip() throws IOException {
        ++this.stripNum;
        if (this.stripNum >= this.numStrips) {
            throw new EOFException();
        }
        if (this.stripOffsetSize == 4) {
            this.seek(this.stripOffsetOffs + (long)(this.stripNum << 2));
            this.seek(this.readUniversalInt());
        } else {
            this.seek(this.stripOffsetOffs + (long)this.stripNum << 1);
            this.seek(this.readUniversalUShort());
        }
        this.stripLeft = this.bytesPerRow * this.rowsPerStrip;
    }

    public void readRow(byte[] byArray) throws IOException {
        int n;
        if (this.bufOffset >= this.bufSize) {
            if (this.stripLeft == 0) {
                this.seekNewStrip();
            }
            int n2 = Math.min(this.bufSize, this.stripLeft);
            this.readFully(this.buf, this.bufSize - n2, n2);
            this.bufOffset = this.bufSize - n2;
            this.stripLeft -= n2;
            if (this.suckyPCdata && this.stream.bitsPerSmp == 16) {
                for (n = 0; n < this.bufSize; n += 2) {
                    byte by = byArray[n];
                    byArray[n] = byArray[n + 1];
                    byArray[n + 1] = by;
                }
            }
        }
        System.arraycopy(this.buf, this.bufOffset, byArray, 0, byArray.length);
        this.bufOffset += byArray.length;
        ++this.stream.rowsRead;
        if (this.invert) {
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = ~byArray[n];
            }
        }
    }

    public void writeRow(byte[] byArray) throws IOException {
        if (this.bufOffset >= this.bufSize) {
            this.write(this.buf);
            this.bufOffset = 0;
        }
        System.arraycopy(byArray, 0, this.buf, this.bufOffset, byArray.length);
        this.bufOffset += byArray.length;
        ++this.stream.rowsWritten;
    }

    @Override
    public void close() throws IOException {
        this.stream = null;
        int n = this.bufOffset;
        this.bufOffset = 0;
        byte[] byArray = this.buf;
        this.buf = null;
        if ((this.mode & 0xF) == 1 && byArray != null && n > 0) {
            this.write(byArray, 0, n);
        }
        super.close();
    }

    @Override
    public String getFormat() throws IOException {
        ImageStream imageStream = this.stream;
        if (imageStream == null) {
            imageStream = this.initReader();
        }
        return ImageStream.getFormat(imageStream);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readHeader() throws IOException {
        int n;
        TIFFentry tIFFentry = new TIFFentry();
        this.seek(0L);
        int n2 = this.readInt();
        switch (n2) {
            case 1296891946: {
                this.suckyPCdata = false;
                break;
            }
            case 1229520938: {
                this.suckyPCdata = true;
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Unsupported file format");
            }
        }
        this.mode = this.mode & 0xFFFF000F | 0x10;
        do {
            int n3;
            int n4;
            if ((n4 = this.readUniversalInt()) == 0) {
                throw new UnsupportedEncodingException("Essential data missing");
            }
            this.seek(n4);
            this.invert = false;
            boolean bl = true;
            this.stream.hRes = 0.013888889f;
            this.stream.hRes = 0.013888889f;
            this.stream.resUnit = 2;
            this.stream.bitsPerSmp = 1;
            this.stream.smpPerPixel = 1;
            int n5 = this.readUniversalUShort();
            n = 5;
            block28: for (n3 = 0; n3 < n5; ++n3) {
                this.readTIFFentry(tIFFentry);
                block4 : switch (tIFFentry.tag) {
                    case 254: {
                        if (tIFFentry.value != 1 && tIFFentry.value != 4) break;
                        break block28;
                    }
                    case 255: {
                        if (tIFFentry.value != 2) break;
                        break block28;
                    }
                    case 259: {
                        if (tIFFentry.value == 1) break;
                        throw new UnsupportedEncodingException(ERR_COMPRESSED);
                    }
                    case 256: {
                        --n;
                        this.stream.width = tIFFentry.value;
                        break;
                    }
                    case 257: {
                        --n;
                        this.stream.height = tIFFentry.value;
                        break;
                    }
                    case 282: {
                        this.stream.hRes = Float.intBitsToFloat(tIFFentry.value);
                        break;
                    }
                    case 283: {
                        this.stream.vRes = Float.intBitsToFloat(tIFFentry.value);
                        break;
                    }
                    case 296: {
                        this.stream.resUnit = tIFFentry.value & 3;
                        break;
                    }
                    case 258: {
                        if (tIFFentry.count == 1) {
                            this.stream.bitsPerSmp = tIFFentry.value;
                        } else {
                            long l = this.getFilePointer();
                            this.seek(tIFFentry.value);
                            int n6 = 0;
                            for (int i = 0; i < tIFFentry.count; ++i) {
                                this.stream.bitsPerSmp = this.readUniversalUShort();
                                if (i > 0 & n6 != this.stream.bitsPerSmp) {
                                    throw new UnsupportedEncodingException("Unsupported encoding");
                                }
                                n6 = this.stream.bitsPerSmp;
                            }
                            this.seek(l);
                        }
                        if (this.stream.bitsPerSmp == 8 || this.stream.bitsPerSmp == 16) break;
                        throw new UnsupportedEncodingException("Unsupported encoding");
                    }
                    case 277: {
                        if (tIFFentry.value < 1 || bl && tIFFentry.value != 1) {
                            throw new UnsupportedEncodingException("File is corrupted");
                        }
                        this.stream.smpPerPixel = tIFFentry.value;
                        break;
                    }
                    case 262: {
                        --n;
                        switch (tIFFentry.value) {
                            case 1: {
                                bl = true;
                                this.invert = false;
                                break block4;
                            }
                            case 0: {
                                bl = true;
                                this.invert = true;
                                break block4;
                            }
                            case 2: {
                                bl = false;
                                this.invert = false;
                                break block4;
                            }
                        }
                        throw new UnsupportedEncodingException("Unsupported encoding");
                    }
                    case 270: {
                        this.stream.descr = this.readTIFFstring(tIFFentry);
                        break;
                    }
                    case 273: {
                        --n;
                        if (tIFFentry.count == 1) {
                            this.stripOffsetOffs = this.getFilePointer() - 4L;
                            this.stripOffsetSize = 4;
                            break;
                        }
                        this.stripOffsetOffs = tIFFentry.value;
                        this.stripOffsetSize = tIFFentry.type;
                        break;
                    }
                    case 278: {
                        --n;
                        this.rowsPerStrip = tIFFentry.value;
                        this.numStrips = (this.stream.height + this.rowsPerStrip - 1) / this.rowsPerStrip;
                        this.bytesPerRow = this.stream.width * this.stream.smpPerPixel * (this.stream.bitsPerSmp + 7 >> 3);
                        break;
                    }
                    case 279: {
                        if (tIFFentry.count != 1) break;
                        break;
                    }
                    case 284: {
                        if (tIFFentry.value == 2) {
                            throw new UnsupportedEncodingException(ERR_PARALLEL);
                        }
                        if (tIFFentry.value == 1) break;
                        throw new UnsupportedEncodingException("Unsupported encoding");
                    }
                }
            }
            if (n3 == n5 && n > 0) {
                throw new UnsupportedEncodingException("Essential data missing");
            }
            if (n3 >= n5) continue;
            this.seek(this.getFilePointer() + (long)(12 * (n5 - n3)));
        } while (n > 0);
    }

    protected int readUniversalUShort() throws IOException {
        if (!this.suckyPCdata) {
            return this.readUnsignedShort();
        }
        int n = this.readUnsignedShort();
        return (n & 0xFF) << 8 | (n & 0xFF00) >> 8;
    }

    protected int readUniversalInt() throws IOException {
        if (!this.suckyPCdata) {
            return this.readInt();
        }
        int n = this.readInt();
        return (int)(((long)n & 0xFFFFFFFFFF000000L) >> 24 | (long)((n & 0xFF0000) >> 8) | (long)((n & 0xFF00) << 8) | (long)((n & 0xFF) << 24));
    }

    protected void readTIFFentry(TIFFentry tIFFentry) throws IOException {
        tIFFentry.tag = this.readUniversalUShort();
        tIFFentry.type = this.readUniversalUShort();
        tIFFentry.count = this.readUniversalInt();
        tIFFentry.value = this.readUniversalInt();
        switch (tIFFentry.type) {
            case 1: {
                if (tIFFentry.count != 1) break;
                tIFFentry.value = tIFFentry.value >> 24 & 0xFF;
                break;
            }
            case 3: {
                if (tIFFentry.count != 1) break;
                tIFFentry.value = tIFFentry.value >> 16 & 0xFFFF;
                break;
            }
            case 5: {
                if (tIFFentry.count != 1) break;
                long l = this.getFilePointer();
                this.seek(tIFFentry.value);
                long l2 = this.readLong();
                this.seek(l);
                tIFFentry.value = Float.floatToIntBits((float)(l2 >> 32) / (float)(l2 & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
        }
    }

    protected void writeTIFFentry(int n, int n2, int n3, int n4) throws IOException {
        this.writeShort(n);
        this.writeShort(n2);
        this.writeInt(n3);
        if (n3 == 1) {
            if (n2 == 3) {
                n4 <<= 16;
            } else if (n2 == 1) {
                n4 <<= 24;
            }
        }
        this.writeInt(n4);
    }

    protected String readTIFFstring(TIFFentry tIFFentry) throws IOException {
        byte[] byArray = new byte[tIFFentry.count - 1];
        long l = this.getFilePointer();
        this.seek(tIFFentry.value);
        this.readFully(byArray);
        this.seek(l);
        return new String(byArray);
    }

    private void writeHeader() throws IOException {
        int n = this.stream.smpPerPixel == 1 ? 13 : 14;
        String string = this.stream.descr != null ? this.stream.descr : "";
        int n2 = 30 + (string.length() + 2) & 0xFFFFFFFE;
        this.seek(0L);
        this.writeInt(1296891946);
        this.writeInt(n2);
        this.writeInt((int)(this.stream.hRes * 10000.0f));
        this.writeInt(10000);
        this.writeInt((int)(this.stream.vRes * 10000.0f));
        this.writeInt(10000);
        this.writeShort(this.stream.bitsPerSmp);
        this.writeShort(this.stream.bitsPerSmp);
        this.writeShort(this.stream.bitsPerSmp);
        if (string.length() > 0) {
            this.writeBytes(string);
        }
        if ((this.getFilePointer() & 1L) == 0L) {
            this.writeShort(0);
        } else {
            this.writeByte(0);
        }
        this.writeShort(n);
        block16: for (int i = 254; i <= 296; ++i) {
            switch (i) {
                case 254: {
                    this.writeTIFFentry(i, 4, 1, 0);
                    continue block16;
                }
                case 256: {
                    this.writeTIFFentry(i, 4, 1, this.stream.width);
                    continue block16;
                }
                case 257: 
                case 278: {
                    this.writeTIFFentry(i, 4, 1, this.stream.height);
                    continue block16;
                }
                case 273: {
                    this.writeTIFFentry(i, 4, 1, n2 + n * 12 + 4);
                    continue block16;
                }
                case 279: {
                    this.writeTIFFentry(i, 4, 1, this.bytesPerRow * this.stream.height);
                    continue block16;
                }
                case 282: {
                    this.writeTIFFentry(i, 5, 1, 8);
                    continue block16;
                }
                case 283: {
                    this.writeTIFFentry(i, 5, 1, 16);
                    continue block16;
                }
                case 296: {
                    this.writeTIFFentry(i, 3, 1, this.stream.resUnit);
                    continue block16;
                }
                case 277: {
                    this.writeTIFFentry(i, 3, 1, this.stream.smpPerPixel);
                    continue block16;
                }
                case 258: {
                    this.writeTIFFentry(i, 3, this.stream.smpPerPixel, this.stream.smpPerPixel == 1 ? this.stream.bitsPerSmp : 24);
                    continue block16;
                }
                case 259: {
                    this.writeTIFFentry(i, 3, 1, 1);
                    continue block16;
                }
                case 262: {
                    this.writeTIFFentry(i, 3, 1, this.stream.smpPerPixel == 1 ? 1 : 2);
                    continue block16;
                }
                case 284: {
                    if (this.stream.smpPerPixel != 3) continue block16;
                    this.writeTIFFentry(i, 3, 1, 1);
                    continue block16;
                }
                case 270: {
                    if (string.length() <= 0) continue block16;
                    this.writeTIFFentry(i, 2, string.length() + 1, 30);
                    continue block16;
                }
            }
        }
        this.writeShort(0);
    }
}

