/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import java.io.EOFException;
import java.io.IOException;

public class ConvOp
extends Operator {
    protected static final String defaultName = "Convolve";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT1 = 0;
    protected static final int SLOT_INPUT2 = 1;
    protected static final int SLOT_OUTPUT = 2;
    private static final int PR_MODE = 0;
    private static final String PRN_MODE = "Mode";
    protected static final int MODE_CIRCLE = 0;
    protected static final int MODE_EXPAND = 1;
    protected static final int MODE_MULT = 2;
    private static final int[] prIntg = new int[]{0};
    private static final String[] prIntgName = new String[]{"Mode"};

    public ConvOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), ConvOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ConvOp.static_pr.intg = prIntg;
            ConvOp.static_pr.intgName = prIntgName;
            ConvOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "ConvOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16, "in1"));
        this.slots.addElement(new SpectStreamSlot(this, 16, "in2"));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block30: {
            this.runInit();
            SpectStreamSlot[] spectStreamSlotArray = new SpectStreamSlot[2];
            SpectStream[] spectStreamArray = new SpectStream[2];
            SpectFrame[] spectFrameArray = new SpectFrame[2];
            int[] nArray = new int[2];
            float[][] fArrayArray = new float[2][];
            try {
                int n;
                boolean bl;
                int n2;
                for (n2 = 0; n2 < 2; ++n2) {
                    spectStreamSlotArray[n2] = (SpectStreamSlot)this.slots.elementAt(0 + n2);
                    if (spectStreamSlotArray[n2].getLinked() == null) {
                        this.runStop();
                    }
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamArray[n2] = spectStreamSlotArray[n2].getDescr();
                            bl = true;
                            nArray[n2] = spectStreamArray[n2].bands;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                if (this.threadDead) break block30;
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(2);
                SpectStream spectStream = new SpectStream(spectStreamArray[0]);
                if (this.pr.intg[0] == 1) {
                    n2 = nArray[0] + nArray[1] - 2;
                    for (n = 2; n < n2; n <<= 1) {
                    }
                    spectStream.smpPerFrame = (int)((float)spectStream.smpPerFrame * ((float)(++n - 1) / (float)(nArray[0] - 1)));
                } else {
                    n = nArray[0];
                }
                spectStream.bands = n;
                spectStreamSlot.initWriter(spectStream);
                int n3 = n - 1;
                int n4 = n3 << 1;
                if (this.pr.intg[0] != 2) {
                    fArrayArray[0] = new float[n4];
                    fArrayArray[1] = new float[n4];
                }
                this.runSlotsReady();
                block15: while (!this.threadDead) {
                    int n5;
                    int n6;
                    int n7 = 0;
                    while (n7 < 2 && !this.threadDead) {
                        int n8 = n7;
                        for (n2 = 0; n2 < 2; ++n2) {
                            block31: {
                                try {
                                    if (spectStreamArray[n2].framesReadable() <= 0) break block31;
                                    spectFrameArray[n2] = spectStreamSlotArray[n2].readFrame();
                                    ++n7;
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (EOFException eOFException) {
                                    break block15;
                                }
                            }
                            this.runCheckPause();
                        }
                        if (n8 != n7) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    SpectFrame spectFrame = spectStream.allocFrame();
                    if (this.pr.intg[0] == 2) {
                        for (n6 = 0; n6 < spectStream.chanNum; ++n6) {
                            float[] fArray = spectFrameArray[0].data[n6 % spectStreamArray[0].chanNum];
                            float[] fArray2 = spectFrame.data[n6];
                            System.arraycopy(fArray, 0, fArray2, 0, nArray[0] << 1);
                            n5 = Math.min(n4 + 2, nArray[1] << 1);
                            fArray = spectFrameArray[1].data[n6 % spectStreamArray[1].chanNum];
                            for (n2 = 0; n2 < n5; ++n2) {
                                int n9 = n2;
                                fArray2[n9] = fArray2[n9] * fArray[n2];
                                int n10 = ++n2;
                                fArray2[n10] = fArray2[n10] + fArray[n2];
                            }
                        }
                    } else {
                        for (n6 = 0; n6 < spectStream.chanNum; ++n6) {
                            for (n2 = 0; n2 < 2; ++n2) {
                                n5 = Math.min(n4, nArray[n2] - 1 << 1);
                                Fourier.polar2Rect(spectFrameArray[n2].data[n6 % spectStreamArray[n2].chanNum], 0, fArrayArray[n2], 0, n5);
                                for (int i = n5; i < n4; ++i) {
                                    fArrayArray[n2][i] = 0.0f;
                                }
                                Fourier.complexTransform(fArrayArray[n2], n3, 1);
                            }
                            Fourier.complexMult(fArrayArray[0], 0, fArrayArray[1], 0, fArrayArray[1], 0, n4);
                            Fourier.complexTransform(fArrayArray[1], n3, -1);
                            Fourier.rect2Polar(fArrayArray[1], 0, spectFrame.data[n6], 0, n4);
                            spectFrame.data[n6][n4] = 0.0f;
                            spectFrame.data[n6][n4 + 1] = 0.0f;
                        }
                    }
                    spectStreamSlotArray[0].freeFrame(spectFrameArray[0]);
                    spectStreamSlotArray[1].freeFrame(spectFrameArray[1]);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot.writeFrame(spectFrame);
                            bl = true;
                            this.runFrameDone(spectStreamSlot, spectFrame);
                            spectStream.freeFrame(spectFrame);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStreamArray[0].closeReader();
                spectStreamArray[1].closeReader();
                spectStream.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbMode;ch,prMode,itCircular conv,itExpanding conv,itMultiplication");
        return propertyGUI;
    }
}

