/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Modulator;
import de.sciss.fscape.util.Param;
import java.io.EOFException;
import java.io.IOException;

public class FlipFreqOp
extends Operator {
    protected static final String defaultName = "Flip freq";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_FLIPFREQ = 0;
    private static final int PR_MIDMOD = 1;
    private static final int PR_SHIFTMOD = 2;
    private static final int PR_HIMOD = 3;
    private static final int PR_LOMOD = 4;
    private static final int PR_MIDFREQ = 0;
    private static final int PR_SHIFTFREQ = 1;
    private static final int PR_HIFREQ = 2;
    private static final int PR_LOFREQ = 3;
    private static final int PR_MIDMODDEPTH = 4;
    private static final int PR_SHIFTMODDEPTH = 5;
    private static final int PR_HIMODDEPTH = 6;
    private static final int PR_LOMODDEPTH = 7;
    private static final int PR_MIDMODENV = 0;
    private static final int PR_SHIFTMODENV = 1;
    private static final int PR_HIMODENV = 2;
    private static final int PR_LOMODENV = 3;
    private static final String PRN_FLIPFREQ = "FlipFreq";
    private static final String PRN_MIDFREQ = "MidFreq";
    private static final String PRN_SHIFTFREQ = "ShiftFreq";
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_MIDMOD = "MidMod";
    private static final String PRN_SHIFTMOD = "ShiftMod";
    private static final String PRN_HIMOD = "HiMod";
    private static final String PRN_LOMOD = "LoMod";
    private static final String PRN_MIDMODDEPTH = "MidModDepth";
    private static final String PRN_SHIFTMODDEPTH = "ShiftModDepth";
    private static final String PRN_HIMODDEPTH = "HiModDepth";
    private static final String PRN_LOMODDEPTH = "LoModDepth";
    private static final String PRN_MIDMODENV = "MidModEnv";
    private static final String PRN_SHIFTMODENV = "ShiftModEnv";
    private static final String PRN_HIMODENV = "HiModEnv";
    private static final String PRN_LOMODENV = "LoModEnv";
    private static final String PRN_CALCTYPE = "CalcType";
    private static final int PR_CALCTYPE_FREQRANGE = 1;
    private static final boolean[] prBool = new boolean[]{true, false, false, false, false};
    private static final String[] prBoolName = new String[]{"FlipFreq", "MidMod", "ShiftMod", "HiMod", "LoMod"};
    private static final int[] prIntg = new int[]{1};
    private static final String[] prIntgName = new String[]{"CalcType"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"MidFreq", "ShiftFreq", "HiFreq", "LoFreq", "MidModDepth", "ShiftModDepth", "HiModDepth", "LoModDepth"};
    private static final Envelope[] prEnvl = new Envelope[]{null, null, null, null};
    private static final String[] prEnvlName = new String[]{"MidModEnv", "ShiftModEnv", "HiModEnv", "LoModEnv"};

    public FlipFreqOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), FlipFreqOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            FlipFreqOp.static_pr.bool = prBool;
            FlipFreqOp.static_pr.boolName = prBoolName;
            FlipFreqOp.static_pr.intg = prIntg;
            FlipFreqOp.static_pr.intgName = prIntgName;
            FlipFreqOp.static_pr.para = prPara;
            FlipFreqOp.static_pr.para[0] = new Param(1760.0, 3);
            FlipFreqOp.static_pr.para[1] = new Param(0.0, 35);
            FlipFreqOp.static_pr.para[2] = new Param(7040.0, 3);
            FlipFreqOp.static_pr.para[3] = new Param(0.0, 3);
            FlipFreqOp.static_pr.para[4] = new Param(12.0, 547);
            FlipFreqOp.static_pr.para[5] = new Param(12.0, 547);
            FlipFreqOp.static_pr.para[6] = new Param(12.0, 547);
            FlipFreqOp.static_pr.para[7] = new Param(12.0, 547);
            FlipFreqOp.static_pr.paraName = prParaName;
            FlipFreqOp.static_pr.envl = prEnvl;
            FlipFreqOp.static_pr.envl[0] = Envelope.createBasicEnvelope(0);
            FlipFreqOp.static_pr.envl[1] = Envelope.createBasicEnvelope(0);
            FlipFreqOp.static_pr.envl[2] = Envelope.createBasicEnvelope(0);
            FlipFreqOp.static_pr.envl[3] = Envelope.createBasicEnvelope(0);
            FlipFreqOp.static_pr.envlName = prEnvlName;
            FlipFreqOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "FlipFreqOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block46: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            boolean bl = true;
            Modulator modulator = null;
            Modulator modulator2 = null;
            Modulator modulator3 = null;
            Modulator modulator4 = null;
            try {
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                int n = 0;
                while (n == 0 && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        n = 1;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block46;
                int[] nArray = new int[spectStream.bands + 1];
                float[] fArray = new float[spectStream.bands + 1];
                double d = (spectStream.hiFreq - spectStream.loFreq) / (float)spectStream.bands;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                int n2 = this.pr.bool[0] ? -1 : 1;
                Param param = Param.transform(this.pr.para[0], 3, null, spectStream);
                Param param2 = Param.transform(this.pr.para[1], 3, param, spectStream);
                Param param3 = Param.transform(this.pr.para[2], 3, param, spectStream);
                Param param4 = Param.transform(this.pr.para[3], 3, param, spectStream);
                Param param5 = param;
                Param param6 = param2;
                Param param7 = param3;
                Param param8 = param4;
                if (this.pr.bool[1]) {
                    modulator = new Modulator(param, this.pr.para[4], this.pr.envl[0], spectStream);
                }
                if (this.pr.bool[2]) {
                    modulator2 = new Modulator(param2, this.pr.para[5], this.pr.envl[1], spectStream);
                }
                if (this.pr.bool[3]) {
                    modulator3 = new Modulator(param3, this.pr.para[6], this.pr.envl[2], spectStream);
                }
                if (this.pr.bool[4]) {
                    modulator4 = new Modulator(param4, this.pr.para[7], this.pr.envl[3], spectStream);
                }
                this.runSlotsReady();
                block11: while (!this.threadDead) {
                    Param param9;
                    if (this.pr.bool[1]) {
                        param9 = modulator.calc();
                        if (Math.abs(param9.value - param5.value) >= 0.1) {
                            param5 = param9;
                            bl = true;
                        }
                    }
                    if (this.pr.bool[2]) {
                        param9 = modulator2.calc();
                        if (Math.abs(param9.value - param6.value) >= 0.1) {
                            param6 = param9;
                            bl = true;
                        }
                    }
                    if (this.pr.bool[3]) {
                        param9 = modulator3.calc();
                        if (Math.abs(param9.value - param7.value) >= 0.1) {
                            param7 = param9;
                            bl = true;
                        }
                    }
                    if (this.pr.bool[4]) {
                        param9 = modulator4.calc();
                        if (Math.abs(param9.value - param8.value) >= 0.1) {
                            param8 = param9;
                            bl = true;
                        }
                    }
                    n = 0;
                    while (n == 0 && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            n = 1;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block11;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    if (bl) {
                        float f;
                        double d2;
                        double d3;
                        double d4 = Math.max(1.0, param5.value - param8.value);
                        double d5 = Math.max(1.0, param7.value - param5.value);
                        double d6 = d4 / d5;
                        double d7 = d5 / d4;
                        if (this.pr.bool[0]) {
                            for (n = 0; n <= spectStream.bands; ++n) {
                                d3 = (double)n * d + (double)spectStream2.loFreq - param6.value;
                                d2 = d3 >= param5.value ? param5.value - (d3 - param5.value) * d6 : (param5.value - d3) * d7 + param5.value;
                                f = (float)((d2 - (double)spectStream.loFreq) / d);
                                nArray[n] = (int)Math.floor(f);
                                fArray[n] = f - (float)nArray[n];
                            }
                        } else {
                            for (n = 0; n <= spectStream.bands; ++n) {
                                d3 = (double)n * d + (double)spectStream2.loFreq + param6.value;
                                d2 = d3 >= param5.value ? (d3 - param5.value) * d7 + param5.value : param5.value - (param5.value - d3) * d6;
                                f = (float)((d2 - (double)spectStream.loFreq) / d);
                                nArray[n] = (int)Math.floor(f);
                                fArray[n] = f - (float)nArray[n];
                            }
                        }
                        bl = false;
                    }
                    for (n = 0; n < spectStream.bands; ++n) {
                        int n3;
                        float f;
                        float f2;
                        int n4 = nArray[n];
                        int n5 = nArray[n + 1];
                        if (n4 > n5) {
                            n4 = nArray[n + 1];
                            n5 = nArray[n];
                            f2 = 1.0f - fArray[n + 1];
                            f = fArray[n];
                        } else {
                            f2 = 1.0f - fArray[n];
                            f = fArray[n + 1];
                        }
                        if (n4 < 0) {
                            n4 = 0;
                            if (n4 < n5) {
                                f2 = 1.0f;
                            } else {
                                for (n3 = 0; n3 < spectStream.chanNum; ++n3) {
                                    spectFrame2.data[n3][(n << 1) + 0] = 0.0f;
                                    spectFrame2.data[n3][(n << 1) + 1] = 0.0f;
                                }
                                continue;
                            }
                        }
                        if (n5 >= spectStream.bands) {
                            n5 = spectStream.bands - 1;
                            if (n5 > n4) {
                                f = 1.0f;
                            } else {
                                for (n3 = 0; n3 < spectStream.chanNum; ++n3) {
                                    spectFrame2.data[n3][(n << 1) + 0] = 0.0f;
                                    spectFrame2.data[n3][(n << 1) + 1] = 0.0f;
                                }
                                continue;
                            }
                        }
                        if (n4 == n5) {
                            f2 = f - (1.0f - f2);
                            f = 0.0f;
                        }
                        for (n3 = 0; n3 < spectStream.chanNum; ++n3) {
                            float f3 = spectFrame.data[n3][(n4 << 1) + 0];
                            float f4 = spectFrame.data[n3][(n4 << 1) + 1];
                            double d8 = (double)f3 * Math.sin(f4) * (double)f2;
                            double d9 = (double)f3 * Math.cos(f4) * (double)f2;
                            for (int i = n4 + 1; i < n5; ++i) {
                                f3 = spectFrame.data[n3][(i << 1) + 0];
                                f4 = spectFrame.data[n3][(i << 1) + 1];
                                d8 += (double)f3 * Math.sin(f4);
                                d9 += (double)f3 * Math.cos(f4);
                            }
                            f3 = spectFrame.data[n3][(n5 << 1) + 0];
                            f4 = spectFrame.data[n3][(n5 << 1) + 1];
                            spectFrame2.data[n3][(n << 1) + 0] = (float)Math.sqrt((d8 += (double)f3 * Math.sin(f4) * (double)f) * d8 + (d9 += (double)f3 * Math.cos(f4) * (double)f) * d9);
                            spectFrame2.data[n3][(n << 1) + 1] = (float)n2 * (float)Math.atan2(d8, d9);
                        }
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    n = 0;
                    while (n == 0 && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            n = 1;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\ncbFreq bands upside-down,prFlipFreq\nlbMiddle frequency;pf15,id1,prMidFreq\nlbPost freq shift;pf20|18|19,re1,id2,prShiftFreq\nglCalculation\nlbScaling;ch,prCalcType,itby factor,itby freq range\nlbHigh frequency;pf15|20|18|19,re1,id3,prHiFreq\nlbLow frequency;pf15|20|18|19,re1,id4,prLoFreq\nglModulation\ncbMiddle freq,actrue|5|en|6|en,acfalse|5|di|6|di,prMidMod;pf20|18|19,re1,id5,prMidModDepth;en,id6,prMidModEnv\ncbShift freq,actrue|7|en|8|en,acfalse|7|di|8|di,prShiftMod;pf20|18|19,re2,id7,prShiftModDepth;en,id8,prShiftModEnv\ncbHigh freq,actrue|9|en|10|en,acfalse|9|di|10|di,prHiMod;pf20|18|19,re3,id9,prHiModDepth;en,id10,prHiModEnv\ncbLow freq,actrue|11|en|12|en,acfalse|11|di|12|di,prLoMod;pf20|18|19,re4,id11,prLoModDepth;en,id12,prLoModEnv");
        return propertyGUI;
    }
}

