/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Param;
import java.io.EOFException;
import java.io.IOException;
import java.util.Random;

public class LogFreqOp
extends Operator {
    protected static final String defaultName = "Log freq";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_RANDPHASE = 0;
    private static final int PR_HIFREQ = 0;
    private static final int PR_LOFREQ = 1;
    private static final String PRN_RANDPHASE = "RandPhase";
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"RandPhase"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"HiFreq", "LoFreq"};

    public LogFreqOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), LogFreqOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            LogFreqOp.static_pr.bool = prBool;
            LogFreqOp.static_pr.boolName = prBoolName;
            LogFreqOp.static_pr.para = prPara;
            LogFreqOp.static_pr.para[0] = new Param(18000.0, 3);
            LogFreqOp.static_pr.para[1] = new Param(32.0, 3);
            LogFreqOp.static_pr.paraName = prParaName;
            LogFreqOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "LogFreqOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block32: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            boolean bl = this.pr.bool[0];
            int n = 0;
            try {
                float f;
                float f2;
                int n2;
                int n3;
                int n4;
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl2 = false;
                while (!bl2 && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl2 = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block32;
                int[] nArray = new int[spectStream.bands + 1];
                float[] fArray = new float[spectStream.bands + 1];
                int[] nArray2 = new int[spectStream.bands + 1];
                float[] fArray2 = new float[spectStream.bands + 1];
                int n5 = spectStream.bands;
                float f3 = (spectStream.hiFreq - spectStream.loFreq) / (float)spectStream.bands;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                float f4 = (float)this.pr.para[1].value;
                float f5 = (float)this.pr.para[0].value;
                double d = (double)(spectStream.bands - 1) / Math.log(f5 / f4);
                for (n4 = 0; n4 <= spectStream.bands; ++n4) {
                    double d2 = spectStream.loFreq + (float)n4 * f3;
                    float f6 = (float)(Math.log(d2 / (double)f4) * d + 1.0);
                    nArray[n4] = (int)Math.floor(f6);
                    fArray[n4] = 1.0f - (f6 - (float)nArray[n4]);
                }
                for (n4 = 0; n4 < spectStream.bands; ++n4) {
                    n3 = nArray[n4];
                    n2 = nArray[n4 + 1];
                    f2 = fArray[n4];
                    f = 1.0f - fArray[n4 + 1];
                    if (n3 < 0) {
                        n3 = 0;
                        if (n3 < n2) {
                            f2 = 1.0f;
                        } else {
                            n = n4 + 1;
                            continue;
                        }
                    }
                    if (n2 >= spectStream.bands) {
                        n2 = spectStream.bands - 1;
                        if (n2 > n3) {
                            f = 1.0f;
                        } else {
                            n5 = n4;
                            break;
                        }
                    }
                    if (n3 == n2) {
                        f2 = f - (1.0f - f2);
                        f = 0.0f;
                    }
                    nArray[n4] = n3;
                    fArray[n4] = f2;
                    nArray2[n4] = n2;
                    fArray2[n4] = f;
                }
                this.runSlotsReady();
                Random random = new Random();
                block13: while (!this.threadDead) {
                    int n6 = 0;
                    while (n6 == 0 && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            n6 = 1;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block13;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (n6 = 0; n6 < n; ++n6) {
                        for (int i = 0; i < spectStream.chanNum; ++i) {
                            spectFrame2.data[i][(n6 << 1) + 0] = 0.0f;
                            spectFrame2.data[i][(n6 << 1) + 1] = 0.0f;
                        }
                    }
                    for (n6 = n; n6 < n5; ++n6) {
                        n3 = nArray[n6];
                        n2 = nArray2[n6];
                        f2 = fArray[n6];
                        f = fArray2[n6];
                        for (int i = 0; i < spectStream.chanNum; ++i) {
                            float f7 = spectFrame.data[i][(n3 << 1) + 0];
                            float f8 = spectFrame.data[i][(n3 << 1) + 1];
                            double d3 = (double)f7 * Math.sin(f8) * (double)f2;
                            double d4 = (double)f7 * Math.cos(f8) * (double)f2;
                            for (int j = n3 + 1; j < n2; ++j) {
                                f7 = spectFrame.data[i][(j << 1) + 0];
                                f8 = spectFrame.data[i][(j << 1) + 1];
                                d3 += (double)f7 * Math.sin(f8);
                                d4 += (double)f7 * Math.cos(f8);
                            }
                            if (f > 0.0f) {
                                f7 = spectFrame.data[i][(n2 << 1) + 0];
                                f8 = spectFrame.data[i][(n2 << 1) + 1];
                                d3 += (double)f7 * Math.sin(f8) * (double)f;
                                d4 += (double)f7 * Math.cos(f8) * (double)f;
                            }
                            spectFrame2.data[i][(n6 << 1) + 0] = (float)Math.sqrt(d3 * d3 + d4 * d4);
                            spectFrame2.data[i][(n6 << 1) + 1] = bl ? random.nextFloat() * (float)Math.PI : (float)Math.atan2(d3, d4);
                        }
                    }
                    for (n6 = n5; n6 < spectStream.bands; ++n6) {
                        for (int i = 0; i < spectStream.chanNum; ++i) {
                            spectFrame2.data[i][(n6 << 1) + 0] = 0.0f;
                            spectFrame2.data[i][(n6 << 1) + 1] = 0.0f;
                        }
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    n6 = 0;
                    while (n6 == 0 && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            n6 = 1;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbHigh frequency;pf15,prHiFreq\nlbLow frequency;pf15,prLoFreq\ncbRandom Phase,prRandPhase");
        return propertyGUI;
    }
}

