/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class SynthesisOp
extends Operator {
    protected static final String defaultName = "Synthesize";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    private static final int PR_FILENAME = 0;
    private static final int PR_WINDOW = 0;
    private static final int PR_TYPE = 1;
    private static final int PR_ROTATE = 0;
    private static final int PR_LOFREQ = 0;
    private static final int PR_HIFREQ = 1;
    private static final int PR_LORADIUS = 2;
    private static final int PR_HIRADIUS = 3;
    protected static final int TYPE_FFT = 0;
    protected static final int TYPE_CZT = 1;
    protected static final int TYPE_NONE = 2;
    private static final String PRN_FILENAME = "Filename";
    private static final String PRN_WINDOW = "Window";
    private static final String PRN_ROTATE = "Rotate";
    private static final String PRN_TYPE = "Type";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_LORADIUS = "LoRadius";
    private static final String PRN_HIRADIUS = "HiRadius";
    private static final String[] prText = new String[]{""};
    private static final String[] prTextName = new String[]{"Filename"};
    private static final int[] prIntg = new int[]{0, 0};
    private static final String[] prIntgName = new String[]{"Window", "Type"};
    private static final boolean[] prBool = new boolean[]{true};
    private static final String[] prBoolName = new String[]{"Rotate"};
    private static final Param[] prPara = new Param[]{null, null, null, null};
    private static final String[] prParaName = new String[]{"LoFreq", "HiFreq", "LoRadius", "HiRadius"};
    protected static final String ERR_NOOUTPUT = "No output file";

    public SynthesisOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), SynthesisOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SynthesisOp.static_pr.text = prText;
            SynthesisOp.static_pr.textName = prTextName;
            SynthesisOp.static_pr.intg = prIntg;
            SynthesisOp.static_pr.intgName = prIntgName;
            SynthesisOp.static_pr.bool = prBool;
            SynthesisOp.static_pr.boolName = prBoolName;
            SynthesisOp.static_pr.para = prPara;
            SynthesisOp.static_pr.para[0] = new Param(0.0, 3);
            SynthesisOp.static_pr.para[1] = new Param(22050.0, 3);
            SynthesisOp.static_pr.para[2] = new Param(0.0, 785);
            SynthesisOp.static_pr.para[3] = new Param(0.0, 785);
            SynthesisOp.static_pr.paraName = prParaName;
            SynthesisOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "SynthesisOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.icon = new OpIcon(this, 9, defaultName);
    }

    @Override
    public void run() {
        block45: {
            String string;
            this.runInit();
            AudioFile audioFile = null;
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            if (this.pr.text[0] == null || this.pr.text[0].length() == 0) {
                Component component = this.owner.getModule().getComponent();
                boolean bl = !(component instanceof Frame);
                Frame frame = bl ? new Frame() : (Frame)component;
                FileDialog fileDialog = new FileDialog(frame, ((OpIcon)this.getIcon()).getName() + ": Select output file", 1);
                fileDialog.setVisible(true);
                if (bl) {
                    frame.dispose();
                }
                String string2 = fileDialog.getFile();
                String string3 = fileDialog.getDirectory();
                fileDialog.dispose();
                if (string3 == null) {
                    string3 = "";
                }
                if (string2 == null) {
                    this.runQuit(new IOException(ERR_NOOUTPUT));
                    return;
                }
                string = string3 + string2;
            } else {
                string = this.pr.text[0];
            }
            try {
                int n;
                int n2;
                IOUtil.createEmptyFile((File)new File(string));
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block45;
                int n3 = spectStream.chanNum;
                SpectStream spectStream2 = new SpectStream();
                spectStream2.smpRate = spectStream.smpRate;
                int n4 = spectStream.smpPerFrame;
                int n5 = n2 = spectStream.bands - 1 << 1;
                int n6 = n5 >> 1;
                float[] fArray = new float[n2 + 2];
                float[][] fArray2 = new float[n3][n5];
                Util.clear(fArray2);
                float[] fArray3 = Filter.createFullWindow(n5, this.pr.intg[0]);
                double d = 0.0;
                for (n = 0; n < n5; ++n) {
                    d += (double)fArray3[n];
                }
                float f = (float)((double)n2 * (double)n4 / d);
                n = 0;
                while (n < n5) {
                    int n7 = n++;
                    fArray3[n7] = fArray3[n7] * f;
                }
                AudioFileDescr audioFileDescr = new AudioFileDescr();
                audioFileDescr.channels = n3;
                audioFileDescr.rate = spectStream.smpRate;
                audioFileDescr.bitsPerSample = 32;
                audioFileDescr.sampleFormat = 1;
                audioFileDescr.type = 2;
                audioFileDescr.file = new File(string);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                this.runSlotsReady();
                int n8 = 0;
                int n9 = 0;
                int n10 = n4;
                block15: while (!this.threadDead) {
                    float[] fArray4;
                    int n11;
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block15;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    block17: for (n11 = 0; n11 < n3; ++n11) {
                        fArray4 = spectFrame.data[n11];
                        Fourier.polar2Rect(fArray4, 0, fArray, 0, n2 + 2);
                        fArray4 = fArray2[n11];
                        switch (this.pr.intg[1]) {
                            case 1: {
                                throw new IOException("CZT not yet implemented!");
                            }
                            case 0: {
                                int n12;
                                int n13;
                                int n14;
                                Fourier.realTransform(fArray, n2, -1);
                                if (this.pr.bool[0]) {
                                    n = 0;
                                    n14 = n6;
                                    while (n < n6) {
                                        int n15 = n++;
                                        fArray[n15] = fArray[n15] * fArray3[n14];
                                        ++n14;
                                    }
                                    while (n < n2 - n6) {
                                        fArray[n] = 0.0f;
                                        ++n;
                                    }
                                    n14 = 0;
                                    while (n < n2) {
                                        int n16 = n++;
                                        fArray[n16] = fArray[n16] * fArray3[n14];
                                        ++n14;
                                    }
                                    n = n8;
                                    n14 = n2 - n6;
                                    n13 = 0;
                                    while (n13 < n5) {
                                        n12 = Math.min(n5 - n13, Math.min(n5 - n, n2 - n14));
                                        while (n12 > 0) {
                                            int n17 = n++;
                                            fArray4[n17] = fArray4[n17] + fArray[n14++];
                                            --n12;
                                            ++n13;
                                        }
                                        n %= n5;
                                        n14 %= n2;
                                    }
                                    continue block17;
                                }
                                n = n8;
                                n14 = 0;
                                n13 = 0;
                                while (n13 < n5) {
                                    for (n12 = Math.min(n5 - n13, n5 - n); n12 > 0; --n12) {
                                        int n18 = n++;
                                        fArray4[n18] = fArray4[n18] + fArray[n14++] * fArray3[n13++];
                                    }
                                    n %= n5;
                                }
                                continue block17;
                            }
                            case 2: {
                                int n12;
                                int n13;
                                int n14;
                                if (this.pr.bool[0]) {
                                    n = 0;
                                    n14 = n6;
                                    while (n < n6) {
                                        int n19 = n++;
                                        fArray[n19] = fArray[n19] * fArray3[n14];
                                        ++n14;
                                    }
                                    while (n < n2 - n6) {
                                        fArray[n] = 0.0f;
                                        ++n;
                                    }
                                    n14 = 0;
                                    while (n < n2) {
                                        int n20 = n++;
                                        fArray[n20] = fArray[n20] * fArray3[n14];
                                        ++n14;
                                    }
                                    n = n8;
                                    n14 = n2 - n6;
                                    n13 = 0;
                                    while (n13 < n5) {
                                        n12 = Math.min(n5 - n13, Math.min(n5 - n, n2 - n14));
                                        while (n12 > 0) {
                                            int n21 = n++;
                                            fArray4[n21] = fArray4[n21] + fArray[n14++];
                                            --n12;
                                            ++n13;
                                        }
                                        n %= n5;
                                        n14 %= n2;
                                    }
                                    continue block17;
                                }
                                n = n8;
                                n14 = 0;
                                n13 = 0;
                                while (n13 < n5) {
                                    for (n12 = Math.min(n5 - n13, n5 - n); n12 > 0; --n12) {
                                        int n22 = n++;
                                        fArray4[n22] = fArray4[n22] + fArray[n14++] * fArray3[n13++];
                                    }
                                    n %= n5;
                                }
                                continue block17;
                            }
                        }
                    }
                    audioFile.writeFrames(fArray2, n8, n10);
                    for (n11 = 0; n11 < n3; ++n11) {
                        fArray4 = fArray2[n11];
                        n = n8 + n10;
                        while (n > n8) {
                            fArray4[--n] = 0.0f;
                        }
                    }
                    n9 += n10;
                    n8 = (n8 + n10) % n5;
                    this.runFrameDone(spectStreamSlot, spectFrame);
                    spectStreamSlot.freeFrame(spectFrame);
                }
                spectStream.closeReader();
                if (!this.threadDead) {
                    for (n = n4; n < n5; n += n4) {
                        audioFile.writeFrames(fArray2, n8, n10);
                        n8 = (n8 + n10) % n5;
                    }
                }
                audioFile.close();
            }
            catch (IOException iOException) {
                if (audioFile != null) {
                    audioFile.cleanUp();
                }
                this.runQuit(iOException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        String[] stringArray = Filter.getWindowNames();
        StringBuffer stringBuffer = new StringBuffer();
        if (n != 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(",it");
            stringBuffer.append(stringArray[i]);
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbFilename;io1|Select output file,prFilename\nlbTransform;ch,ac0|3|di|4|di|5|di|6|di,ac1|3|en|4|en|5|en|6|en,prType,itDiscrete Fourier,itChirp Z,itNone\nlbWindow;ch,prWindow" + stringBuffer.toString() + "\ncbRotate origin,pr" + PRN_ROTATE + "\nglChirp transform specs\nlbLow freq;pf" + 15 + ",id3,pr" + PRN_LOFREQ + "\nlbHigh freq;pf" + 15 + ",id4,pr" + PRN_HIFREQ + "\nlbLow radius;pf" + 7 + ",id5,pr" + PRN_LORADIUS + "\nlbHigh radius;pf" + 7 + ",id6,pr" + PRN_HIRADIUS);
        return propertyGUI;
    }
}

