/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.spect;

public class Fourier {
    public static final int FORWARD = 1;
    public static final int INVERSE = -1;

    public static void complexTransform(float[] fArray, int n, int n2) {
        int n3;
        float f;
        float f2;
        int n4;
        int n5 = n << 1;
        double d = (double)n2 * (Math.PI * 2);
        int n6 = 1;
        for (n4 = 1; n4 < n5; n4 += 2) {
            if (n6 > n4) {
                f2 = fArray[n6 - 1];
                fArray[n6 - 1] = fArray[n4 - 1];
                fArray[n4 - 1] = f2;
                f = fArray[n6];
                fArray[n6] = fArray[n4];
                fArray[n4] = f;
            }
            for (n3 = n; n3 >= 2 && n6 > n3; n6 -= n3, n3 >>= 1) {
            }
            n6 += n3;
        }
        int n7 = 2;
        while (n5 > n7) {
            int n8 = n7 << 1;
            double d2 = Math.sin(d / (double)n8);
            double d3 = -2.0 * d2 * d2;
            double d4 = Math.sin(d / (double)n7);
            double d5 = 1.0;
            double d6 = 0.0;
            for (n3 = 1; n3 < n7; n3 += 2) {
                for (n4 = n3; n4 <= n5; n4 += n8) {
                    n6 = n4 + n7;
                    f2 = (float)(d5 * (double)fArray[n6 - 1] - d6 * (double)fArray[n6]);
                    f = (float)(d5 * (double)fArray[n6] + d6 * (double)fArray[n6 - 1]);
                    fArray[n6 - 1] = fArray[n4 - 1] - f2;
                    fArray[n6] = fArray[n4] - f;
                    int n9 = n4 - 1;
                    fArray[n9] = fArray[n9] + f2;
                    int n10 = n4;
                    fArray[n10] = fArray[n10] + f;
                }
                d2 = d5;
                d5 += d2 * d3 - d6 * d4;
                d6 += d2 * d4 + d6 * d3;
            }
            n7 = n8;
        }
        if (n2 == -1) {
            n4 = 0;
            while (n4 < n5) {
                int n11 = n4++;
                fArray[n11] = fArray[n11] / (float)n;
            }
        }
    }

    public static void realTransform(float[] fArray, int n, int n2) {
        float f;
        int n3 = n >> 1;
        double d = (double)n2 * Math.PI / (double)n3;
        float f2 = 0.5f;
        float f3 = (float)(-n2) * 0.5f;
        double d2 = Math.sin(d / 2.0);
        double d3 = -2.0 * d2 * d2;
        double d4 = Math.sin(d);
        double d5 = 1.0 + d3;
        double d6 = d4;
        if (n2 == 1) {
            Fourier.complexTransform(fArray, n3, n2);
        }
        for (int i = 2; i < n3; i += 2) {
            int n4 = i + 1;
            int n5 = n - i;
            int n6 = n5 + 1;
            f = f2 * (fArray[i] + fArray[n5]);
            float f4 = f2 * (fArray[n4] - fArray[n6]);
            float f5 = -f3 * (fArray[n4] + fArray[n6]);
            float f6 = f3 * (fArray[i] - fArray[n5]);
            fArray[i] = (float)((double)f + d5 * (double)f5 - d6 * (double)f6);
            fArray[n4] = (float)((double)f4 + d5 * (double)f6 + d6 * (double)f5);
            fArray[n5] = (float)((double)f - d5 * (double)f5 + d6 * (double)f6);
            fArray[n6] = (float)((double)(-f4) + d5 * (double)f6 + d6 * (double)f5);
            d2 = d5;
            d5 += d2 * d3 - d6 * d4;
            d6 += d2 * d4 + d6 * d3;
        }
        if (n2 == -1) {
            f = fArray[0];
            fArray[0] = f2 * (f + fArray[n]);
            fArray[1] = f2 * (f - fArray[n]);
            fArray[n] = 0.0f;
            fArray[n + 1] = 0.0f;
            Fourier.complexTransform(fArray, n3, n2);
        } else {
            f = fArray[0];
            fArray[0] = f + fArray[1];
            fArray[n] = f - fArray[1];
            fArray[1] = 0.0f;
            fArray[n + 1] = 0.0f;
        }
    }

    public static void rect2Polar(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray == fArray2 && n < n2) {
            int n4 = n + n3;
            int n5 = n2 + n3;
            while (n4 > n) {
                double d = fArray[--n4];
                double d2 = fArray[--n4];
                fArray2[--n5] = (float)Math.atan2(d, d2);
                fArray2[--n5] = (float)Math.sqrt(d * d + d2 * d2);
            }
        } else {
            int n6 = n;
            int n7 = n2;
            while (n6 < n + n3) {
                double d = fArray[n6++];
                double d3 = fArray[n6++];
                fArray2[n7++] = (float)Math.sqrt(d3 * d3 + d * d);
                fArray2[n7++] = (float)Math.atan2(d3, d);
            }
        }
    }

    public static void polar2Rect(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray == fArray2 && n < n2) {
            int n4 = n + n3;
            int n5 = n2 + n3;
            while (n4 > n) {
                double d = fArray[--n4];
                double d2 = fArray[--n4];
                fArray2[--n5] = (float)(d2 * Math.sin(d));
                fArray2[--n5] = (float)(d2 * Math.cos(d));
            }
        } else {
            int n6 = n;
            int n7 = n2;
            while (n6 < n + n3) {
                double d = fArray[n6++];
                double d3 = fArray[n6++];
                fArray2[n7++] = (float)(d * Math.cos(d3));
                fArray2[n7++] = (float)(d * Math.sin(d3));
            }
        }
    }

    public static void complexMult(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, int n4) {
        if (fArray == fArray3 && n < n3 || fArray2 == fArray3 && n2 < n3) {
            int n5 = n + n4;
            int n6 = n2 + n4;
            int n7 = n3 + n4;
            while (n5 > n) {
                float f = fArray[--n5];
                float f2 = fArray[--n5];
                float f3 = fArray2[--n6];
                float f4 = fArray2[--n6];
                fArray3[--n7] = f * f4 + f2 * f3;
                fArray3[--n7] = f2 * f4 - f * f3;
            }
        } else {
            int n8 = n;
            int n9 = n2;
            int n10 = n3;
            while (n8 < n + n4) {
                float f = fArray[n8++];
                float f5 = fArray[n8++];
                float f6 = fArray2[n9++];
                float f7 = fArray2[n9++];
                fArray3[n10++] = f * f6 - f5 * f7;
                fArray3[n10++] = f5 * f6 + f * f7;
            }
        }
    }

    public static void unwrapPhases(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        int n4 = n + 1;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 < n + n3) {
            double d3 = fArray[n4];
            if (d3 - d > Math.PI) {
                d2 = (double)(--n6) * (Math.PI * 2);
            } else if (d - d3 > Math.PI) {
                d2 = (double)(++n6) * (Math.PI * 2);
            }
            fArray2[n5] = (float)(d3 + d2);
            d = d3;
            n4 += 2;
            n5 += 2;
        }
    }

    public static void wrapPhases(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        double d = 0.0;
        int n4 = n + 1;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 < n + n3) {
            double d2 = fArray[n4];
            while (d2 - d > Math.PI) {
                d = (double)(++n6) * (Math.PI * 2);
            }
            while (d - d2 > Math.PI) {
                d = (double)(--n6) * (Math.PI * 2);
            }
            fArray2[n5] = (float)(d2 - d);
            n4 += 2;
            n5 += 2;
        }
    }
}

