/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.spect;

public class SpectFrame
implements Cloneable {
    public static final int AMP = 0;
    public static final int PHASE = 1;
    public static final int FLAGS_UNTOUCHED = 0;
    public static final int FLAGS_LEFT = 1;
    public static final int FLAGS_RIGHT = 2;
    public static final int FLAGS_SUM = 3;
    public float[][] data;
    public int accessCount;

    public SpectFrame(int n, int n2) {
        this.data = new float[n][n2 << 1];
        this.accessCount = 1;
    }

    public SpectFrame(SpectFrame spectFrame, int n) {
        this(n == 0 ? spectFrame.data.length : 1, spectFrame.data[0].length >> 1);
        this.copyData(spectFrame, this, n);
    }

    public SpectFrame(SpectFrame spectFrame) {
        this(spectFrame, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gainAccess() {
        SpectFrame spectFrame = this;
        synchronized (spectFrame) {
            ++this.accessCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void looseAccess() {
        SpectFrame spectFrame = this;
        synchronized (spectFrame) {
            --this.accessCount;
        }
    }

    public Object clone() {
        return new SpectFrame(this, 0);
    }

    public static void clear(SpectFrame spectFrame) {
        for (int i = 0; i < spectFrame.data.length; ++i) {
            for (int j = 0; j < spectFrame.data[i].length; ++j) {
                spectFrame.data[i][j] = 0.0f;
            }
        }
    }

    protected void copyData(SpectFrame spectFrame, SpectFrame spectFrame2, int n) {
        switch (n) {
            case 3: {
                for (int i = 0; i < spectFrame.data[0].length; i += 2) {
                    double d = 0.0;
                    double d2 = 0.0;
                    for (int j = 0; j < spectFrame.data.length; ++j) {
                        float f = spectFrame.data[j][i + 0];
                        float f2 = spectFrame.data[j][i + 1];
                        d += (double)f * Math.sin(f2);
                        d2 += (double)f * Math.cos(f2);
                    }
                    spectFrame2.data[0][i + 0] = (float)Math.sqrt((d /= (double)spectFrame.data.length) * d + (d2 /= (double)spectFrame.data.length) * d2);
                    spectFrame2.data[0][i + 1] = (float)Math.atan2(d, d2);
                }
                break;
            }
            default: {
                int n2;
                int n3;
                switch (n) {
                    case 1: {
                        n3 = 0;
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n3 = Math.min(1, spectFrame.data.length - 1);
                        n2 = 1;
                        break;
                    }
                    default: {
                        n3 = 0;
                        n2 = Math.min(spectFrame.data.length, spectFrame2.data.length);
                    }
                }
                for (int i = 0; i < n2; ++i) {
                    System.arraycopy(spectFrame.data[n3 + i], 0, spectFrame2.data[i], 0, spectFrame.data[n3 + i].length);
                }
            }
        }
    }
}

