/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.spect;

import de.sciss.fscape.gui.Spectrogram;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import java.io.IOException;
import java.io.SyncFailedException;
import java.rmi.NotBoundException;
import java.util.NoSuchElementException;

public class SpectStreamSlot {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_DEAD = 2;
    public static final int STATE_WAITING = 3;
    public static final int STATE_DUMMY = 4;
    public int state = 0;
    protected int flags;
    protected String name;
    protected Operator owner;
    protected Thread ownerThread = null;
    protected SpectStreamSlot linked = null;
    protected SpectStream stream = null;
    protected Spectrogram spectro = null;
    protected static final String ERR_INTERRUPTED = "Slot was interrupted";
    protected static final String ERR_STILLINUSE = "Slot still in use";

    public SpectStreamSlot(Operator operator, int n, String string) {
        this.flags = n & 0xF0 | 1;
        this.name = string;
        this.owner = operator;
    }

    public SpectStreamSlot(Operator operator, int n) {
        this(operator, n, (n & 0xF0) == 16 ? "in" : "out");
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        return this.name;
    }

    public Operator getOwner() {
        return this.owner;
    }

    public SpectStreamSlot getLinked() {
        return this.linked;
    }

    public void linkTo(SpectStreamSlot spectStreamSlot) throws SyncFailedException, SlotAlreadyConnectedException {
        if (this.linked != null || spectStreamSlot.linked != null) {
            throw new SlotAlreadyConnectedException();
        }
        if ((this.flags & 0xF0) == (spectStreamSlot.flags & 0xF0)) {
            throw new SyncFailedException("");
        }
        this.linked = spectStreamSlot;
        this.flags |= 2;
        this.flags &= 0xFFFFFFFE;
        spectStreamSlot.linked = this;
        spectStreamSlot.flags |= 2;
        spectStreamSlot.flags &= 0xFFFFFFFE;
    }

    public void divorce() throws NotBoundException {
        if (this.linked != null) {
            this.linked.linked = null;
            this.linked.flags &= 0xFFFFFFFD;
            this.linked.flags |= 1;
            this.linked = null;
            this.flags &= 0xFFFFFFFD;
            this.flags |= 1;
        } else {
            throw new NotBoundException();
        }
    }

    public Thread getOwnerThread() {
        return this.ownerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWriter(SpectStream spectStream) throws SlotAlreadyConnectedException {
        SpectStreamSlot spectStreamSlot = this;
        synchronized (spectStreamSlot) {
            if (this.stream != null) {
                throw new SlotAlreadyConnectedException(ERR_STILLINUSE);
            }
            spectStream.initWriter();
            this.ownerThread = Thread.currentThread();
            this.stream = spectStream;
            this.state = 1;
        }
        if (this.linked != null) {
            spectStreamSlot = this.linked;
            synchronized (spectStreamSlot) {
                this.linked.stream = spectStream;
                if (this.linked.state == 3) {
                    this.linked.notify();
                }
            }
        } else {
            this.state = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectStream getDescr() throws InterruptedException {
        SpectStreamSlot spectStreamSlot = this;
        synchronized (spectStreamSlot) {
            try {
                this.ownerThread = Thread.currentThread();
                while (this.stream == null) {
                    this.state = 3;
                    this.wait();
                    this.state = 1;
                }
                this.stream.getDescr();
            }
            catch (InterruptedException interruptedException) {
                this.state = 1;
                throw interruptedException;
            }
            return this.stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSpectrogram() {
        SpectStreamSlot spectStreamSlot = this;
        synchronized (spectStreamSlot) {
            if (this.stream != null) {
                if (this.spectro == null) {
                    this.spectro = new Spectrogram(this);
                }
                this.spectro.newStream(this.stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpectFrame readFrame() throws IOException, InterruptedException {
        SpectFrame spectFrame = null;
        SpectStreamSlot spectStreamSlot = this;
        synchronized (spectStreamSlot) {
            try {
                while (spectFrame == null) {
                    try {
                        if (this.stream.framesReadable() != 0) {
                            spectFrame = this.stream.readFrame();
                            if (this.linked.state != 3) continue;
                            SpectStreamSlot spectStreamSlot2 = this.linked;
                            synchronized (spectStreamSlot2) {
                                this.linked.notify();
                                continue;
                            }
                        }
                        this.state = 3;
                        this.wait();
                        this.state = 1;
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                return spectFrame;
            }
            catch (InterruptedException interruptedException) {
                this.state = 1;
                throw interruptedException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeFrame(SpectFrame spectFrame) throws IOException, InterruptedException {
        if (this.state == 4) {
            this.stream.writeDummy(spectFrame);
            return;
        }
        SpectStreamSlot spectStreamSlot = this;
        synchronized (spectStreamSlot) {
            try {
                while (spectFrame != null) {
                    try {
                        if (this.stream.framesWriteable() != 0) {
                            this.stream.writeFrame(spectFrame);
                            if (this.spectro != null) {
                                this.spectro.addFrame(spectFrame);
                            }
                            spectFrame = null;
                            if (this.linked.state != 3) continue;
                            SpectStreamSlot spectStreamSlot2 = this.linked;
                            synchronized (spectStreamSlot2) {
                                this.linked.notify();
                                continue;
                            }
                        }
                        this.state = 3;
                        this.wait();
                        this.state = 1;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.state = 1;
                throw interruptedException;
            }
        }
    }

    public void freeFrame(SpectFrame spectFrame) {
        this.stream.freeFrame(spectFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        SpectStreamSlot spectStreamSlot = this;
        synchronized (spectStreamSlot) {
            if (this.spectro != null) {
                this.spectro.ownerTerminated();
                this.spectro = null;
            }
            if (this.stream != null) {
                try {
                    if ((this.flags & 0xF0) == 16) {
                        this.stream.closeReader();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if ((this.flags & 0xF0) == 32) {
                        this.stream.closeWriter();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream = null;
            }
            this.state = 2;
            this.ownerThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectStream getStream() {
        SpectStreamSlot spectStreamSlot = this;
        synchronized (spectStreamSlot) {
            return this.stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float progress(SpectStreamSlot spectStreamSlot) {
        if (spectStreamSlot == null || spectStreamSlot.stream == null) {
            return 0.0f;
        }
        SpectStreamSlot spectStreamSlot2 = spectStreamSlot;
        synchronized (spectStreamSlot2) {
            if ((spectStreamSlot.flags & 0xF0) == 16) {
                return (float)spectStreamSlot.stream.framesRead / (float)spectStreamSlot.stream.frames;
            }
            return (float)spectStreamSlot.stream.framesWritten / (float)spectStreamSlot.stream.frames;
        }
    }
}

