/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.util.DoublePoint;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Curve
implements Cloneable {
    public static final int TYPE_DIA = 0;
    public static final int TYPE_ORTHO = 1;
    public ParamSpace hSpace;
    public ParamSpace vSpace;
    public int type;
    protected Vector<DoublePoint> points;

    public Curve(ParamSpace paramSpace, ParamSpace paramSpace2, int n) {
        this.hSpace = paramSpace;
        this.vSpace = paramSpace2;
        this.type = n;
        this.points = new Vector();
    }

    public Curve(ParamSpace paramSpace, ParamSpace paramSpace2) {
        this(paramSpace, paramSpace2, 0);
    }

    public Curve(Curve curve) {
        this.hSpace = curve.hSpace;
        this.vSpace = curve.vSpace;
        this.type = curve.type;
        this.points = (Vector)curve.points.clone();
    }

    public Object clone() {
        return new Curve(this);
    }

    public int addPoint(double d, double d2) {
        int n = -1;
        int n2 = -1;
        if (this.hSpace.contains(d) && this.vSpace.contains(d2)) {
            DoublePoint doublePoint = new DoublePoint(this.hSpace.fitValue(d), this.vSpace.fitValue(d2));
            double d3 = this.indexOf(d);
            if (d3 < 0.0) {
                n = 0;
                n2 = 0;
            } else if (d3 > (double)this.points.size()) {
                n = this.points.size();
                n2 = n - 1;
            } else {
                n = (int)Math.ceil(d3);
                n2 = (int)Math.rint(d3);
            }
            DoublePoint doublePoint2 = this.getPoint(n2);
            if (doublePoint2 != null && (n2 >= n && doublePoint2.x - this.hSpace.inc < doublePoint.x - 1.0E-6 || n2 < n && doublePoint2.x + this.hSpace.inc > doublePoint.x + 1.0E-6)) {
                return -1;
            }
            this.points.insertElementAt(doublePoint, n);
        }
        return n;
    }

    public int addPoint(DoublePoint doublePoint) {
        return this.addPoint(doublePoint.x, doublePoint.y);
    }

    public boolean removePoint(int n) {
        try {
            this.points.removeElementAt(n);
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public DoublePoint getPoint(int n) {
        DoublePoint doublePoint = null;
        try {
            doublePoint = this.points.elementAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return doublePoint;
    }

    public Enumeration getPoints() {
        return this.points.elements();
    }

    public int size() {
        return this.points.size();
    }

    public double indexOf(double d) {
        int n = this.points.size();
        if (n == 0) {
            return Double.POSITIVE_INFINITY;
        }
        DoublePoint doublePoint = this.points.firstElement();
        DoublePoint doublePoint2 = this.points.lastElement();
        if (doublePoint.x > d) {
            return Double.NEGATIVE_INFINITY;
        }
        if (doublePoint2.x < d) {
            return Double.POSITIVE_INFINITY;
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n2 + 1 < n3) {
            int n4 = (n2 + n3) / 2;
            DoublePoint doublePoint3 = this.points.elementAt(n4);
            if (doublePoint3.x > d) {
                doublePoint2 = doublePoint3;
                n3 = n4;
                continue;
            }
            doublePoint = doublePoint3;
            n2 = n4;
        }
        if (doublePoint.x != doublePoint2.x) {
            return (double)n2 + (d - doublePoint.x) / (doublePoint2.x - doublePoint.x);
        }
        return n2;
    }

    public static Curve transform(Curve curve, ParamSpace paramSpace, ParamSpace paramSpace2, Param param, Param param2, SpectStream spectStream) {
        if (paramSpace.contains(curve.hSpace) && paramSpace2.contains(curve.vSpace)) {
            return curve;
        }
        Curve curve2 = new Curve(paramSpace, paramSpace2, curve.type);
        for (int i = 0; i < curve.points.size(); ++i) {
            DoublePoint doublePoint = curve.points.elementAt(i);
            Param param3 = Param.transform(new Param(doublePoint.x, curve.hSpace.unit), paramSpace.unit, param, spectStream);
            Param param4 = Param.transform(new Param(doublePoint.y, curve.vSpace.unit), paramSpace2.unit, param2, spectStream);
            if (param3 == null || param4 == null) continue;
            curve2.addPoint(param3.value, param4.value);
        }
        return curve2;
    }

    public static double average(Curve curve, double d, double d2) {
        double d3 = d2 - d;
        if (d3 > 0.0) {
            double d4 = Math.min((double)(curve.points.size() - 1), Math.max(0.0, curve.indexOf(d)));
            double d5 = Math.max(0.0, Math.min((double)(curve.points.size() - 1), curve.indexOf(d2)));
            int n = (int)Math.floor(d4);
            int n2 = (int)Math.ceil(d4);
            DoublePoint doublePoint = curve.points.elementAt(n);
            DoublePoint doublePoint2 = curve.points.elementAt(n2);
            DoublePoint doublePoint3 = new DoublePoint(d, doublePoint.y + (d4 - (double)n) * (doublePoint2.y - doublePoint.y));
            int n3 = n2;
            n = (int)Math.floor(d5);
            n2 = (int)Math.ceil(d5);
            doublePoint = curve.points.elementAt(n);
            doublePoint2 = curve.points.elementAt(n2);
            DoublePoint doublePoint4 = new DoublePoint(d2, doublePoint.y + (d5 - (double)n) * (doublePoint2.y - doublePoint.y));
            int n4 = n;
            double d6 = 0.0;
            for (int i = n3; i <= n4; ++i) {
                DoublePoint doublePoint5 = curve.points.elementAt(i);
                d6 += (doublePoint5.x - doublePoint3.x) * (doublePoint3.y + (doublePoint5.y - doublePoint3.y) / 2.0);
                doublePoint3 = doublePoint5;
            }
            return (d6 += (doublePoint4.x - doublePoint3.x) * (doublePoint3.y + (doublePoint4.y - doublePoint3.y) / 2.0)) / d3;
        }
        double d7 = Math.min((double)curve.points.size(), Math.max(0.0, curve.indexOf(d)));
        int n = (int)Math.floor(d7);
        int n5 = (int)Math.ceil(d7);
        DoublePoint doublePoint = curve.points.elementAt(n);
        DoublePoint doublePoint6 = curve.points.elementAt(n5);
        return doublePoint.y + (d7 - (double)n) * (doublePoint6.y - doublePoint.y);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.hSpace.toString() + ';' + this.vSpace.toString() + ';' + this.type);
        for (int i = 0; i < this.points.size(); ++i) {
            stringBuffer.append(";" + this.points.elementAt(i).toString());
        }
        return stringBuffer.toString();
    }

    public static Curve valueOf(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        Curve curve = new Curve(ParamSpace.valueOf(stringTokenizer.nextToken()), ParamSpace.valueOf(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        while (stringTokenizer.hasMoreElements()) {
            curve.points.addElement(DoublePoint.valueOf(stringTokenizer.nextToken()));
        }
        return curve;
    }
}

