/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.checkbox;

import com.alee.extended.checkbox.AdaptiveTristateCheckBoxPainter;
import com.alee.extended.checkbox.ITristateCheckBoxPainter;
import com.alee.extended.checkbox.TristateCheckBoxPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public class WebTristateCheckBoxUI
extends BasicCheckBoxUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=TristateCheckBoxPainter.class)
    protected ITristateCheckBoxPainter painter;
    protected JCheckBox checkBox = null;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebTristateCheckBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.checkBox = (JCheckBox)c;
        StyleManager.installSkin(this.checkBox);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.checkBox);
        this.checkBox = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.checkBox);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.checkBox, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.checkBox, this.painter);
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.checkBox, new DataRunnable<ITristateCheckBoxPainter>(){

            public void run(ITristateCheckBoxPainter newPainter) {
                WebTristateCheckBoxUI.this.painter = newPainter;
            }
        }, this.painter, painter, ITristateCheckBoxPainter.class, AdaptiveTristateCheckBoxPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    public Rectangle getIconRect() {
        if (this.painter != null) {
            return this.painter.getIconRect();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }
}

