/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.FrameType;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.style.StyleId;
import com.alee.utils.TextUtils;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class WebDockableFrame
extends WebPanel
implements LanguageMethods {
    public static final ImageIcon dockTop = new ImageIcon(WebDockablePane.class.getResource("icons/dock_top.png"));
    public static final ImageIcon dockLeft = new ImageIcon(WebDockablePane.class.getResource("icons/dock_left.png"));
    public static final ImageIcon dockRight = new ImageIcon(WebDockablePane.class.getResource("icons/dock_right.png"));
    public static final ImageIcon dockBottom = new ImageIcon(WebDockablePane.class.getResource("icons/dock_bottom.png"));
    public static final String ID_PREFIX = "WDF";
    protected String frameId;
    protected FrameType frameType;
    protected final WebPanel titlePanel;
    protected final WebLabel titleLabel;
    protected final WebPanel buttonsPanel;
    protected final WebButton dockButton;

    public WebDockableFrame() {
        this("");
    }

    public WebDockableFrame(String frameTitle) {
        this(TextUtils.generateId((String)ID_PREFIX), frameTitle);
    }

    public WebDockableFrame(String frameId, String frameTitle) {
        this(frameId, null, frameTitle);
    }

    public WebDockableFrame(Icon frameIcon) {
        this(frameIcon, "");
    }

    public WebDockableFrame(Icon frameIcon, String frameTitle) {
        this(TextUtils.generateId((String)ID_PREFIX), frameIcon, frameTitle);
    }

    public WebDockableFrame(String frameId, Icon frameIcon) {
        this(frameId, frameIcon, "");
    }

    public WebDockableFrame(String frameId, Icon frameIcon, String frameTitle) {
        super(StyleId.dockableframe);
        this.frameId = frameId;
        this.titlePanel = new WebPanel(StyleId.dockableframeTitlePanel.at(this));
        this.add((Component)this.titlePanel, (Object)"North");
        this.titleLabel = new WebLabel(StyleId.dockableframeTitleLabel.at(this.titlePanel), frameTitle, frameIcon);
        this.titlePanel.add((Component)this.titleLabel, (Object)"Center");
        this.buttonsPanel = new WebPanel(StyleId.dockableframeTitleButtons.at(this.titlePanel), new HorizontalFlowLayout(0, false), new Component[0]);
        this.titlePanel.add((Component)this.buttonsPanel, (Object)"East");
        this.dockButton = new WebButton(StyleId.dockableframeTitleButton.at(this.buttonsPanel));
    }

    public String getFrameId() {
        return this.frameId;
    }

    public void setFrameId(String frameId) {
        this.frameId = frameId;
    }

    public void setIcon(Icon icon) {
        this.titleLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this.titleLabel.getIcon();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void setFrameType(FrameType frameType) {
        this.frameType = frameType;
        switch (frameType) {
            case top: {
                this.setStyleId(StyleId.dockableframeTop);
                break;
            }
            case left: {
                this.setStyleId(StyleId.dockableframeLeft);
                break;
            }
            case bottom: {
                this.setStyleId(StyleId.dockableframeBottom);
                break;
            }
            case right: {
                this.setStyleId(StyleId.dockableframeRight);
            }
        }
        this.dockButton.setIcon(this.getDockIcon(frameType));
    }

    public WebPanel getTitlePanel() {
        return this.titlePanel;
    }

    public WebLabel getTitleLabel() {
        return this.titleLabel;
    }

    public WebPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public void addButton(WebButton button) {
        boolean emptyText = TextUtils.isEmpty((String)button.getText());
        button.setStyleId(emptyText ? StyleId.dockableframeTitleIconButton.at(this.buttonsPanel) : StyleId.dockableframeTitleButton.at(this.buttonsPanel));
        this.buttonsPanel.add((Component)button, 0);
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
    }

    public WebButton getDockButton() {
        return this.dockButton;
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    protected Icon getDockIcon(FrameType frameType) {
        if (frameType.equals((Object)FrameType.top)) {
            return dockTop;
        }
        if (frameType.equals((Object)FrameType.left)) {
            return dockLeft;
        }
        if (frameType.equals((Object)FrameType.right)) {
            return dockRight;
        }
        if (frameType.equals((Object)FrameType.bottom)) {
            return dockBottom;
        }
        return null;
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((JComponent)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((JComponent)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((JComponent)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((JComponent)this);
    }
}

