/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.DockingPaneInfo;
import com.alee.extended.dock.DockingPaneLayout;
import com.alee.extended.dock.FrameType;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.window.TestFrame;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.laf.text.WebTextArea;
import com.alee.managers.style.StyleId;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WebDockablePane
extends WebPanel {
    private static final Color buttonsPaneBackground = new Color(240, 240, 240);
    private static final ImageIcon top = new ImageIcon(WebDockablePane.class.getResource("icons/dock_top_.png"));
    private static final ImageIcon left = new ImageIcon(WebDockablePane.class.getResource("icons/dock_left_.png"));
    private static final ImageIcon right = new ImageIcon(WebDockablePane.class.getResource("icons/dock_right_.png"));

    public WebDockablePane() {
        super(StyleId.dockablepane, new DockingPaneLayout(), new Component[0]);
    }

    public DockingPaneLayout getActualLayout() {
        return (DockingPaneLayout)this.getLayout();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int y2;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        DockingPaneLayout layout = this.getActualLayout();
        DockingPaneInfo info = layout.getDockingPaneInfo();
        int x = info.hasLeftButtons ? info.leftButtonsPaneBounds.x + info.leftButtonsPaneBounds.width : info.rect.x;
        int y = info.hasTopButtons ? info.topButtonsPaneBounds.y + info.topButtonsPaneBounds.height : info.rect.y;
        int x2 = info.hasRightButtons ? info.rightButtonsPaneBounds.x - 1 : info.rect.x + info.rect.width - 1;
        int n = y2 = info.hasBottomButtons ? info.bottomButtonsPaneBounds.y - 1 : info.rect.y + info.rect.height - 1;
        if (info.hasTopButtons) {
            g2d.setPaint(buttonsPaneBackground);
            g2d.fill(info.topButtonsPaneBounds);
            g2d.setPaint(StyleConstants.darkBorderColor);
            g2d.drawLine(x, y, x2, y);
        }
        if (info.hasLeftButtons) {
            g2d.setPaint(buttonsPaneBackground);
            g2d.fill(info.leftButtonsPaneBounds);
            g2d.setPaint(StyleConstants.darkBorderColor);
            g2d.drawLine(x, y, x, y2);
        }
        if (info.hasRightButtons) {
            g2d.setPaint(buttonsPaneBackground);
            g2d.fill(info.rightButtonsPaneBounds);
            g2d.setPaint(StyleConstants.darkBorderColor);
            g2d.drawLine(x2, y, x2, y2);
        }
        if (info.hasBottomButtons) {
            g2d.setPaint(buttonsPaneBackground);
            g2d.fill(info.bottomButtonsPaneBounds);
            g2d.setPaint(StyleConstants.darkBorderColor);
            g2d.drawLine(x, y2, x2, y2);
        }
    }

    public static void main(String[] args) {
        WebLookAndFeel.install();
        final WebDockablePane pane = new WebDockablePane();
        pane.add((Component)new WebToggleButton("Top frame", (Icon)top){
            {
                this.setSelected(true);
            }
        }, (Object)"TOP_LEFT");
        pane.add((Component)new WebToggleButton("Test 2", (Icon)top), (Object)"TOP_LEFT");
        pane.add((Component)new WebToggleButton("Test 3", (Icon)top), (Object)"TOP_RIGHT");
        pane.add((Component)new WebToggleButton(left){
            {
                this.setSelected(true);
            }
        }, (Object)"LEFT_TOP");
        pane.add((Component)new WebToggleButton(left), (Object)"LEFT_BOTTOM");
        pane.add((Component)new WebToggleButton(left), (Object)"LEFT_BOTTOM");
        pane.add((Component)new WebToggleButton(right), (Object)"RIGHT_TOP");
        pane.add((Component)new WebToggleButton(right), (Object)"RIGHT_TOP");
        pane.add((Component)new WebToggleButton(right), (Object)"RIGHT_TOP");
        pane.add((Component)new WebToggleButton(right), (Object)"RIGHT_TOP");
        pane.add((Component)new WebToggleButton(right), (Object)"RIGHT_BOTTOM");
        pane.add((Component)new WebToggleButton(right), (Object)"RIGHT_BOTTOM");
        pane.add((Component)new WebToggleButton("Test left", (Icon)top), (Object)"BOTTOM_LEFT");
        pane.add((Component)new WebToggleButton("Test right", (Icon)top), (Object)"BOTTOM_RIGHT");
        pane.add(WebDockablePane.createTopFrame(), (Object)"TOP_FRAME");
        pane.add(WebDockablePane.createLeftFrame(), (Object)"LEFT_FRAME");
        pane.add(WebDockablePane.createContent(), (Object)"CONTENT");
        for (final Component c : pane.getComponents()) {
            if (!(c instanceof AbstractButton)) continue;
            c.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        pane.remove(c);
                        pane.revalidate();
                        pane.repaint();
                    }
                }
            });
        }
        TestFrame.show(pane).center(600, 500);
    }

    private static Component createLeftFrame() {
        WebDockableFrame frame = new WebDockableFrame(left, "Left frame");
        frame.setFrameType(FrameType.left);
        frame.add((Component)new WebTextArea("123"));
        return frame;
    }

    private static Component createTopFrame() {
        WebDockableFrame frame = new WebDockableFrame(top, "Top frame");
        frame.setFrameType(FrameType.top);
        frame.add((Component)new WebTextArea("123", 3, 0));
        return frame;
    }

    private static Component createContent() {
        WebTabbedPane content = new WebTabbedPane(1);
        content.setTabbedPaneStyle(TabbedPaneStyle.attached);
        for (int i = 0; i < 20; ++i) {
            content.addTab("Tab " + i, new WebLabel());
        }
        return new WebPanel(content);
    }
}

