/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.drag;

import com.alee.utils.DragUtils;
import com.alee.utils.drag.FileTransferable;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class FileDragAndDropHandler
extends TransferHandler {
    protected boolean dragEnabled;
    protected int dragAction = 1;
    protected boolean dropEnabled;

    public FileDragAndDropHandler() {
        this(false, true);
    }

    public FileDragAndDropHandler(boolean dragEnabled, boolean dropEnabled) {
        this.setDragEnabled(dragEnabled);
        this.setDropEnabled(dropEnabled);
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean enabled) {
        this.dragEnabled = enabled;
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public void setDragAction(int action) {
        this.dragAction = action;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return this.getDragAction();
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (this.isDragEnabled()) {
            List<File> draggedFiles = this.filesDragged();
            return draggedFiles != null && draggedFiles.size() > 0 ? new FileTransferable(draggedFiles) : null;
        }
        return null;
    }

    public List<File> filesDragged() {
        File file = this.fileDragged();
        return file != null ? Arrays.asList(file) : null;
    }

    public File fileDragged() {
        return null;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean enabled) {
        this.dropEnabled = enabled;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        return this.isDropEnabled();
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        return info.isDrop() && this.importData(info.getTransferable());
    }

    public boolean importData(Transferable t) {
        return this.isDropEnabled() && this.filesDropped(DragUtils.getImportedFiles((Transferable)t));
    }

    public boolean filesDropped(List<File> files) {
        return true;
    }
}

