/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.laf.WebFonts;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.Map;
import javax.swing.JComponent;

public final class ComponentInspector
extends JComponent
implements ComponentListener {
    private static final Insets emptyInsets = new Insets(0, 0, 0, 0);
    private static final Color marginColor = new Color(255, 255, 0, 50);
    private static final Color borderColor = new Color(255, 0, 0, 50);
    private static final Color paddingColor = new Color(0, 200, 0, 50);
    private static final Color contentColor = new Color(0, 0, 255, 50);
    private static final int sizeTipHeight = 20;
    private Component component;

    public ComponentInspector() {
        this.setOpaque(false);
        this.setFont(WebFonts.getSystemTextFont());
    }

    public void install(Component component) {
        this.component = component;
        this.updateBounds();
        component.addComponentListener(this);
    }

    public void uninstall() {
        this.component.removeComponentListener(this);
        this.component = null;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateBounds();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.updateBounds();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateBounds();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.updateBounds();
    }

    protected void updateBounds() {
        Component glassPane = SwingUtils.getGlassPane(this.component);
        Rectangle rb = SwingUtils.getRelativeBounds(this.component, glassPane);
        int tipWidth = this.getFontMetrics(this.getFont()).stringWidth(this.getSizeTip()) + 8;
        this.setBounds(new Rectangle(rb.x, rb.y - 20, Math.max(tipWidth, rb.width), rb.height + 20));
    }

    protected String getSizeTip() {
        return this.component.getWidth() + " x " + this.component.getHeight() + " px";
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.component != null) {
            Graphics2D g2d = (Graphics2D)g;
            this.paintSizeTip(g2d);
            this.paintAreas(g2d);
        }
    }

    protected void paintSizeTip(Graphics2D g2d) {
        FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
        String sizeTip = this.getSizeTip();
        int shearY = LafUtils.getTextCenterShiftY(fm);
        int tipWidth = fm.stringWidth(sizeTip) + 8;
        GeneralPath gp = new GeneralPath(0);
        gp.moveTo(0.0f, 4.0f);
        gp.quadTo(0.0f, 0.0f, 4.0f, 0.0f);
        gp.lineTo(tipWidth - 4, 0.0f);
        gp.quadTo(tipWidth, 0.0f, tipWidth, 4.0f);
        if (this.component.getWidth() < tipWidth) {
            gp.lineTo(tipWidth, 16.0f);
            gp.quadTo(tipWidth, 20.0f, tipWidth - 4, 20.0f);
        } else {
            gp.lineTo(tipWidth, 20.0f);
        }
        gp.lineTo(0.0f, 20.0f);
        gp.closePath();
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        g2d.setPaint(Color.BLACK);
        g2d.fill(gp);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        Map taa = SwingUtils.setupTextAntialias(g2d);
        g2d.setPaint(Color.WHITE);
        g2d.drawString(sizeTip, 4, 10 + shearY);
        SwingUtils.restoreTextAntialias(g2d, taa);
    }

    protected void paintAreas(Graphics2D g2d) {
        Object ui = LafUtils.getUI(this.component);
        Rectangle bounds = new Rectangle(0, 20, this.component.getWidth(), this.getHeight() - 20);
        if (ui != null) {
            Insets m = ui instanceof MarginSupport ? ((MarginSupport)ui).getMargin() : null;
            m = m != null ? m : emptyInsets;
            Insets p = ui instanceof PaddingSupport ? ((PaddingSupport)ui).getPadding() : null;
            p = p != null ? p : emptyInsets;
            Insets b = ((JComponent)this.component).getInsets();
            b = b != null && (b.top > 0 || b.left > 0 || b.bottom > 0 || b.right > 0) ? new Insets(b.top - m.top - p.top, b.left - m.left - p.left, b.bottom - m.bottom - p.bottom, b.right - m.right - p.right) : emptyInsets;
            Rectangle sr = new Rectangle(bounds);
            Rectangle mr = new Rectangle(sr.x + m.left, sr.y + m.top, sr.width - m.left - m.right, sr.height - m.top - m.bottom);
            Rectangle br = new Rectangle(mr.x + b.left, mr.y + b.top, mr.width - b.left - b.right, mr.height - b.top - b.bottom);
            Rectangle pr = new Rectangle(br.x + p.left, br.y + p.top, br.width - p.left - p.right, br.height - p.top - p.bottom);
            if (m != emptyInsets) {
                g2d.setPaint(marginColor);
                Area ma = new Area(sr);
                ma.exclusiveOr(new Area(mr));
                g2d.fill(ma);
            }
            if (b != emptyInsets) {
                g2d.setPaint(borderColor);
                Area ba = new Area(mr);
                ba.exclusiveOr(new Area(br));
                g2d.fill(ba);
            }
            if (p != emptyInsets) {
                g2d.setPaint(paddingColor);
                Area pa = new Area(br);
                pa.exclusiveOr(new Area(pr));
                g2d.fill(pa);
            }
            g2d.setPaint(contentColor);
            g2d.fill(pr);
        } else {
            g2d.setPaint(contentColor);
            g2d.fill(bounds);
        }
    }
}

