/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.extended.inspector.InterfaceTree;
import com.alee.extended.inspector.InterfaceTreeNode;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.panel.GroupingType;
import com.alee.extended.tree.WebTreeFilterField;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebDialog;
import com.alee.laf.rootpane.WebFrame;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.managers.style.StyleId;
import java.awt.Component;

public class InterfaceInspector
extends WebPanel {
    private final InterfaceTree tree;
    private final WebScrollPane scrollPane = new WebScrollPane(StyleId.inspectorScroll.at(this));

    public InterfaceInspector() {
        this(StyleId.inspector, null);
    }

    public InterfaceInspector(Component inspected) {
        this(StyleId.inspector, inspected);
    }

    public InterfaceInspector(StyleId id) {
        this(id, null);
    }

    public InterfaceInspector(StyleId id, Component inspected) {
        super(id);
        this.scrollPane.setPreferredWidth(300);
        this.tree = new InterfaceTree(StyleId.inspectorTree.at(this.scrollPane), inspected);
        this.scrollPane.getViewport().setView(this.tree);
        WebTreeFilterField<InterfaceTreeNode> filter = new WebTreeFilterField<InterfaceTreeNode>(StyleId.inspectorFilter.at(this), this.tree);
        WebSeparator separator = new WebSeparator(StyleId.inspectorSeparator.at(this));
        this.add((Component)new GroupPanel(GroupingType.fillLast, 0, false, filter, separator, this.scrollPane));
        this.tree.expandAll();
    }

    public void setInspected(Component inspected) {
        this.tree.setRootComponent(inspected);
    }

    public static WebDialog showDialog(Component inspected) {
        WebDialog dialog = new WebDialog(inspected);
        dialog.setIconImages(WebLookAndFeel.getImages());
        dialog.add(new InterfaceInspector(inspected));
        dialog.setModal(false);
        dialog.pack();
        dialog.setLocationRelativeTo(inspected);
        dialog.setVisible(true);
        return dialog;
    }

    public static WebFrame showFrame(Component inspected) {
        WebFrame frame = new WebFrame();
        frame.setIconImages(WebLookAndFeel.getImages());
        frame.add(new InterfaceInspector(inspected));
        frame.pack();
        frame.setLocationRelativeTo(inspected);
        frame.setVisible(true);
        return frame;
    }

    public static WebPopOver showPopOver(Component inspected) {
        WebPopOver popOver = new WebPopOver(inspected);
        popOver.setIconImages(WebLookAndFeel.getImages());
        popOver.add(new InterfaceInspector(StyleId.inspectorPopover, inspected));
        popOver.show(inspected, PopOverDirection.right);
        return popOver;
    }
}

