/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector.info;

import com.alee.extended.inspector.info.AbstractComponentInfo;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleableComponent;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class StyleableInfo<T extends JComponent>
extends AbstractComponentInfo<T> {
    @Override
    public ImageIcon getIcon(StyleableComponent type, T component) {
        if (component instanceof WebGlassPane) {
            return glassPaneType;
        }
        return type.getIcon();
    }

    @Override
    public String getText(StyleableComponent type, T component) {
        String title = "{" + ReflectUtils.getClassName(component.getClass()) + ":c(" + this.getTitleColor(component) + ")}";
        String style = " [ {" + StyleId.get(component).getCompleteId() + ":b;c(" + "30,110,30" + ")} ]";
        Insets margin = LafUtils.getMargin(component);
        String mtext = this.renderInsets(margin, "190,190,0");
        Insets padding = LafUtils.getPadding(component);
        String ptext = this.renderInsets(padding, "0,150,70");
        return title + style + mtext + ptext;
    }
}

