/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.statusbar.WebMemoryBar;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;

@XStreamAlias(value="WebMemoryBarBackground")
public class WebMemoryBarBackground<E extends WebMemoryBar, D extends IDecoration<E, D>, I extends WebMemoryBarBackground<E, D, I>>
extends AbstractBackground<E, D, I> {
    @XStreamAsAttribute
    protected Integer round;
    protected Color usedBorderColor;
    protected Color usedFillColor;
    protected Color allocatedMarkColor;

    @Override
    protected String getDefaultId() {
        return "memory-background";
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d, Shape shape) {
        float opacity = this.getOpacity();
        if (opacity > 0.0f) {
            long max;
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
            Rectangle b = shape.getBounds();
            Rectangle ib = new Rectangle(b.x + 2, b.y + 2, b.width - 4, b.height - 4);
            long l = max = ((WebMemoryBar)c).isShowMaximumMemory() ? ((WebMemoryBar)c).getMaxMemory() : ((WebMemoryBar)c).getAllocatedMemory();
            if (((WebMemoryBar)c).isShowMaximumMemory()) {
                int allocatedWidth = this.getProgressWidth(ib, ((WebMemoryBar)c).getAllocatedMemory(), max, false);
                g2d.setPaint(this.allocatedMarkColor);
                g2d.drawLine(ib.x + allocatedWidth, ib.y, ib.x + allocatedWidth, ib.y + ib.height - 1);
            }
            g2d.setPaint(this.usedFillColor);
            g2d.fill(this.getProgressShape(ib, ((WebMemoryBar)c).getUsedMemory(), max, true));
            g2d.setPaint(this.usedBorderColor);
            g2d.draw(this.getProgressShape(ib, ((WebMemoryBar)c).getUsedMemory(), max, false));
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        }
    }

    protected Shape getProgressShape(Rectangle bounds, long progress, long max, boolean fill) {
        return new RoundRectangle2D.Double(bounds.x, bounds.y, this.getProgressWidth(bounds, progress, max, fill), bounds.height - (fill ? 0 : 1), this.round.intValue(), this.round.intValue());
    }

    protected int getProgressWidth(Rectangle bounds, long progress, long max, boolean fill) {
        return Math.round((float)(bounds.width - (fill ? 0 : 1)) * (float)progress / (float)max);
    }

    @Override
    public I merge(I background) {
        super.merge(background);
        if (((WebMemoryBarBackground)background).round != null) {
            this.round = ((WebMemoryBarBackground)background).round;
        }
        if (((WebMemoryBarBackground)background).usedBorderColor != null) {
            this.usedBorderColor = ((WebMemoryBarBackground)background).usedBorderColor;
        }
        if (((WebMemoryBarBackground)background).usedFillColor != null) {
            this.usedFillColor = ((WebMemoryBarBackground)background).usedFillColor;
        }
        if (((WebMemoryBarBackground)background).allocatedMarkColor != null) {
            this.allocatedMarkColor = ((WebMemoryBarBackground)background).allocatedMarkColor;
        }
        return (I)this;
    }
}

