/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentDataListener;
import com.alee.utils.CollectionUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class DocumentData<C extends Component> {
    protected transient List<DocumentDataListener> listeners = new ArrayList<DocumentDataListener>(1);
    protected String id;
    protected Icon icon;
    protected String title;
    protected Color foreground;
    protected Color background;
    protected boolean closeable;
    protected boolean draggable;
    protected C component;

    public DocumentData(String id, String title, C component) {
        this(id, null, title, null, component);
    }

    public DocumentData(String id, Icon icon, C component) {
        this(id, icon, null, null, component);
    }

    public DocumentData(String id, Icon icon, String title, C component) {
        this(id, icon, title, null, component);
    }

    public DocumentData(String id, Icon icon, String title, Color background, C component) {
        this(id, icon, title, background, true, component);
    }

    public DocumentData(String id, Icon icon, String title, Color background, boolean closeable, C component) {
        this(id, icon, title, background, closeable, true, component);
    }

    public DocumentData(String id, Icon icon, String title, Color background, boolean closeable, boolean draggable, C component) {
        this(id, icon, title, Color.BLACK, background, closeable, draggable, component);
    }

    public DocumentData(String id, Icon icon, String title, Color foreground, Color background, boolean closeable, boolean draggable, C component) {
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.foreground = foreground;
        this.background = background;
        this.closeable = closeable;
        this.draggable = draggable;
        this.component = component;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.fireTitleChanged();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireTitleChanged();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.fireTitleChanged();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        Color old = this.background;
        this.background = background;
        this.fireBackgroundChanged(old, background);
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        this.fireTitleChanged();
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public C getComponent() {
        return this.component;
    }

    public void setComponent(C component) {
        C old = this.component;
        this.component = component;
        this.fireContentChanged((Component)old, (Component)component);
    }

    public List<DocumentDataListener> getListeners() {
        return CollectionUtils.copy(this.listeners);
    }

    public void addListener(DocumentDataListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DocumentDataListener listener) {
        this.listeners.remove(listener);
    }

    public void fireTitleChanged() {
        for (DocumentDataListener listener : CollectionUtils.copy(this.listeners)) {
            listener.titleChanged(this);
        }
    }

    public void fireBackgroundChanged(Color oldBackground, Color newBackground) {
        for (DocumentDataListener listener : CollectionUtils.copy(this.listeners)) {
            listener.backgroundChanged(this, oldBackground, newBackground);
        }
    }

    public void fireContentChanged(Component oldComponent, Component newComponent) {
        for (DocumentDataListener listener : CollectionUtils.copy(this.listeners)) {
            listener.contentChanged(this, oldComponent, newComponent);
        }
    }
}

