/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.zoom;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionUtils;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.extended.transition.effects.zoom.ZoomType;
import com.alee.utils.GraphicsUtils;
import java.awt.Composite;
import java.awt.Graphics2D;

public class ZoomTransitionEffect
extends DefaultTransitionEffect {
    private static final String ZOOM_MINIMUM_SPEED = "ZOOM_MINIMUM_SPEED";
    private static final String ZOOM_SPEED = "ZOOM_SPEED";
    private static final String ZOOM_FADE = "ZOOM_FADE";
    private static final String ZOOM_TYPE = "ZOOM_TYPE";
    private float minimumSpeed;
    private float speed;
    private ZoomType type;
    private float size;

    public float getMinimumSpeed() {
        return this.get(ZOOM_MINIMUM_SPEED, Float.valueOf(0.02f)).floatValue();
    }

    public void setMinimumSpeed(float speed) {
        this.put(ZOOM_MINIMUM_SPEED, Float.valueOf(speed));
    }

    public float getSpeed() {
        return this.get(ZOOM_SPEED, Float.valueOf(0.1f)).floatValue();
    }

    public void setSpeed(float speed) {
        this.put(ZOOM_SPEED, Float.valueOf(speed));
    }

    public boolean isFade() {
        return this.get(ZOOM_FADE, true);
    }

    public void setFade(boolean transparent) {
        this.put(ZOOM_FADE, transparent);
    }

    public ZoomType getType() {
        return this.get(ZOOM_TYPE, ZoomType.random);
    }

    public void setType(ZoomType type) {
        this.put(ZOOM_TYPE, (Object)type);
    }

    @Override
    public void prepareAnimation(ImageTransition imageTransition) {
        this.minimumSpeed = this.getMinimumSpeed();
        this.speed = this.getSpeed();
        this.type = TransitionUtils.getActualValue(this.getType());
        this.size = 0.0f;
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        if (this.size < 1.0f) {
            this.size = Math.min(this.size + this.getCurrentSpeed(), 1.0f);
            imageTransition.repaint();
            return false;
        }
        return true;
    }

    private float getCurrentSpeed() {
        return Math.max(this.minimumSpeed, this.speed * (float)Math.sqrt((1.0f - this.size) / 1.0f));
    }

    @Override
    public void paint(Graphics2D g2d, ImageTransition transition) {
        int tw = transition.getWidth();
        int th = transition.getHeight();
        if (this.type.equals((Object)ZoomType.zoomIn)) {
            g2d.drawImage(transition.getCurrentImage(), 0, 0, tw, th, null);
            Composite old = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(this.size), (boolean)this.isFade());
            int w = Math.round((float)tw * this.size);
            int h = Math.round((float)th * this.size);
            g2d.drawImage(transition.getOtherImage(), tw / 2 - w / 2, th / 2 - h / 2, w, h, null);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)old, (boolean)this.isFade());
        } else {
            g2d.drawImage(transition.getOtherImage(), 0, 0, tw, th, null);
            Composite old = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(1.0f - this.size), (boolean)this.isFade());
            int w = Math.round((float)tw * (1.0f - this.size));
            int h = Math.round((float)th * (1.0f - this.size));
            g2d.drawImage(transition.getCurrentImage(), tw / 2 - w / 2, th / 2 - h / 2, w, h, null);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)old, (boolean)this.isFade());
        }
    }
}

