/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.laf.button.AdaptiveToggleButtonPainter;
import com.alee.laf.button.IToggleButtonPainter;
import com.alee.laf.button.ToggleButtonPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class WebToggleButtonUI
extends BasicToggleButtonUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport,
SwingConstants {
    @DefaultPainter(value=ToggleButtonPainter.class)
    protected IToggleButtonPainter painter;
    protected AbstractButton button;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebToggleButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.button = (AbstractButton)c;
        StyleManager.installSkin(this.button);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.button);
        this.button = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.button);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.button, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.button, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.button, new DataRunnable<IToggleButtonPainter>(){

            public void run(IToggleButtonPainter newPainter) {
                WebToggleButtonUI.this.painter = newPainter;
            }
        }, this.painter, painter, IToggleButtonPainter.class, AdaptiveToggleButtonPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

