/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.laf.combobox.IComboBoxPainter;
import com.alee.laf.combobox.WebComboBoxUI;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.CompareUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.PopupMenuAdapter;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;

public class ComboBoxPainter<E extends JComboBox, U extends WebComboBoxUI, D extends IDecoration<E, D>>
extends AbstractDecorationPainter<E, U, D>
implements IComboBoxPainter<E, U> {
    protected PopupMenuAdapter menuListener;
    protected MouseWheelListener mouseWheelListener = null;
    protected CellRendererPane currentValuePane = null;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.menuListener = new PopupMenuAdapter(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ComboBoxPainter.this.updateDecorationState();
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ComboBoxPainter.this.updateDecorationState();
                    }
                });
            }
        };
        ((JComboBox)this.component).addPopupMenuListener(this.menuListener);
        this.mouseWheelListener = new MouseWheelListener((WebComboBoxUI)ui){
            final /* synthetic */ WebComboBoxUI val$ui;
            {
                this.val$ui = webComboBoxUI;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int index;
                int newIndex;
                if (this.val$ui.isMouseWheelScrollingEnabled() && ((JComboBox)ComboBoxPainter.this.component).isEnabled() && ComboBoxPainter.this.isFocused() && (newIndex = MathUtils.limit((int)0, (int)((index = ((JComboBox)ComboBoxPainter.this.component).getSelectedIndex()) + e.getWheelRotation()), (int)(((JComboBox)ComboBoxPainter.this.component).getModel().getSize() - 1))) != index) {
                    ((JComboBox)ComboBoxPainter.this.component).setSelectedIndex(newIndex);
                }
            }
        };
        ((JComboBox)this.component).addMouseWheelListener(this.mouseWheelListener);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((JComboBox)this.component).removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        ((JComboBox)this.component).removePopupMenuListener(this.menuListener);
        this.menuListener = null;
        super.uninstall(c, ui);
    }

    @Override
    protected void propertyChange(String property, Object oldValue, Object newValue) {
        super.propertyChange(property, oldValue, newValue);
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"enabled"})) {
            ((WebComboBoxUI)this.ui).getListBox().setEnabled(((JComboBox)this.component).isEnabled());
        }
    }

    @Override
    protected List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        states.add(((WebComboBoxUI)this.ui).isPopupVisible((JComboBox)this.component) ? "expanded" : "collapsed");
        return states;
    }

    @Override
    public void prepareToPaint(CellRendererPane currentValuePane) {
        this.currentValuePane = currentValuePane;
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        this.paintCurrentValue(g2d, ((WebComboBoxUI)ui).getValueBounds());
        this.cleanupAfterPaint();
    }

    protected void cleanupAfterPaint() {
        this.currentValuePane = null;
    }

    protected void paintCurrentValue(Graphics2D g2d, Rectangle bounds) {
        if (!((JComboBox)this.component).isEditable()) {
            Component c;
            ListCellRenderer<Object> renderer = ((JComboBox)this.component).getRenderer();
            if (this.isFocused() && !((JComboBox)this.component).isPopupVisible()) {
                c = renderer.getListCellRendererComponent(((WebComboBoxUI)this.ui).getListBox(), ((JComboBox)this.component).getSelectedItem(), -1, true, false);
            } else {
                c = renderer.getListCellRendererComponent(((WebComboBoxUI)this.ui).getListBox(), ((JComboBox)this.component).getSelectedItem(), -1, false, false);
                c.setBackground(UIManager.getColor("ComboBox.background"));
            }
            c.setFont(((JComboBox)this.component).getFont());
            if (((JComboBox)this.component).isEnabled()) {
                c.setForeground(((JComboBox)this.component).getForeground());
                c.setBackground(((JComboBox)this.component).getBackground());
            } else {
                c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
            boolean shouldValidate = false;
            if (c instanceof JPanel) {
                shouldValidate = true;
            }
            int x = bounds.x;
            int y = bounds.y;
            int w = bounds.width;
            int h = bounds.height;
            this.currentValuePane.paintComponent(g2d, c, this.component, x, y, w, h, shouldValidate);
        }
    }
}

