/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.grouping;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.grouping.GroupingLayout;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.UnselectableButtonGroup;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

public abstract class AbstractGroupingLayout
extends AbstractLayoutManager
implements GroupingLayout {
    @XStreamAsAttribute
    protected Boolean group;
    @XStreamAsAttribute
    protected Boolean groupButtons;
    @XStreamAsAttribute
    protected String sides;
    protected transient Map<Component, Pair<String, String>> children;
    protected transient UnselectableButtonGroup buttonGroup;

    @Override
    public boolean isGrouping() {
        return this.group == null || this.group != false;
    }

    public void setGroup(boolean group) {
        if (this.isGrouping() != group) {
            this.group = group;
            this.resetDescriptors();
        }
    }

    public boolean isGroupButtons() {
        return this.groupButtons == null || this.groupButtons != false;
    }

    public void setGroupButtons(boolean group) {
        if (this.isGroupButtons() != group) {
            this.groupButtons = group;
            this.updateButtonGrouping();
        }
    }

    protected UnselectableButtonGroup createButtonGroup() {
        return new UnselectableButtonGroup(false);
    }

    protected void clearGrouping() {
        if (this.buttonGroup != null) {
            this.buttonGroup.removeAll();
            this.buttonGroup = null;
        }
    }

    protected void updateButtonGrouping() {
        this.clearGrouping();
        if (this.isGroupButtons()) {
            this.buttonGroup = this.createButtonGroup();
            if (this.children != null) {
                for (Map.Entry<Component, Pair<String, String>> entry : this.children.entrySet()) {
                    Component component = entry.getKey();
                    if (!this.isGroupable(component)) continue;
                    this.buttonGroup.add((AbstractButton)component);
                }
            }
        }
    }

    protected boolean isGroupable(Component component) {
        return component != null && (component instanceof JToggleButton || component instanceof JCheckBox || component instanceof JCheckBoxMenuItem || component instanceof JRadioButton || component instanceof JRadioButtonMenuItem);
    }

    public UnselectableButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    protected String sides() {
        return this.sides != null ? this.sides : (this.sides = "1,1,1,1");
    }

    public boolean isPaintTop() {
        return this.sides().charAt(0) != '0';
    }

    public void setPaintTop(boolean paint) {
        TextUtils.replace((String)this.sides(), (int)6, (char)(paint ? (char)'1' : '0'));
        this.resetDescriptors();
    }

    public boolean isPaintLeft() {
        return this.sides().charAt(2) != '0';
    }

    public void setPaintLeft(boolean paint) {
        TextUtils.replace((String)this.sides(), (int)6, (char)(paint ? (char)'1' : '0'));
        this.resetDescriptors();
    }

    public boolean isPaintBottom() {
        return this.sides().charAt(4) != '0';
    }

    public void setPaintBottom(boolean paint) {
        TextUtils.replace((String)this.sides(), (int)6, (char)(paint ? (char)'1' : '0'));
        this.resetDescriptors();
    }

    public boolean isPaintRight() {
        return this.sides().charAt(6) != '0';
    }

    public void setPaintRight(boolean paint) {
        TextUtils.replace((String)this.sides(), (int)6, (char)(paint ? (char)'1' : '0'));
        this.resetDescriptors();
    }

    public void setPaintSides(boolean top, boolean left, boolean bottom, boolean right) {
        this.sides = DecorationUtils.toString(top, left, bottom, right);
        this.resetDescriptors();
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        if (this.children == null) {
            this.children = new WeakHashMap<Component, Pair<String, String>>(3);
        }
        this.children.put(component, (Pair<String, String>)new Pair());
        if (this.isGroupable(component)) {
            this.updateButtonGrouping();
        }
        this.resetDescriptors();
    }

    @Override
    public void removeComponent(Component component) {
        if (this.children != null) {
            this.children.remove(component);
        }
        if (this.isGroupable(component)) {
            this.updateButtonGrouping();
        }
        this.resetDescriptors();
    }

    @Override
    public final String getSides(Component component) {
        return this.children != null ? (String)this.getDescriptors(component).getKey() : null;
    }

    @Override
    public final String getLines(Component component) {
        return this.children != null ? (String)this.getDescriptors(component).getValue() : null;
    }

    private Pair<String, String> getDescriptors(Component component) {
        Pair<String, String> pair = this.children.get(component);
        if (pair == null || pair.getKey() == null) {
            Container parent = component.getParent();
            pair = parent != null && this.isGrouping() ? this.getDescriptors(parent, component, SwingUtils.indexOf(parent, component)) : new Pair<String, String>();
            this.children.put(component, pair);
        }
        return pair;
    }

    protected abstract Pair<String, String> getDescriptors(Container var1, Component var2, int var3);

    protected void resetDescriptors() {
        if (this.children != null) {
            for (Map.Entry<Component, Pair<String, String>> entry : this.children.entrySet()) {
                entry.setValue((Pair<String, String>)new Pair());
            }
        }
    }
}

