/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.ColorSupport;
import com.alee.api.IconSupport;
import com.alee.api.TitleSupport;
import com.alee.extended.label.WebStyledLabel;
import com.alee.managers.style.StyleId;
import com.alee.utils.TextUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WebListCellRenderer
extends WebStyledLabel
implements ListCellRenderer {
    public static final String ID_PREFIX = "WLCR";
    protected String id;

    public WebListCellRenderer() {
        this.setId();
        this.setName("List.cellRenderer");
    }

    private void setId() {
        this.id = TextUtils.generateId((String)ID_PREFIX);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setStyleId(this.getStyleId(list, value, index, isSelected, cellHasFocus));
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setComponentOrientation(list.getComponentOrientation());
        if (value instanceof ColorSupport) {
            Color color = ((ColorSupport)value).getColor();
            if (color != null) {
                this.setForeground(color);
            } else {
                this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            }
        } else {
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        }
        Icon icon = value instanceof IconSupport ? ((IconSupport)value).getIcon() : (value instanceof Icon ? (Icon)value : null);
        this.setIcon(icon);
        String text = value instanceof TitleSupport ? this.getCheckedText(icon, ((TitleSupport)value).getTitle()) : this.getCheckedText(icon, value);
        this.setText(text);
        return this;
    }

    protected String getCheckedText(Icon icon, Object value) {
        if (value == null || TextUtils.isEmpty((String)value.toString())) {
            return icon == null ? " " : "";
        }
        return value instanceof Icon ? "" : value.toString();
    }

    protected StyleId getStyleId(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return this.getIcon() != null ? StyleId.listIconCellRenderer.at(list) : StyleId.listTextCellRenderer.at(list);
    }

    public static class UIResource
    extends WebListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

