/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.laf.list.AdaptiveListPainter;
import com.alee.laf.list.IListPainter;
import com.alee.laf.list.ListItemHoverBehavior;
import com.alee.laf.list.ListPainter;
import com.alee.laf.list.ListSelectionStyle;
import com.alee.laf.list.WebList;
import com.alee.laf.list.WebListModel;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CompareUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class WebListUI
extends BasicListUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    public static final int heightChanged = 256;
    public static final int widthChanged = 512;
    protected ListSelectionStyle selectionStyle;
    protected boolean selectOnHover;
    protected boolean scrollToSelection;
    protected ListSelectionListener selectionTracker;
    protected ListItemHoverBehavior hoverCellTracker;
    @DefaultPainter(value=ListPainter.class)
    protected IListPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;
    protected int hoverIndex = -1;

    public static ComponentUI createUI(JComponent c) {
        return new WebListUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.selectionTracker = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (WebListUI.this.isScrollToSelection() && WebListUI.this.list.getSelectedIndex() != -1) {
                    int index = WebListUI.this.list.getLeadSelectionIndex();
                    Rectangle selection = WebListUI.this.getCellBounds(WebListUI.this.list, index, index);
                    if (selection != null && !selection.intersects(WebListUI.this.list.getVisibleRect())) {
                        WebListUI.this.list.scrollRectToVisible(selection);
                    }
                }
            }
        };
        this.list.addListSelectionListener(this.selectionTracker);
        this.hoverCellTracker = new ListItemHoverBehavior(this.list, true){

            @Override
            public void hoverChanged(Object previous, Object current) {
                ToolTipProvider<? extends WebList> provider;
                int previousIndex = WebListUI.this.hoverIndex;
                WebListUI.this.hoverIndex = this.indexOf(current);
                if (WebListUI.this.selectOnHover) {
                    if (current != null) {
                        WebListUI.this.list.setSelectedIndex(WebListUI.this.hoverIndex);
                    } else {
                        WebListUI.this.list.clearSelection();
                    }
                }
                if (WebListUI.this.painter != null && WebListUI.this.painter.isHoverDecorationSupported()) {
                    this.repaintCell(previousIndex);
                    this.repaintCell(WebListUI.this.hoverIndex);
                }
                if ((provider = WebListUI.this.getToolTipProvider()) != null) {
                    provider.hoverCellChanged((WebList)WebListUI.this.list, previousIndex, 0, WebListUI.this.hoverIndex, 0);
                }
                if (WebListUI.this.list instanceof WebList) {
                    ((WebList)WebListUI.this.list).fireHoverChanged(previous, current);
                }
            }

            protected int indexOf(Object current) {
                ListModel model = WebListUI.this.list.getModel();
                if (model instanceof WebListModel) {
                    return ((WebListModel)model).indexOf(current);
                }
                for (int i = 0; i < model.getSize(); ++i) {
                    if (!CompareUtils.equals(model.getElementAt(i), (Object[])new Object[]{current})) continue;
                    return i;
                }
                return -1;
            }

            private void repaintCell(int index) {
                Rectangle cellBounds;
                if (index != -1 && (cellBounds = WebListUI.this.list.getCellBounds(index, index)) != null) {
                    WebListUI.this.list.repaint(cellBounds);
                }
            }
        };
        this.hoverCellTracker.install();
        StyleManager.installSkin(this.list);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.list);
        this.hoverCellTracker.uninstall();
        this.hoverCellTracker = null;
        this.list.removeListSelectionListener(this.selectionTracker);
        this.selectionTracker = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.list);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.list, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.list, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.list, new DataRunnable<IListPainter>(){

            public void run(IListPainter newPainter) {
                WebListUI.this.painter = newPainter;
            }
        }, this.painter, painter, IListPainter.class, AdaptiveListPainter.class);
    }

    public int getHoverIndex() {
        return this.hoverIndex;
    }

    public ListSelectionStyle getSelectionStyle() {
        return this.selectionStyle;
    }

    public void setSelectionStyle(ListSelectionStyle style) {
        this.selectionStyle = style;
    }

    public boolean isSelectOnHover() {
        return this.selectOnHover;
    }

    public void setSelectOnHover(boolean select) {
        this.selectOnHover = select;
    }

    public boolean isScrollToSelection() {
        return this.scrollToSelection;
    }

    public void setScrollToSelection(boolean scroll) {
        this.scrollToSelection = scroll;
    }

    public void requestLayoutStateUpdate() {
        ++this.updateLayoutStateNeeded;
    }

    public CellRendererPane getCellRendererPane() {
        return this.rendererPane;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.validateListLayout();
            this.painter.prepareToPaint(this.getLayoutOrientation(), this.getListHeight(), this.getListWidth(), this.getColumnCount(), this.getRowsPerColumn(), this.getPreferredHeight(), this.cellWidth, this.cellHeight, this.cellHeights);
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    protected void validateListLayout() {
        switch (this.getLayoutOrientation()) {
            case 1: {
                if (this.list.getHeight() == this.getListHeight().intValue()) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.getListWidth().intValue()) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
    }

    public void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected Integer getLayoutOrientation() {
        return (Integer)this.getBasicListUIValue("layoutOrientation");
    }

    protected Integer getListHeight() {
        return (Integer)this.getBasicListUIValue("listHeight");
    }

    protected Integer getListWidth() {
        return (Integer)this.getBasicListUIValue("listWidth");
    }

    protected Integer getColumnCount() {
        return (Integer)this.getBasicListUIValue("columnCount");
    }

    protected Integer getRowsPerColumn() {
        return (Integer)this.getBasicListUIValue("rowsPerColumn");
    }

    protected Integer getPreferredHeight() {
        return (Integer)this.getBasicListUIValue("preferredHeight");
    }

    protected <T> T getBasicListUIValue(String field) {
        return (T)ReflectUtils.getFieldValueSafely((Object)this, (String)field);
    }

    protected ToolTipProvider<? extends WebList> getToolTipProvider() {
        return this.list != null && this.list instanceof WebList ? ((WebList)this.list).getToolTipProvider() : null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

