/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.global.StyleConstants;
import com.alee.laf.menu.AbstractMenuItemPainter;
import com.alee.laf.menu.IMenuPainter;
import com.alee.laf.menu.MenuUtils;
import com.alee.laf.menu.WebMenuUI;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.View;

public class MenuPainter<E extends JMenu, U extends WebMenuUI>
extends AbstractMenuItemPainter<E, U>
implements IMenuPainter<E, U> {
    public static final ImageIcon arrowRightIcon = new ImageIcon(WebMenuUI.class.getResource("icons/arrowRight.png"));
    public static final ImageIcon arrowLeftIcon = new ImageIcon(WebMenuUI.class.getResource("icons/arrowLeft.png"));
    protected int round = 2;
    protected int shadeWidth = 2;
    protected int arrowGap = 15;
    protected MouseAdapter mouseAdapter;
    protected boolean mouseover = false;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MenuPainter.this.mouseover = true;
                ((JMenu)MenuPainter.this.component).repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MenuPainter.this.mouseover = false;
                ((JMenu)MenuPainter.this.component).repaint();
            }
        };
        ((JMenu)this.component).addMouseListener(this.mouseAdapter);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((JMenu)this.component).removeMouseListener(this.mouseAdapter);
        this.mouseAdapter = null;
        super.uninstall(c, ui);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        Icon arrowIcon;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        int w = ((JMenu)this.component).getWidth();
        int h = ((JMenu)this.component).getHeight();
        Insets bi = ((JMenu)this.component).getInsets();
        int y = bi.top;
        int ih = h - bi.top - bi.bottom;
        ButtonModel model = ((JMenu)this.component).getModel();
        boolean selected = ((JMenu)this.component).isEnabled() && (model.isArmed() || model.isSelected());
        this.paintBackground(g2d, selected);
        int iconPlaceholderWidth = MenuUtils.getIconPlaceholderWidth((JMenuItem)this.component, this.alignTextToMenuIcons);
        int gap = iconPlaceholderWidth > 0 ? ((JMenu)this.component).getIconTextGap() : 0;
        int x = this.ltr ? bi.left : w - bi.right - iconPlaceholderWidth;
        this.paintIcon(g2d, x, y, iconPlaceholderWidth, ih, selected);
        x += this.ltr ? iconPlaceholderWidth + gap : -gap;
        String text = ((JMenu)this.component).getText();
        if (text != null && text.length() > 0) {
            Map hints = SwingUtils.setupTextAntialias(g2d);
            FontMetrics fm = ((JMenu)this.component).getFontMetrics(((JMenu)this.component).getFont());
            View html = (View)((JMenu)this.component).getClientProperty("html");
            int tw = html != null ? (int)html.getPreferredSpan(0) : fm.stringWidth(text);
            this.paintText(g2d, fm, x -= this.ltr ? 0 : tw, y, tw, ih, selected);
            SwingUtils.restoreTextAntialias(g2d, hints);
        }
        if ((arrowIcon = this.getArrowIcon((JMenu)this.component)) != null) {
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(0.4f), (boolean)selected);
            arrowIcon.paintIcon(this.component, g2d, this.ltr ? w - bi.right - arrowIcon.getIconWidth() : bi.left, y + ih / 2 - arrowIcon.getIconHeight() / 2);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (boolean)selected);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    @Override
    protected void paintBackground(Graphics2D g2d, boolean selected) {
        if (((JMenu)this.component).getParent() instanceof JPopupMenu) {
            super.paintBackground(g2d, selected);
        } else if (((JMenu)this.component).isEnabled() && (selected || this.mouseover)) {
            LafUtils.drawWebStyle(g2d, this.component, new Color(210, 210, 210), this.shadeWidth, this.round, ((JMenu)this.component).isEnabled(), !selected && this.mouseover, selected ? StyleConstants.averageBorderColor : StyleConstants.borderColor);
        }
    }

    protected Icon getArrowIcon(JMenu menu) {
        if (menu.getParent() instanceof JPopupMenu) {
            if (menu.isEnabled()) {
                return this.ltr ? arrowRightIcon : arrowLeftIcon;
            }
            return this.ltr ? ImageUtils.getDisabledCopy((String)"Menu.arrowRightIcon", (ImageIcon)arrowRightIcon) : ImageUtils.getDisabledCopy((String)"Menu.arrowLeftIcon", (ImageIcon)arrowLeftIcon);
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Icon subMenuArrowIcon = this.getArrowIcon((JMenu)this.component);
        int arrowWidth = subMenuArrowIcon != null ? this.arrowGap + subMenuArrowIcon.getIconWidth() : 0;
        return new Dimension(size.width + arrowWidth, size.height);
    }
}

