/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.menu.AbstractMenuItemPainter;
import com.alee.laf.menu.IRadioButtonMenuItemPainter;
import com.alee.laf.menu.WebRadioButtonMenuItemUI;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class RadioButtonMenuItemPainter<E extends JMenuItem, U extends WebRadioButtonMenuItemUI>
extends AbstractMenuItemPainter<E, U>
implements IRadioButtonMenuItemPainter<E, U> {
    protected static final ImageIcon radioIcon = new ImageIcon(WebRadioButtonMenuItemUI.class.getResource("icons/radio.png"));
    protected static final ImageIcon radioCheckIcon = new ImageIcon(WebRadioButtonMenuItemUI.class.getResource("icons/radioCheck.png"));
    protected Color checkColor = new Color(230, 230, 220);

    @Override
    protected void paintBackground(Graphics2D g2d, boolean selected) {
        super.paintBackground(g2d, selected);
        if (!selected && ((JMenuItem)this.component).isSelected() && this.checkColor != null) {
            g2d.setPaint(this.checkColor);
            g2d.fillRect(0, 0, ((JMenuItem)this.component).getWidth(), ((JMenuItem)this.component).getHeight());
        }
    }

    @Override
    protected void paintIcon(Graphics2D g2d, int x, int y, int w, int h, boolean selected) {
        super.paintIcon(g2d, x, y, w, h, selected);
        if (((JMenuItem)this.component).getIcon() == null) {
            int ix = x + w / 2 - radioIcon.getIconWidth() / 2;
            int iy = y + h / 2 - radioIcon.getIconHeight() / 2;
            g2d.drawImage(((JMenuItem)this.component).isSelected() ? radioCheckIcon.getImage() : radioIcon.getImage(), ix, iy, null);
        }
    }
}

