/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.optionpane;

import com.alee.laf.button.WebButton;
import com.alee.laf.optionpane.AdaptiveOptionPanePainter;
import com.alee.laf.optionpane.IOptionPanePainter;
import com.alee.laf.optionpane.OptionPanePainter;
import com.alee.managers.language.LM;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class WebOptionPaneUI
extends BasicOptionPaneUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    public static final ImageIcon INFORMATION_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/information.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/warning.png"));
    public static final ImageIcon ERROR_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/error.png"));
    public static final ImageIcon QUESTION_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/question.png"));
    @DefaultPainter(value=OptionPanePainter.class)
    protected IOptionPanePainter painter;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebOptionPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.optionPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.optionPane);
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.optionPane);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.optionPane, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.optionPane, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    protected Container createMessageArea() {
        Container messageArea = super.createMessageArea();
        SwingUtils.setOpaqueRecursively(messageArea, false);
        return messageArea;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(false);
        }
        if (buttons != null && buttons.length > 0) {
            boolean sizeButtonsToSame = this.getSizeButtonsToSameWidth();
            boolean createdAll = true;
            int numButtons = buttons.length;
            JButton[] createdButtons = null;
            int maxWidth = 0;
            if (sizeButtonsToSame) {
                createdButtons = new JButton[numButtons];
            }
            for (int counter = 0; counter < numButtons; ++counter) {
                Component newComponent;
                Object button = buttons[counter];
                if (button instanceof Component) {
                    createdAll = false;
                    newComponent = (Component)button;
                    container.add(newComponent);
                    this.hasCustomComponents = true;
                } else {
                    WebButton aButton;
                    if (button instanceof Icon) {
                        aButton = new WebButton((Icon)button);
                    } else {
                        String text = button.toString();
                        aButton = new WebButton(text);
                        if (LM.contains((String)text)) {
                            aButton.setLanguage(text, new Object[0]);
                        }
                    }
                    aButton.setName("OptionPane.button");
                    aButton.setMultiClickThreshhold(UIManager.getInt("OptionPane.buttonClickThreshold"));
                    this.configureButton(aButton);
                    container.add(aButton);
                    ActionListener buttonListener = this.createButtonActionListener(counter);
                    if (buttonListener != null) {
                        aButton.addActionListener(buttonListener);
                    }
                    newComponent = aButton;
                }
                if (sizeButtonsToSame && createdAll && newComponent instanceof JButton) {
                    createdButtons[counter] = (JButton)newComponent;
                    maxWidth = Math.max(maxWidth, newComponent.getMinimumSize().width);
                }
                if (counter != initialIndex) continue;
                this.initialFocusComponent = newComponent;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                JButton defaultB = (JButton)this.initialFocusComponent;
                defaultB.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        JButton defaultButton;
                        JRootPane root;
                        if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                            root.setDefaultButton(defaultButton);
                        }
                    }
                });
            }
            ((BasicOptionPaneUI.ButtonAreaLayout)container.getLayout()).setSyncAllWidths(sizeButtonsToSame && createdAll);
        }
    }

    @Override
    protected Object[] getButtons() {
        JOptionPane op = this.optionPane;
        if (op != null) {
            Object[] suppliedOptions = op.getOptions();
            if (suppliedOptions == null) {
                int type = op.getOptionType();
                Object[] defaultOptions = type == 0 ? new WebButton[]{new WebButton(StyleId.optionpaneYesButton.at(op), "weblaf.optionpane.yes"), new WebButton(StyleId.optionpaneNoButton.at(op), "weblaf.optionpane.no")} : (type == 1 ? new WebButton[]{new WebButton(StyleId.optionpaneYesButton.at(op), "weblaf.optionpane.yes"), new WebButton(StyleId.optionpaneNoButton.at(op), "weblaf.optionpane.no"), new WebButton(StyleId.optionpaneCancelButton.at(op), "weblaf.optionpane.cancel")} : (type == 2 ? new WebButton[]{new WebButton(StyleId.optionpaneOkButton.at(op), "weblaf.optionpane.ok"), new WebButton(StyleId.optionpaneCancelButton.at(op), "weblaf.optionpane.cancel")} : new WebButton[]{new WebButton(StyleId.optionpaneOkButton.at(op), "weblaf.optionpane.ok")}));
                for (int i = 0; i < defaultOptions.length; ++i) {
                    this.configureButton((WebButton)defaultOptions[i]);
                    ((AbstractButton)defaultOptions[i]).addActionListener(this.createButtonActionListener(i));
                }
                return defaultOptions;
            }
            return suppliedOptions;
        }
        return null;
    }

    private void configureButton(WebButton button) {
        button.setMinimumSize(new Dimension(70, 0));
        Font buttonFont = UIManager.getFont("OptionPane.buttonFont");
        if (buttonFont != null) {
            button.setFont(buttonFont);
        }
    }

    @Override
    protected Icon getIconForType(int messageType) {
        return WebOptionPaneUI.getTypeIcon(messageType);
    }

    public static ImageIcon getTypeIcon(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return ERROR_ICON;
            }
            case 1: {
                return INFORMATION_ICON;
            }
            case 2: {
                return WARNING_ICON;
            }
            case 3: {
                return QUESTION_ICON;
            }
        }
        return null;
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.optionPane, new DataRunnable<IOptionPanePainter>(){

            public void run(IOptionPanePainter newPainter) {
                WebOptionPaneUI.this.painter = newPainter;
            }
        }, this.painter, painter, IOptionPanePainter.class, AdaptiveOptionPanePainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

