/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.progressbar;

import com.alee.global.StyleConstants;
import com.alee.laf.progressbar.IProgressBarPainter;
import com.alee.laf.progressbar.IProgressPainter;
import com.alee.laf.progressbar.ProgressPainter;
import com.alee.laf.progressbar.WebProgressBarUI;
import com.alee.managers.style.Bounds;
import com.alee.painter.DefaultPainter;
import com.alee.painter.PainterSupport;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.CompareUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import java.util.Map;
import javax.swing.JProgressBar;

public class ProgressBarPainter<E extends JProgressBar, U extends WebProgressBarUI, D extends IDecoration<E, D>>
extends AbstractDecorationPainter<E, U, D>
implements IProgressBarPainter<E, U> {
    protected Dimension minimumContentSize;
    @DefaultPainter(value=ProgressPainter.class)
    protected IProgressPainter progressPainter;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.progressPainter = PainterSupport.installSectionPainter(this, this.progressPainter, null, c, ui);
    }

    @Override
    public void uninstall(E c, U ui) {
        this.progressPainter = PainterSupport.uninstallSectionPainter(this.progressPainter, c, ui);
        super.uninstall(c, ui);
    }

    @Override
    protected void propertyChange(String property, Object oldValue, Object newValue) {
        super.propertyChange(property, oldValue, newValue);
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"indeterminate", "orientation"})) {
            this.updateDecorationState();
        }
    }

    @Override
    protected List<SectionPainter<E, U>> getSectionPainters() {
        return this.asList(this.progressPainter);
    }

    @Override
    protected List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (this.isHorizontal()) {
            states.add("horizontal");
        } else {
            states.add("vertical");
        }
        if (((JProgressBar)this.component).isIndeterminate()) {
            states.add("indeterminate");
        }
        return states;
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        this.paintProgress(g2d, Bounds.border.of((Component)c));
        this.paintText(g2d, Bounds.padding.of((Component)c));
    }

    protected void paintProgress(Graphics2D g2d, Rectangle bounds) {
        if (this.progressPainter != null) {
            if (((JProgressBar)this.component).isIndeterminate()) {
                this.progressPainter.paint(g2d, bounds, this.component, this.ui);
            } else {
                boolean hor = this.isHorizontal();
                int min = ((JProgressBar)this.component).getMinimum();
                float progress = (float)(((JProgressBar)this.component).getValue() - min) / (float)(((JProgressBar)this.component).getMaximum() - min);
                int p = Math.round((float)(hor ? bounds.width : bounds.height) * progress);
                Dimension ps = this.progressPainter.getPreferredSize();
                if (p > (hor ? ps.width : ps.height)) {
                    if (hor) {
                        if (!this.ltr) {
                            bounds.x = bounds.x + bounds.width - p;
                        }
                        bounds.width = p;
                    } else {
                        if (this.ltr) {
                            bounds.y = bounds.y + bounds.height - p;
                        }
                        bounds.height = p;
                    }
                    this.progressPainter.paint(g2d, bounds, this.component, this.ui);
                }
            }
        }
    }

    protected void paintText(Graphics2D g2d, Rectangle bounds) {
        if (((JProgressBar)this.component).isStringPainted()) {
            Map aa = SwingUtils.setupTextAntialias(g2d);
            Shape oc = GraphicsUtils.setupClip((Graphics2D)g2d, (Shape)bounds);
            Point mid = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
            boolean hor = this.isHorizontal();
            if (!hor) {
                g2d.translate(mid.x, mid.y);
                g2d.rotate((double)(this.ltr ? -1 : 1) * Math.PI / 2.0);
                g2d.translate(-mid.x, -mid.y);
            }
            String string = ((JProgressBar)this.component).getString();
            Point ts = LafUtils.getTextCenterShift(g2d.getFontMetrics(), string);
            if (!((JProgressBar)this.component).isEnabled()) {
                g2d.setPaint(Color.WHITE);
                g2d.drawString(string, mid.x + ts.x + 1, mid.y + ts.y + 1);
            }
            g2d.setPaint(((JProgressBar)this.component).isEnabled() ? ((JProgressBar)this.component).getForeground() : StyleConstants.disabledTextColor);
            g2d.drawString(string, mid.x + ts.x, mid.y + ts.y);
            if (!hor) {
                g2d.rotate((double)(this.ltr ? 1 : -1) * Math.PI / 2.0);
            }
            GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)oc);
            SwingUtils.restoreTextAntialias(g2d, aa);
        }
    }

    protected Dimension getMinimumContentSize() {
        if (this.component != null && this.minimumContentSize != null) {
            boolean hor = this.isHorizontal();
            return new Dimension(hor ? this.minimumContentSize.width : this.minimumContentSize.height, hor ? this.minimumContentSize.height : this.minimumContentSize.width);
        }
        return new Dimension();
    }

    protected boolean isHorizontal() {
        return ((JProgressBar)this.component).getOrientation() == 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension min = this.getMinimumContentSize();
        int w = min.width;
        int h = min.height;
        if (((JProgressBar)this.component).isStringPainted()) {
            boolean hor = this.isHorizontal();
            FontMetrics fontSizer = ((JProgressBar)this.component).getFontMetrics(((JProgressBar)this.component).getFont());
            String progString = ((JProgressBar)this.component).getString();
            int stringWidth = SwingUtils.stringWidth(fontSizer, progString);
            int stringHeight = fontSizer.getHeight() + fontSizer.getDescent();
            w = Math.max(w, hor ? stringWidth : stringHeight);
            h = Math.max(h, hor ? stringHeight : stringWidth);
        }
        Insets border = ((JProgressBar)this.component).getInsets();
        return new Dimension(border.left + w + border.right, border.top + h + border.bottom);
    }
}

