/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.radiobutton;

import com.alee.laf.radiobutton.AdaptiveRadioButtonPainter;
import com.alee.laf.radiobutton.IRadioButtonPainter;
import com.alee.laf.radiobutton.RadioButtonPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class WebRadioButtonUI
extends BasicRadioButtonUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=RadioButtonPainter.class)
    protected IRadioButtonPainter painter;
    protected JRadioButton radioButton;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebRadioButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.radioButton = (JRadioButton)c;
        StyleManager.installSkin(this.radioButton);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.radioButton);
        this.radioButton = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.radioButton);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.radioButton, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.radioButton, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.radioButton, new DataRunnable<IRadioButtonPainter>(){

            public void run(IRadioButtonPainter newPainter) {
                WebRadioButtonUI.this.painter = newPainter;
            }
        }, this.painter, painter, IRadioButtonPainter.class, AdaptiveRadioButtonPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    public Rectangle getIconRect() {
        if (this.painter != null) {
            return this.painter.getIconRect();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

