/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.laf.grouping.GroupPane;
import com.alee.laf.rootpane.WebRootPane;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.EventUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.WindowUtils;
import com.alee.utils.swing.ComponentEventRunnable;
import com.alee.utils.swing.WindowCloseAdapter;
import com.alee.utils.swing.WindowEventMethods;
import com.alee.utils.swing.WindowEventRunnable;
import com.alee.utils.swing.WindowMethods;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class WebFrame
extends JFrame
implements Styleable,
Skinnable,
Paintable,
PaddingSupport,
WindowEventMethods,
LanguageMethods,
LanguageContainerMethods,
SettingsMethods,
WindowMethods<WebFrame> {
    protected boolean closeOnFocusLoss = false;
    protected DefaultFocusTracker focusTracker;

    public WebFrame() {
        this(StyleId.frame);
    }

    public WebFrame(GraphicsConfiguration gc) {
        this(StyleId.frame, gc);
    }

    public WebFrame(String title) {
        this(StyleId.frame, title);
    }

    public WebFrame(String title, GraphicsConfiguration gc) {
        this(StyleId.frame, title, gc);
    }

    public WebFrame(StyleId id) {
        this.initialize(id);
    }

    public WebFrame(StyleId id, GraphicsConfiguration gc) {
        super(gc);
        this.initialize(id);
    }

    public WebFrame(StyleId id, String title) {
        super(LanguageUtils.getInitialText((String)title, (Object[])new Object[0]));
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)title, (Object[])new Object[0]);
        this.initialize(id);
    }

    public WebFrame(StyleId id, String title, GraphicsConfiguration gc) {
        super(LanguageUtils.getInitialText((String)title, (Object[])new Object[0]), gc);
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)title, (Object[])new Object[0]);
        this.initialize(id);
    }

    protected void initialize(StyleId id) {
        SwingUtils.setOrientation(this);
        if (id != null) {
            this.setStyleId(id);
        }
        this.focusTracker = new DefaultFocusTracker(true){

            @Override
            public boolean isTrackingEnabled() {
                return WebFrame.this.closeOnFocusLoss;
            }

            @Override
            public void focusChanged(boolean focused) {
                if (WebFrame.this.closeOnFocusLoss && WebFrame.this.isShowing() && !focused) {
                    WebFrame.this.setVisible(false);
                }
            }
        };
        FocusManager.addFocusTracker(this, this.focusTracker);
    }

    @Override
    protected JRootPane createRootPane() {
        return new WebRootPane();
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
    }

    public List<Component> getFocusableChildren() {
        return this.focusTracker.getCustomChildren();
    }

    public void addFocusableChild(Component child) {
        this.focusTracker.addCustomChild(child);
    }

    public void removeFocusableChild(Component child) {
        this.focusTracker.removeCustomChild(child);
    }

    public JComponent getTitleComponent() {
        return this.getRootPaneWebUI().getTitleComponent();
    }

    public void setTitleComponent(JComponent title) {
        this.getRootPaneWebUI().setTitleComponent(title);
    }

    public GroupPane getButtonsPanel() {
        return this.getRootPaneWebUI().getButtonsPanel();
    }

    public boolean isDisplayTitleComponent() {
        return this.getRootPaneWebUI().isDisplayTitleComponent();
    }

    public void setDisplayTitleComponent(boolean display) {
        this.getRootPaneWebUI().setDisplayTitleComponent(display);
    }

    public boolean isDisplayWindowButtons() {
        return this.getRootPaneWebUI().isDisplayWindowButtons();
    }

    public void setDisplayWindowButtons(boolean display) {
        this.getRootPaneWebUI().setDisplayWindowButtons(display);
    }

    public boolean isDisplayMinimizeButton() {
        return this.getRootPaneWebUI().isDisplayMinimizeButton();
    }

    public void setDisplayMinimizeButton(boolean display) {
        this.getRootPaneWebUI().setDisplayMinimizeButton(display);
    }

    public boolean isDisplayMaximizeButton() {
        return this.getRootPaneWebUI().isDisplayMaximizeButton();
    }

    public void setDisplayMaximizeButton(boolean display) {
        this.getRootPaneWebUI().setDisplayMaximizeButton(display);
    }

    public boolean isDisplayCloseButton() {
        return this.getRootPaneWebUI().isDisplayCloseButton();
    }

    public void setDisplayCloseButton(boolean display) {
        this.getRootPaneWebUI().setDisplayCloseButton(display);
    }

    public boolean isDisplayMenuBar() {
        return this.getRootPaneWebUI().isDisplayMenuBar();
    }

    public void setDisplayMenuBar(boolean display) {
        this.getRootPaneWebUI().setDisplayMenuBar(display);
    }

    @Override
    public StyleId getStyleId() {
        return this.getRootPaneWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getRootPaneWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this.getRootPane());
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this.getRootPane(), skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this.getRootPane(), skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this.getRootPane());
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this.getRootPane(), listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this.getRootPane(), listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this.getRootPane());
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this.getRootPane());
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this.getRootPane(), id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this.getRootPane(), painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this.getRootPane(), id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this.getRootPane());
    }

    @Override
    public Insets getPadding() {
        return this.getRootPaneWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        ((WebRootPaneUI)this.getRootPane().getUI()).setPadding(padding);
    }

    protected WebRootPaneUI getWebUI() {
        return (WebRootPaneUI)this.getRootPane().getUI();
    }

    protected WebRootPaneUI getRootPaneWebUI() {
        return (WebRootPaneUI)this.getRootPane().getUI();
    }

    @Override
    public WindowAdapter onClosing(WindowEventRunnable runnable) {
        return EventUtils.onClosing(this, runnable);
    }

    @Override
    public WindowCloseAdapter onClose(ComponentEventRunnable runnable) {
        return EventUtils.onClose(this, runnable);
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((JComponent)this.getRootPane(), (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((JComponent)this.getRootPane(), (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((JComponent)this.getRootPane(), (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((JComponent)this.getRootPane());
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((JComponent)this.getRootPane());
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((JComponent)this.getRootPane(), (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((JComponent)this.getRootPane());
    }

    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer((Container)this, (String)key);
    }

    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer((Container)this);
    }

    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey((Container)this);
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((JComponent)this.getRootPane());
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((JComponent)this.getRootPane());
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((JComponent)this.getRootPane());
    }

    @Override
    public WebFrame setWindowOpaque(boolean opaque) {
        return WindowUtils.setWindowOpaque(this, opaque);
    }

    @Override
    public boolean isWindowOpaque() {
        return WindowUtils.isWindowOpaque(this);
    }

    @Override
    public WebFrame setWindowOpacity(float opacity) {
        return WindowUtils.setWindowOpacity(this, opacity);
    }

    @Override
    public float getWindowOpacity() {
        return WindowUtils.getWindowOpacity(this);
    }

    @Override
    public WebFrame center() {
        return WindowUtils.center(this);
    }

    @Override
    public WebFrame center(Component relativeTo) {
        return WindowUtils.center(this, relativeTo);
    }

    @Override
    public WebFrame center(int width, int height) {
        return WindowUtils.center(this, width, height);
    }

    @Override
    public WebFrame center(Component relativeTo, int width, int height) {
        return WindowUtils.center(this, relativeTo, width, height);
    }

    @Override
    public WebFrame packToWidth(int width) {
        return WindowUtils.packToWidth(this, width);
    }

    @Override
    public WebFrame packToHeight(int height) {
        return WindowUtils.packToHeight(this, height);
    }

    @Override
    public WebFrame packAndCenter() {
        return WindowUtils.packAndCenter(this);
    }

    @Override
    public WebFrame packAndCenter(boolean animate) {
        return WindowUtils.packAndCenter(this, animate);
    }
}

