/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.laf.rootpane.WebRootPane;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.EventUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.WindowUtils;
import com.alee.utils.swing.ComponentEventRunnable;
import com.alee.utils.swing.WindowCloseAdapter;
import com.alee.utils.swing.WindowEventMethods;
import com.alee.utils.swing.WindowEventRunnable;
import com.alee.utils.swing.WindowMethods;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JWindow;

public class WebWindow
extends JWindow
implements Styleable,
Skinnable,
Paintable,
PaddingSupport,
WindowEventMethods,
LanguageContainerMethods,
SettingsMethods,
WindowMethods<WebWindow> {
    protected boolean closeOnFocusLoss = false;
    protected DefaultFocusTracker focusTracker;

    public WebWindow() {
        this(StyleId.window);
    }

    public WebWindow(GraphicsConfiguration gc) {
        this(StyleId.window, gc);
    }

    public WebWindow(Component owner) {
        this(StyleId.window, owner);
    }

    public WebWindow(Window owner) {
        this(StyleId.window, owner);
    }

    public WebWindow(Window owner, GraphicsConfiguration gc) {
        this(StyleId.window, owner, gc);
    }

    public WebWindow(Frame owner) {
        this(StyleId.window, owner);
    }

    public WebWindow(StyleId id) {
        this.initialize(id);
    }

    public WebWindow(StyleId id, GraphicsConfiguration gc) {
        super(gc);
        this.initialize(id);
    }

    public WebWindow(StyleId id, Component owner) {
        super(SwingUtils.getWindowAncestor((Component)owner));
        this.initialize(id);
    }

    public WebWindow(StyleId id, Window owner) {
        super(owner);
        this.initialize(id);
    }

    public WebWindow(StyleId id, Window owner, GraphicsConfiguration gc) {
        super(owner, gc);
        this.initialize(id);
    }

    public WebWindow(StyleId id, Frame owner) {
        super(owner);
        this.initialize(id);
    }

    protected void initialize(StyleId id) {
        this.setFocusable(true);
        this.setFocusableWindowState(true);
        SwingUtils.setOrientation(this);
        if (id != null) {
            this.setStyleId(id);
        }
        this.focusTracker = new DefaultFocusTracker(true){

            @Override
            public boolean isTrackingEnabled() {
                return WebWindow.this.isShowing() && WebWindow.this.closeOnFocusLoss;
            }

            @Override
            public void focusChanged(boolean focused) {
                if (WebWindow.this.closeOnFocusLoss && WebWindow.this.isShowing() && !focused) {
                    WebWindow.this.dispose();
                }
            }
        };
        FocusManager.addFocusTracker(this, this.focusTracker);
    }

    @Override
    protected JRootPane createRootPane() {
        return new WebRootPane();
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
    }

    public List<Component> getFocusableChildren() {
        return this.focusTracker.getCustomChildren();
    }

    public void addFocusableChild(Component child) {
        this.focusTracker.addCustomChild(child);
    }

    public void removeFocusableChild(Component child) {
        this.focusTracker.removeCustomChild(child);
    }

    @Override
    public StyleId getStyleId() {
        return this.getRootPaneWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getRootPaneWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this.getRootPane());
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this.getRootPane(), skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this.getRootPane(), skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this.getRootPane());
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this.getRootPane(), listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this.getRootPane(), listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this.getRootPane());
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this.getRootPane());
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this.getRootPane(), id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this.getRootPane(), painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this.getRootPane(), id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this.getRootPane());
    }

    @Override
    public Insets getPadding() {
        return this.getRootPaneWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getRootPaneWebUI().setPadding(padding);
    }

    protected WebRootPaneUI getWebUI() {
        return this.getRootPaneWebUI();
    }

    protected WebRootPaneUI getRootPaneWebUI() {
        return (WebRootPaneUI)this.getRootPane().getUI();
    }

    @Override
    public WindowAdapter onClosing(WindowEventRunnable runnable) {
        return EventUtils.onClosing(this, runnable);
    }

    @Override
    public WindowCloseAdapter onClose(ComponentEventRunnable runnable) {
        return EventUtils.onClose(this, runnable);
    }

    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer((Container)this, (String)key);
    }

    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer((Container)this);
    }

    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey((Container)this);
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((JComponent)this.getRootPane());
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((JComponent)this.getRootPane());
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((JComponent)this.getRootPane());
    }

    @Override
    public WebWindow setWindowOpaque(boolean opaque) {
        return WindowUtils.setWindowOpaque(this, opaque);
    }

    @Override
    public boolean isWindowOpaque() {
        return WindowUtils.isWindowOpaque(this);
    }

    @Override
    public WebWindow setWindowOpacity(float opacity) {
        return WindowUtils.setWindowOpacity(this, opacity);
    }

    @Override
    public float getWindowOpacity() {
        return WindowUtils.getWindowOpacity(this);
    }

    @Override
    public WebWindow center() {
        return WindowUtils.center(this);
    }

    @Override
    public WebWindow center(Component relativeTo) {
        return WindowUtils.center(this, relativeTo);
    }

    @Override
    public WebWindow center(int width, int height) {
        return WindowUtils.center(this, width, height);
    }

    @Override
    public WebWindow center(Component relativeTo, int width, int height) {
        return WindowUtils.center(this, relativeTo, width, height);
    }

    @Override
    public WebWindow packToWidth(int width) {
        return WindowUtils.packToWidth(this, width);
    }

    @Override
    public WebWindow packToHeight(int height) {
        return WindowUtils.packToHeight(this, height);
    }

    @Override
    public WebWindow packAndCenter() {
        return WindowUtils.packAndCenter(this);
    }

    @Override
    public WebWindow packAndCenter(boolean animate) {
        return WindowUtils.packAndCenter(this, animate);
    }
}

