/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.laf.button.WebButton;
import com.alee.laf.scroll.AdaptiveScrollBarPainter;
import com.alee.laf.scroll.IScrollBarPainter;
import com.alee.laf.scroll.ScrollBarPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WebScrollBarUI
extends BasicScrollBarUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    protected boolean paintButtons;
    protected boolean paintTrack;
    protected Dimension minimumThumbSize;
    @DefaultPainter(value=ScrollBarPainter.class)
    protected IScrollBarPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setHandlesEnableStateMark(this.scrollbar);
        StyleManager.installSkin(this.scrollbar);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        final PropertyChangeListener parent = super.createPropertyChangeListener();
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("orientation")) {
                    if (WebScrollBarUI.this.incrButton != null) {
                        WebScrollBarUI.this.incrButton.firePropertyChange("decorationStates", 0, 1);
                    }
                    if (WebScrollBarUI.this.decrButton != null) {
                        WebScrollBarUI.this.decrButton.firePropertyChange("decorationStates", 0, 1);
                    }
                } else {
                    parent.propertyChange(evt);
                }
            }
        };
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.scrollbar);
        SwingUtils.removeHandlesEnableStateMark(this.scrollbar);
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.scrollbar);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.scrollbar, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.scrollbar, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public boolean isPaintButtons() {
        return this.paintButtons;
    }

    public void setPaintButtons(boolean paintButtons) {
        this.paintButtons = paintButtons;
        this.scrollbar.revalidate();
        this.scrollbar.repaint();
    }

    public boolean isPaintTrack() {
        return this.paintTrack;
    }

    public void setPaintTrack(boolean paintTrack) {
        this.paintTrack = paintTrack;
        this.scrollbar.revalidate();
        this.scrollbar.repaint();
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.scrollbar, new DataRunnable<IScrollBarPainter>(){

            public void run(IScrollBarPainter newPainter) {
                WebScrollBarUI.this.painter = newPainter;
            }
        }, this.painter, painter, IScrollBarPainter.class, AdaptiveScrollBarPainter.class);
    }

    @Override
    protected void installComponents() {
        this.decrButton = new ScrollBarButton(StyleId.scrollbarDecreaseButton.at(this.scrollbar));
        this.scrollbar.add(this.decrButton);
        this.incrButton = new ScrollBarButton(StyleId.scrollbarIncreaseButton.at(this.scrollbar));
        this.scrollbar.add(this.incrButton);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.setDragged(this.isDragging);
            this.painter.setTrackBounds(this.trackRect);
            this.painter.setThumbBounds(this.thumbRect);
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps;
        boolean ver;
        boolean bl = ver = this.scrollbar.getOrientation() == 1;
        Dimension dimension = this.painter != null ? this.painter.getPreferredSize() : (ps = new Dimension(ver ? 0 : 48, ver ? 48 : 0));
        if (this.painter != null && this.paintButtons && this.decrButton != null && this.incrButton != null) {
            Dimension dps = this.decrButton.getPreferredSize();
            Dimension ips = this.incrButton.getPreferredSize();
            if (ver) {
                ps.width = Math.max(ps.width, Math.max(dps.width, ips.width));
                ps.height += dps.height + ips.height;
            } else {
                ps.width += dps.width + ips.width;
                ps.height = Math.max(ps.height, Math.max(dps.height, ips.height));
            }
        }
        return ps;
    }

    protected class ScrollBarButton
    extends WebButton
    implements Stateful {
        public ScrollBarButton(StyleId id) {
            super(id);
            this.setFocusable(false);
            this.setEnabled(WebScrollBarUI.this.scrollbar != null && WebScrollBarUI.this.scrollbar.isEnabled());
        }

        @Override
        public List<String> getStates() {
            return WebScrollBarUI.this.scrollbar != null ? CollectionUtils.asList((Object[])new String[]{WebScrollBarUI.this.scrollbar.getOrientation() == 0 ? "horizontal" : "vertical"}) : null;
        }

        @Override
        public void setFocusable(boolean focusable) {
            super.setFocusable(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return WebScrollBarUI.this.painter != null && WebScrollBarUI.this.paintButtons ? super.getPreferredSize() : new Dimension(0, 0);
        }
    }
}

